/*
 * Decompiled with CFR 0.152.
 */
package aglobex.web.server;

import aglobe.container.AgentContainer;
import aglobe.container.agent.AgentManager;
import aglobe.container.service.ServiceManager;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;
import aglobe.ontology.Libraries;
import aglobe.ontology.ServiceInfo;
import aglobex.web.server.Cookie;
import aglobex.web.server.HtmlGenerator;
import aglobex.web.server.HttpsServer;
import aglobex.web.server.ImageRequestListener;
import aglobex.web.server.MenuInfo;
import aglobex.web.server.PageKeyTree;
import aglobex.web.server.UserInfo;
import aglobex.web.server.WebRequestListener;
import aglobex.web.server.resources.Void;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessConnection
implements Runnable {
    private static final boolean ENABLE_LOGIN = true;
    private static final int URL_TYPE_AGLOBE = 1;
    private static final int URL_TYPE_STATIC_IMAGE = 2;
    private static final int URL_TYPE_VIRTUAL_IMAGE = 3;
    private static final int URL_TYPE_GENERIC = 4;
    protected HttpsServer httpsServer;
    protected Socket client;
    protected BufferedReader inputStream;
    protected DataOutputStream outputStream;
    protected AgentContainer container;
    protected AgentManager agentManager;
    protected ServiceManager serviceManager;
    protected HtmlGenerator htmlGen;
    protected HashMap<String, String> contentTypeMap;
    protected boolean cmdGet = false;
    protected boolean cmdPost = false;
    protected String url = null;
    protected String cookieID = null;
    protected String dataType = null;
    protected String data = null;
    protected String containerName = null;
    protected boolean typeAgents = false;
    protected boolean typeServices = false;
    protected String entityName = null;
    protected String webPageKey = null;
    protected UserInfo userInfo;
    protected boolean sendCookie;

    public ProcessConnection(HttpsServer httpsServer, Socket socket) {
        this.httpsServer = httpsServer;
        this.client = socket;
        try {
            this.inputStream = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            this.outputStream = new DataOutputStream(this.client.getOutputStream());
        }
        catch (IOException ex) {
            System.out.println("Exception#1: " + ex.getMessage());
        }
        this.container = httpsServer.getWebServerService().getContainer();
        this.agentManager = this.container.getAgentManager();
        this.serviceManager = this.container.getServiceManager();
        this.htmlGen = new HtmlGenerator(httpsServer, this.container);
        this.contentTypeMap = new HashMap();
        this.contentTypeMap.put(".bmp", "image/bmp");
        this.contentTypeMap.put(".gif", "image/gif");
        this.contentTypeMap.put(".jpg", "image/jpeg");
        this.contentTypeMap.put(".png", "image/png");
        this.userInfo = null;
        this.sendCookie = false;
    }

    @Override
    public void run() {
        this.processMain();
        try {
            this.client.close();
        }
        catch (IOException ex) {
            System.out.println("Exception#2: " + ex.getMessage());
        }
    }

    protected void setStateVars(String containerName, boolean typeAgents, boolean typeServices, String entityName) {
        this.containerName = containerName;
        this.typeAgents = typeAgents;
        this.typeServices = typeServices;
        this.entityName = entityName;
    }

    public static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public static String decodeURL(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    protected void processMain() {
        if (!this.parseRequest(this.inputStream)) {
            return;
        }
        if (this.getURLtype(this.url) == 2) {
            this.processCookieValid();
            return;
        }
        this.userInfo = null;
        this.userInfo = this.httpsServer.getUserInfo(this.cookieID);
        this.htmlGen.setUserInfo(this.userInfo);
        if (this.userInfo == null) {
            this.processCookieInvalid();
        } else {
            this.processCookieValid();
        }
    }

    protected void processCookieInvalid() {
        String urlLow;
        if (this.cmdPost && this.dataType.equals("application/x-www-form-urlencoded") && (urlLow = this.url.toLowerCase()).equals("login.html")) {
            HashMap<String, String> loginData = this.parseFormData(this.data);
            this.userInfo = this.checkLoginData(loginData);
            if (this.userInfo != null) {
                this.processLoginOK(loginData);
            } else {
                this.sendLoginPage(true, loginData);
            }
            return;
        }
        HashMap<String, String> loginData = new HashMap<String, String>();
        if (this.cmdGet) {
            loginData.put("cmdget", "true");
        }
        if (this.cmdPost) {
            loginData.put("cmdpost", "true");
        }
        loginData.put("url", this.url);
        loginData.put("datatype", this.dataType);
        loginData.put("data", this.data);
        this.sendLoginPage(false, loginData);
    }

    protected void processLoginOK(HashMap<String, String> loginData) {
        this.httpsServer.registerUser(this.userInfo);
        this.htmlGen.setUserInfo(this.userInfo);
        this.cmdGet = loginData.get("cmdget") != null;
        this.cmdPost = loginData.get("cmdpost") != null;
        this.url = loginData.get("url");
        if (this.url == null) {
            this.url = "";
        } else if (this.url.equalsIgnoreCase("logoff.html")) {
            this.url = "";
        }
        this.cookieID = null;
        this.dataType = loginData.get("datatype");
        this.data = loginData.get("data");
        this.sendCookie = true;
        this.processCookieValid();
    }

    protected void processCookieValid() {
        String urlLow = this.url.toLowerCase();
        String urlPrefix = HtmlGenerator.aglobeURL(this.container.getContainerName());
        String urlPrefixLow = urlPrefix.toLowerCase();
        if (this.cmdPost && this.dataType.equals("application/x-www-form-urlencoded")) {
            HashMap<String, String> formData = this.parseFormData(this.data);
            if (urlLow.equals(String.valueOf(urlPrefixLow) + "/createagent.html")) {
                if (formData.containsKey("submit")) {
                    AgentInfo agentInfo = this.processCreateAgent(formData);
                    if (agentInfo != null) {
                        this.setStateVars(this.container.getContainerName(), true, false, agentInfo.getName());
                        this.sendAgentPage(agentInfo);
                    } else {
                        this.setStateVars(this.container.getContainerName(), true, false, null);
                        this.sendCreateAgent(true, formData.get("agentname"), formData.get("mainclass"), this.processAddNewParam(formData));
                    }
                    return;
                }
                if (formData.containsKey("addparam")) {
                    this.setStateVars(this.container.getContainerName(), true, false, null);
                    this.sendCreateAgent(false, formData.get("agentname"), formData.get("mainclass"), this.processAddNewParam(formData));
                    return;
                }
                return;
            }
            if (urlLow.equals(String.valueOf(urlPrefixLow) + "/createservice.html")) {
                if (formData.containsKey("submit")) {
                    ServiceInfo serviceInfo = this.processCreateService(formData);
                    if (serviceInfo != null) {
                        this.setStateVars(this.container.getContainerName(), false, true, serviceInfo.getName());
                        this.sendServicePage(serviceInfo);
                    } else {
                        this.setStateVars(this.container.getContainerName(), false, true, null);
                        this.sendCreateService(true, formData.get("servicename"), formData.get("mainclass"));
                    }
                    return;
                }
                return;
            }
        } else {
            if (urlLow.equals("logoff.html")) {
                if (this.httpsServer.deregisterUser(this.cookieID)) {
                    this.userInfo = null;
                    this.htmlGen.setUserInfo(this.userInfo);
                    this.sendLoginPage(false, null);
                }
                return;
            }
            if (urlLow.equals(String.valueOf(urlPrefixLow) + "/createagenttemp.html")) {
                if (!this.userInfo.canCreate()) {
                    return;
                }
                this.setStateVars(this.container.getContainerName(), true, false, null);
                this.sendTemporaryPage("Create agent", "Loading data...<BR><BR>Wait please.\n", "/" + urlPrefix + "/createagent.html");
                return;
            }
            if (urlLow.equals(String.valueOf(urlPrefixLow) + "/createagent.html")) {
                if (!this.userInfo.canCreate()) {
                    return;
                }
                this.setStateVars(this.container.getContainerName(), true, false, null);
                this.sendCreateAgent(false, null, null, null);
                return;
            }
            if (urlLow.equals(String.valueOf(urlPrefixLow) + "/createservicetemp.html")) {
                if (!this.userInfo.canCreate()) {
                    return;
                }
                this.setStateVars(this.container.getContainerName(), false, true, null);
                this.sendTemporaryPage("Create service", "Loading data...<BR><BR>Wait please.\n", "/" + urlPrefix + "/createservice.html");
                return;
            }
            if (urlLow.equals(String.valueOf(urlPrefixLow) + "/createservice.html")) {
                if (!this.userInfo.canCreate()) {
                    return;
                }
                this.setStateVars(this.container.getContainerName(), false, true, null);
                this.sendCreateService(false, null, null);
                return;
            }
            if (urlLow.startsWith(String.valueOf(urlPrefixLow) + "/killagent.html?")) {
                if (!this.userInfo.canKill()) {
                    return;
                }
                this.processKillAgent(this.url.substring(urlPrefixLow.length() + 16));
                this.setStateVars(this.container.getContainerName(), true, false, null);
                this.sendContainerPage();
                return;
            }
            if (urlLow.startsWith(String.valueOf(urlPrefixLow) + "/killservice.html?")) {
                if (!this.userInfo.canKill()) {
                    return;
                }
                this.processKillService(this.url.substring(urlPrefixLow.length() + 18));
                this.setStateVars(this.container.getContainerName(), false, true, null);
                this.sendContainerPage();
                return;
            }
            int urlType = this.getURLtype(this.url);
            switch (urlType) {
                case 1: {
                    this.parseAglobeURL(this.url);
                    this.processPageRequest();
                    return;
                }
                case 2: {
                    this.sendFile(this.translateFileURL(this.url));
                    return;
                }
                case 3: {
                    this.parseAglobeURL(this.url);
                    this.processVirtualImageRequest();
                    return;
                }
                case 4: {
                    this.sendHomepage();
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean parseRequest(BufferedReader inputStream) {
        try {
            String s = inputStream.readLine();
            if (s == null) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(s);
            if (st.countTokens() < 2) {
                return false;
            }
            String token = st.nextToken().toUpperCase();
            if (token.equals("GET")) {
                this.cmdGet = true;
            } else if (token.equals("POST")) {
                this.cmdPost = true;
            } else {
                return false;
            }
            this.url = ProcessConnection.decodeURL(st.nextToken());
            if (this.url.startsWith("/")) {
                this.url = this.url.substring(1);
            }
            int dataLength = 0;
            block2: while (true) {
                if ((s = inputStream.readLine()) == null) {
                    return false;
                }
                String su = s.toUpperCase();
                if (su.startsWith("COOKIE:")) {
                    st = new StringTokenizer(s, ":; \t");
                    if (st.countTokens() < 2) continue;
                    st.nextToken();
                    do {
                        if (!st.hasMoreTokens()) continue block2;
                    } while (!(token = st.nextToken()).toUpperCase().startsWith("SID="));
                    this.cookieID = token;
                    continue;
                }
                if (su.startsWith("CONTENT-TYPE:")) {
                    st = new StringTokenizer(s, ": \t");
                    if (st.countTokens() != 2) continue;
                    st.nextToken();
                    this.dataType = st.nextToken();
                    continue;
                }
                if (su.startsWith("CONTENT-LENGTH:")) {
                    st = new StringTokenizer(s, ": \t");
                    if (st.countTokens() != 2) continue;
                    st.nextToken();
                    dataLength = Integer.parseInt(st.nextToken());
                    continue;
                }
                if (su.length() == 0) break;
            }
            if (this.dataType != null && dataLength > 0) {
                char[] buffer = new char[dataLength];
                if (inputStream.read(buffer, 0, dataLength) != dataLength) {
                    this.dataType = null;
                    dataLength = 0;
                } else {
                    this.data = new String(buffer);
                }
            }
            return true;
        }
        catch (IOException ex) {
            System.out.println("Exception#3: " + ex.getMessage());
            return false;
        }
    }

    protected int getURLtype(String url) {
        String s = url.toLowerCase();
        if (s.equals("aglobe") || s.startsWith("aglobe/")) {
            if (s.endsWith(".png") || s.contains(".png?")) {
                return 3;
            }
            return 1;
        }
        if (s.equals("images") || s.startsWith("images/")) {
            return 2;
        }
        return 4;
    }

    protected void parseAglobeURL(String url) {
        this.containerName = null;
        this.typeAgents = false;
        this.typeServices = false;
        this.entityName = null;
        if (url == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(url, "/");
        if (!st.hasMoreTokens()) {
            return;
        }
        if (!st.nextToken().toLowerCase().equals("aglobe")) {
            return;
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        this.containerName = st.nextToken();
        if (!st.hasMoreTokens()) {
            return;
        }
        String token = st.nextToken();
        if (token.equalsIgnoreCase("agents")) {
            this.typeAgents = true;
        } else if (token.equalsIgnoreCase("services")) {
            this.typeServices = true;
        } else {
            return;
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        this.entityName = st.nextToken().replace('_', '/');
        if (!st.hasMoreTokens()) {
            return;
        }
        this.webPageKey = st.nextToken();
        while (st.hasMoreTokens()) {
            this.webPageKey = String.valueOf(this.webPageKey) + "/" + st.nextToken();
        }
    }

    protected URL translateFileURL(String url) {
        if (this.getURLtype(url) == 2) {
            url = url.substring(7);
            return Void.class.getResource(url);
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    protected HashMap<String, String> parseFormData(String data) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (data == null) {
            return map;
        }
        StringTokenizer st = new StringTokenizer(data, "&");
        while (st.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st.nextToken(), "=");
            if (st2.countTokens() != 2) continue;
            String key = ProcessConnection.decodeURL(st2.nextToken());
            String value = ProcessConnection.decodeURL(st2.nextToken());
            map.put(key, value);
        }
        return map;
    }

    protected UserInfo checkLoginData(HashMap<String, String> loginData) {
        String login = loginData.get("login");
        if (login == null) {
            return null;
        }
        String password = loginData.get("password");
        if (password == null) {
            return null;
        }
        if (login.equals("admin") && password.equals(".")) {
            return new UserInfo(login, true, true);
        }
        if (login.equals("guest") && password.equals(".")) {
            return new UserInfo(login, false, false);
        }
        return null;
    }

    protected void processPageRequest() {
        if (this.entityName == null) {
            this.sendContainerPage();
            return;
        }
        if (this.typeAgents) {
            AgentInfo agentInfo = this.agentManager.getAgentInfo(this.entityName);
            if (agentInfo != null) {
                this.sendAgentPage(agentInfo);
            } else {
                this.sendContainerPage();
            }
            return;
        }
        if (this.typeServices) {
            ServiceInfo serviceInfo = this.serviceManager.getServiceInfo(this.entityName);
            if (serviceInfo != null) {
                this.sendServicePage(serviceInfo);
            } else {
                this.sendContainerPage();
            }
            return;
        }
        this.sendHomepage();
    }

    protected void processVirtualImageRequest() {
        ImageRequestListener listener;
        if (this.containerName == null || this.entityName == null || this.webPageKey == null) {
            this.sendNotFound();
            return;
        }
        int index = this.webPageKey.lastIndexOf("/");
        String key = index < 0 ? this.webPageKey : this.webPageKey.substring(index + 1);
        index = key.indexOf("?");
        if (index >= 0) {
            key = key.substring(0, index);
        }
        if (this.typeAgents) {
            listener = this.httpsServer.getAgentImageListener(this.entityName, key);
        } else if (this.typeServices) {
            listener = this.httpsServer.getServiceImageListener(this.entityName, key);
        } else {
            this.sendNotFound();
            return;
        }
        InputStream inputStream = null;
        if (listener != null) {
            inputStream = listener.getImagePNGContent(key);
        }
        if (inputStream != null) {
            this.sendPNGImage(inputStream);
        } else {
            this.sendNotFound();
        }
    }

    protected AgentInfo processCreateAgent(HashMap<String, String> formData) {
        String value;
        String name;
        AgentInfo info = new AgentInfo();
        String agentName = formData.get("agentname");
        if (agentName == null) {
            return null;
        }
        info.setName(agentName);
        info.setReadableName(agentName);
        info.setType("");
        String mainClass = formData.get("mainclass");
        if (mainClass == null) {
            return null;
        }
        info.setMainClass(mainClass);
        info.setLibraries(new Libraries());
        List<AglobeParam> params = info.getAglobeParam();
        int id = 1;
        while ((name = formData.get("paramName" + id)) != null && (value = formData.get("paramValue" + id)) != null) {
            if (name.length() > 0) {
                AglobeParam p = new AglobeParam();
                p.setName(name);
                p.setValue(value);
                params.add(p);
            }
            ++id;
        }
        try {
            this.agentManager.createAgent(info, false);
        }
        catch (Exception ex) {
            return null;
        }
        return info;
    }

    protected ServiceInfo processCreateService(HashMap<String, String> formData) {
        ServiceInfo info = new ServiceInfo();
        String serviceName = formData.get("servicename");
        if (serviceName == null) {
            return null;
        }
        info.setName(serviceName);
        String mainClass = formData.get("mainclass");
        if (mainClass == null) {
            return null;
        }
        info.setMainClass(mainClass);
        info.setLibraries(new Libraries());
        try {
            this.serviceManager.registerService(info);
        }
        catch (Exception ex) {
            return null;
        }
        return info;
    }

    protected LinkedList<AglobeParam> processAddNewParam(HashMap<String, String> formData) {
        String value;
        String name;
        LinkedList<AglobeParam> params = new LinkedList<AglobeParam>();
        int id = 1;
        while ((name = formData.get("paramName" + id)) != null && (value = formData.get("paramValue" + id)) != null) {
            if (name.length() > 0) {
                AglobeParam param = new AglobeParam();
                param.setName(name);
                param.setValue(value);
                params.add(param);
            }
            ++id;
        }
        String name2 = formData.get("newParamName");
        String value2 = formData.get("newParamValue");
        if (name2 != null && value2 != null && name2.length() > 0) {
            AglobeParam param = new AglobeParam();
            param.setName(name2);
            param.setValue(value2);
            params.add(param);
        }
        return params;
    }

    protected void processKillAgent(String agentName) {
        this.agentManager.killAgent(agentName);
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void processKillService(String serviceName) {
        this.serviceManager.deregisterService(serviceName);
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void sendHTML(String content) {
        String s = new String();
        try {
            s = String.valueOf(s) + "HTTP/1.0 200 OK\r\n";
            if (this.sendCookie && this.userInfo != null) {
                Cookie cookie = this.userInfo.getCookie();
                s = String.valueOf(s) + "Set-Cookie: " + cookie.getID() + ";Secure\r\n";
            }
            s = String.valueOf(s) + "Cache-Control: max-age=0, must-revalidate\r\nContent-Type: text/html\r\nContent-Length: " + content.length() + "\r\n" + "\r\n" + content;
            this.outputStream.writeBytes(s);
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void sendNotFound() {
        try {
            this.outputStream.writeBytes("HTTP/1.0 404 not found\r\n\r\n");
            this.outputStream.flush();
        }
        catch (IOException e) {
            System.out.println("Exception#4: " + e.getMessage());
        }
    }

    protected void sendRedirect(String urlNew) {
        String s = new String();
        try {
            s = String.valueOf(s) + "HTTP/1.0 303\r\n";
            s = String.valueOf(s) + "Location: " + urlNew + "\r\n";
            s = String.valueOf(s) + "\r\n";
            this.outputStream.writeBytes(s);
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void sendFile(URL url) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(new File(url.toURI()));
        }
        catch (Exception ex) {
            this.sendNotFound();
            return;
        }
        try {
            String contentType = null;
            String filename = url.getFile();
            int ext = filename.lastIndexOf(".");
            if (ext > 0) {
                contentType = this.contentTypeMap.get(filename.substring(ext));
            }
            if (contentType == null) {
                contentType = "unknown/unknown";
            }
            int contentLength = ((InputStream)is).available();
            this.outputStream.writeBytes("HTTP/1.0 200 OK\r\nCache-Control: max-age=0, must-revalidate\r\nContent-Type: " + contentType + "\r\n" + "Content-Length: " + contentLength + "\r\n" + "\r\n");
            byte[] buffer = new byte[contentLength];
            ((InputStream)is).read(buffer);
            this.outputStream.write(buffer);
            this.outputStream.flush();
        }
        catch (IOException ex) {
            System.out.println("Exception#5: " + ex.getMessage());
        }
    }

    protected void sendPNGImage(InputStream inputStream) {
        try {
            int contentLength = inputStream.available();
            this.outputStream.writeBytes("HTTP/1.0 200 OK\r\nCache-Control: max-age=0, must-revalidate\r\nContent-Type: image/png\r\nContent-Length: " + contentLength + "\r\n" + "\r\n");
            byte[] buffer = new byte[contentLength];
            inputStream.read(buffer);
            this.outputStream.write(buffer);
            this.outputStream.flush();
        }
        catch (IOException ex) {
            System.out.println("Exception#6: " + ex.getMessage());
        }
    }

    protected String buildMenu() {
        MenuInfo menuInfo = new MenuInfo();
        menuInfo.url = "aglobe";
        if (this.containerName != null && this.containerName.equals(this.container.getContainerName())) {
            menuInfo.selContainer = this.container;
            menuInfo.url = String.valueOf(menuInfo.url) + "/" + this.containerName;
        }
        menuInfo.agentsExpanded = this.typeAgents;
        if (menuInfo.agentsExpanded) {
            menuInfo.url = String.valueOf(menuInfo.url) + "/agents";
            if (this.entityName != null) {
                menuInfo.selAgent = this.agentManager.getAgentInfo(this.entityName);
            }
        }
        menuInfo.servicesExpanded = this.typeServices;
        if (menuInfo.servicesExpanded) {
            menuInfo.url = String.valueOf(menuInfo.url) + "/services";
            if (this.entityName != null) {
                menuInfo.selService = this.serviceManager.getServiceInfo(this.entityName);
            }
        }
        menuInfo.webPageKey = this.webPageKey;
        if (menuInfo.selAgent != null || menuInfo.selService != null) {
            menuInfo.url = String.valueOf(menuInfo.url) + "/" + this.entityName.replace("/", "_");
            if (this.webPageKey != null) {
                menuInfo.url = String.valueOf(menuInfo.url) + "/" + this.webPageKey;
            }
        }
        return this.htmlGen.menu(menuInfo);
    }

    protected void sendLoginPage(boolean prevLoginFailed, HashMap<String, String> loginData) {
        String html = this.htmlGen.htmlPageTemplate(null, "Login", this.htmlGen.loginPage(prevLoginFailed, loginData));
        this.sendHTML(html);
    }

    protected void sendHomepage() {
        this.setStateVars(null, false, false, null);
        String html = this.htmlGen.htmlPageTemplate(this.buildMenu(), null, null);
        this.sendHTML(html);
    }

    protected void sendContainerPage() {
        String html = this.htmlGen.htmlPageTemplate(this.buildMenu(), "container&nbsp;&nbsp;" + this.container.getContainerName(), this.htmlGen.containerPage());
        this.sendHTML(html);
    }

    protected void sendAgentPage(AgentInfo agentInfo) {
        WebRequestListener listener;
        PageKeyTree tree = this.httpsServer.getAgentKeyTree(agentInfo.getName());
        String webPageContent = null;
        int refreshRate = 0;
        if (tree != null && this.webPageKey != null && (listener = tree.getListener(this.webPageKey)) != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            webPageContent = listener.getWebPageContent(this.webPageKey, params);
            refreshRate = listener.refreshRate();
        }
        String contentTitle = "agent&nbsp;&nbsp;" + agentInfo.getName();
        if (webPageContent != null) {
            contentTitle = String.valueOf(contentTitle) + "&nbsp;&nbsp;/" + this.webPageKey;
        }
        String html = this.htmlGen.htmlPageTemplate(refreshRate != 0 ? "<META http-equiv=\"refresh\" content=\"" + refreshRate + "\">\n" : null, this.buildMenu(), contentTitle, this.htmlGen.agentPage(agentInfo, webPageContent));
        this.sendHTML(html);
    }

    protected void sendServicePage(ServiceInfo serviceInfo) {
        WebRequestListener listener;
        PageKeyTree tree = this.httpsServer.getAgentKeyTree(serviceInfo.getName());
        String webPageContent = null;
        int refreshRate = 0;
        if (tree != null && this.webPageKey != null && (listener = tree.getListener(this.webPageKey)) != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            webPageContent = listener.getWebPageContent(this.webPageKey, params);
            refreshRate = listener.refreshRate();
        }
        String contentTitle = "service&nbsp;&nbsp;" + serviceInfo.getName();
        if (webPageContent != null) {
            contentTitle = String.valueOf(contentTitle) + "&nbsp;&nbsp;/" + this.webPageKey;
        }
        String html = this.htmlGen.htmlPageTemplate(refreshRate != 0 ? "<META http-equiv=\"refresh\" content=\"" + refreshRate + "\">\n" : null, this.buildMenu(), contentTitle, this.htmlGen.servicePage(serviceInfo, webPageContent));
        this.sendHTML(html);
    }

    protected void sendTemporaryPage(String contentTitle, String content, String nextURL) {
        String html = this.htmlGen.htmlPageTemplate("<META http-equiv=\"refresh\" content=\"0;url=" + nextURL + "\">\n", this.buildMenu(), contentTitle, content);
        this.sendHTML(html);
    }

    protected void sendCreateAgent(boolean prevFailed, String agentName, String nameClass, LinkedList<AglobeParam> params) {
        String html = this.htmlGen.htmlPageTemplate(this.buildMenu(), "Create agent", this.htmlGen.formCreateAgent(prevFailed, agentName, nameClass, params));
        this.sendHTML(html);
    }

    protected void sendCreateService(boolean prevFailed, String serviceName, String mainClass) {
        String html = this.htmlGen.htmlPageTemplate(this.buildMenu(), "Create service", this.htmlGen.formCreateService(prevFailed, serviceName, mainClass));
        this.sendHTML(html);
    }
}

