/*
 * Decompiled with CFR 0.152.
 */
package aglobex.web.server;

import aglobex.web.server.WebRequestListener;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class PageKeyTree {
    protected Item tree = new Item("", null);
    protected HashMap<String, WebRequestListener> map = new HashMap();

    public boolean add(String key, WebRequestListener listener, boolean sorted) {
        StringTokenizer st = new StringTokenizer(key, "/");
        if (!st.hasMoreTokens()) {
            return false;
        }
        Item item = this.tree;
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            boolean isLast = st.hasMoreTokens();
            Item child = item.getChild(name);
            if (child == null) {
                child = isLast ? new Item(name, listener) : new Item(name, null);
                item.addChild(child, sorted);
            } else if (isLast) {
                child.setListener(listener);
            }
            item = child;
        }
        this.map.put(key, listener);
        return true;
    }

    public boolean remove(String key) {
        StringTokenizer st = new StringTokenizer(key, "/");
        if (!st.hasMoreTokens()) {
            return false;
        }
        Item item = this.tree;
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            boolean isLast = !st.hasMoreTokens();
            Item child = item.getChild(name);
            if (child == null) {
                return false;
            }
            if (isLast) {
                if (child.hasChildren()) {
                    return false;
                }
                item.removeChild(name);
                continue;
            }
            item = child;
        }
        this.map.remove(key);
        return true;
    }

    public WebRequestListener getListener(String key) {
        return this.map.get(key);
    }

    public Item getTreeRoot() {
        return this.tree;
    }

    public void print() {
        this.print(this.tree, 0);
        System.out.println();
    }

    protected void print(Item item, int offset) {
        int i = 0;
        while (i < offset) {
            System.out.print(" ");
            ++i;
        }
        System.out.println(String.valueOf(item.getName()) + ": " + item.getListener());
        Vector<Item> children = item.getChildren();
        int i2 = 0;
        while (i2 < children.size()) {
            this.print(children.get(i2), offset + 3);
            ++i2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Item {
        protected String name;
        protected WebRequestListener listener;
        protected Vector<Item> children;

        public Item(String name, WebRequestListener listener) {
            this.name = name;
            this.listener = listener;
            this.children = new Vector();
        }

        public String getName() {
            return this.name;
        }

        public WebRequestListener getListener() {
            return this.listener;
        }

        public void setListener(WebRequestListener listener) {
            this.listener = listener;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public Vector<Item> getChildren() {
            return this.children;
        }

        public boolean addChild(Item item, boolean sorted) {
            String itemName = item.getName();
            if (this.getChild(itemName) != null) {
                return false;
            }
            if (sorted) {
                int size = this.children.size();
                int i = 0;
                while (i < size) {
                    Item c = this.children.get(i);
                    if (itemName.compareToIgnoreCase(c.getName()) < 0) {
                        this.children.add(i, item);
                        return true;
                    }
                    ++i;
                }
            }
            this.children.add(item);
            return true;
        }

        public boolean removeChild(String name) {
            int size = this.children.size();
            int i = 0;
            while (i < size) {
                Item item = this.children.get(i);
                if (name.equals(item.getName())) {
                    this.children.remove(i);
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Item getChild(String name) {
            int size = this.children.size();
            int i = 0;
            while (i < size) {
                Item item = this.children.get(i);
                if (name.equals(item.getName())) {
                    return item;
                }
                ++i;
            }
            return null;
        }
    }
}

