/*
 * Decompiled with CFR 0.152.
 */
package aglobex.web.server;

import aglobe.container.ElementaryEntity;
import aglobe.container.transport.Address;
import aglobe.platform.thread.AglobeThreadPool;
import aglobex.web.server.Cookie;
import aglobex.web.server.ImageKeyMap;
import aglobex.web.server.ImageRequestListener;
import aglobex.web.server.PageKeyTree;
import aglobex.web.server.ProcessConnection;
import aglobex.web.server.UserInfo;
import aglobex.web.server.WebRequestListener;
import aglobex.web.server.WebServerService;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class HttpsServer
implements Runnable {
    protected static final int HTTPS_PORT = 443;
    protected static final String keystore = "serverkeys.bin";
    protected static final char[] keystorepass = "password1".toCharArray();
    protected static final char[] keypassword = "password2".toCharArray();
    protected WebServerService webServerService;
    protected Random random;
    protected Vector<UserInfo> activeUsers;
    protected HashMap<String, PageKeyTree> agentWebPages;
    protected HashMap<String, PageKeyTree> serviceWebPages;
    protected HashMap<String, ImageKeyMap> agentImages;
    protected HashMap<String, ImageKeyMap> serviceImages;
    protected long webImageCounter;
    protected HashMap<String, ImageRequestListener> webImages;

    public HttpsServer(WebServerService webServerService) {
        this.webServerService = webServerService;
        this.random = new Random();
        this.activeUsers = new Vector();
        this.agentWebPages = new HashMap();
        this.serviceWebPages = new HashMap();
        this.agentImages = new HashMap();
        this.serviceImages = new HashMap();
        new Timer().scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Vector<UserInfo> vector = HttpsServer.this.activeUsers;
                synchronized (vector) {
                    long currTime = System.currentTimeMillis();
                    int i = HttpsServer.this.activeUsers.size() - 1;
                    while (i >= 0) {
                        Cookie cookie = HttpsServer.this.activeUsers.get(i).getCookie();
                        if (cookie.isExpired(currTime)) {
                            HttpsServer.this.activeUsers.remove(i);
                        }
                        --i;
                    }
                }
            }
        }, 0L, 5000L);
        Thread serverThread = AglobeThreadPool.getThread(this, "WebServerThread");
        serverThread.start();
    }

    public WebServerService getWebServerService() {
        return this.webServerService;
    }

    public ServerSocket getServer() throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(WebServerService.class.getResourceAsStream(keystore), keystorepass);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, keypassword);
        SSLContext sslcontext = SSLContext.getInstance("SSLv3");
        sslcontext.init(kmf.getKeyManagers(), null, null);
        SSLServerSocketFactory ssf = sslcontext.getServerSocketFactory();
        SSLServerSocket serversocket = (SSLServerSocket)ssf.createServerSocket(443);
        return serversocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUser(UserInfo userInfo) {
        String id = "SID=" + Math.abs(this.random.nextLong());
        Cookie cookie = new Cookie(id, System.currentTimeMillis());
        userInfo.setCookie(cookie);
        String userName = userInfo.getName();
        Vector<UserInfo> vector = this.activeUsers;
        synchronized (vector) {
            int i = this.activeUsers.size() - 1;
            while (i >= 0) {
                if (this.activeUsers.get(i).getName().equals(userName)) {
                    this.activeUsers.remove(i);
                    break;
                }
                --i;
            }
            this.activeUsers.add(userInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deregisterUser(String cookieID) {
        Vector<UserInfo> vector = this.activeUsers;
        synchronized (vector) {
            int i = this.activeUsers.size() - 1;
            while (true) {
                if (i < 0) {
                    return false;
                }
                Cookie cookie = this.activeUsers.get(i).getCookie();
                if (cookie.getID().equals(cookieID)) {
                    this.activeUsers.remove(i);
                    return true;
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfo getUserInfo(String cookieID) {
        if (cookieID == null) {
            return null;
        }
        Vector<UserInfo> vector = this.activeUsers;
        synchronized (vector) {
            int i = this.activeUsers.size() - 1;
            while (i >= 0) {
                UserInfo userInfo = this.activeUsers.get(i);
                Cookie cookie = userInfo.getCookie();
                if (cookie.getID().equals(cookieID)) {
                    cookie.setTimestamp(System.currentTimeMillis());
                    return userInfo;
                }
                --i;
            }
            return null;
        }
    }

    public boolean registerWebPage(ElementaryEntity owner, String key, boolean sorted, WebRequestListener listener) {
        HashMap<String, PageKeyTree> map;
        Address address = owner.getAddress();
        if (address == null) {
            return false;
        }
        if (address.isAgent()) {
            map = this.agentWebPages;
        } else if (address.isService()) {
            map = this.serviceWebPages;
        } else {
            return false;
        }
        String name = address.getName();
        PageKeyTree tree = map.get(name);
        if (tree == null) {
            tree = new PageKeyTree();
            map.put(name, tree);
        }
        tree.remove(key);
        return tree.add(key, listener, sorted);
    }

    public boolean deregisterWebPage(ElementaryEntity owner, String key) {
        HashMap<String, PageKeyTree> map;
        Address address = owner.getAddress();
        if (address == null) {
            return false;
        }
        if (address.isAgent()) {
            map = this.agentWebPages;
        } else if (address.isService()) {
            map = this.serviceWebPages;
        } else {
            return false;
        }
        PageKeyTree keytree = map.get(address.getName());
        if (keytree == null) {
            return false;
        }
        return keytree.remove(key);
    }

    public PageKeyTree getAgentKeyTree(String agentName) {
        return this.agentWebPages.get(agentName);
    }

    public PageKeyTree getServiceKeyTree(String serviceName) {
        return this.serviceWebPages.get(serviceName);
    }

    public String registerImage(ElementaryEntity owner, ImageRequestListener listener) {
        HashMap<String, ImageKeyMap> map;
        Address address = owner.getAddress();
        if (address == null) {
            return null;
        }
        if (address.isAgent()) {
            map = this.agentImages;
        } else if (address.isService()) {
            map = this.serviceImages;
        } else {
            return null;
        }
        String name = address.getName();
        ImageKeyMap keymap = map.get(name);
        if (keymap == null) {
            keymap = new ImageKeyMap();
            map.put(name, keymap);
        }
        String key = keymap.generateKey();
        keymap.add(key, listener);
        return key;
    }

    public boolean deregisterImage(ElementaryEntity owner, String key) {
        HashMap<String, ImageKeyMap> map;
        Address address = owner.getAddress();
        if (address == null) {
            return false;
        }
        if (address.isAgent()) {
            map = this.agentImages;
        } else if (address.isService()) {
            map = this.serviceImages;
        } else {
            return false;
        }
        ImageKeyMap keymap = map.get(address.getName());
        if (keymap == null) {
            return false;
        }
        return keymap.remove(key);
    }

    public ImageRequestListener getAgentImageListener(String agentName, String key) {
        ImageKeyMap keymap = this.agentImages.get(agentName);
        if (keymap == null) {
            return null;
        }
        return keymap.getListener(key);
    }

    public ImageRequestListener getServiceImageListener(String serviceName, String key) {
        ImageKeyMap keymap = this.serviceImages.get(serviceName);
        if (keymap == null) {
            return null;
        }
        return keymap.getListener(key);
    }

    public void run() {
        try {
            ServerSocket listen = this.getServer();
            while (true) {
                Socket client = listen.accept();
                AglobeThreadPool.getThread(new ProcessConnection(this, client), "Process connection thread");
            }
        }
        catch (Exception ex) {
            System.out.println("Exception:" + ex.getMessage());
            return;
        }
    }
}

