/*
 * Decompiled with CFR 0.152.
 */
package aglobex.web.server;

import aglobe.container.AgentContainer;
import aglobe.container.agent.AgentManager;
import aglobe.container.service.ServiceManager;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;
import aglobe.ontology.Libraries;
import aglobe.ontology.ServiceInfo;
import aglobex.web.server.HttpsServer;
import aglobex.web.server.MenuInfo;
import aglobex.web.server.PageKeyTree;
import aglobex.web.server.UserInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlGenerator {
    private static final String SERVER_IP = "192.168.0.2";
    private static final String BASE_URL = "https://192.168.0.2/";
    private HttpsServer httpsServer;
    private AgentContainer container;
    private String containerName;
    private AgentManager agentManager;
    private ServiceManager serviceManager;
    private String bodyAttribs;
    private UserInfo userInfo;

    public HtmlGenerator(HttpsServer httpsServer, AgentContainer container) {
        this.httpsServer = httpsServer;
        this.container = container;
        this.containerName = container.getContainerName();
        this.agentManager = container.getAgentManager();
        this.serviceManager = container.getServiceManager();
        this.bodyAttribs = "onLoad=\"setTimeout('doRefresh()', 2000)\"";
        this.userInfo = null;
    }

    public void setBodyAttribs(String bodyAttribs) {
        this.bodyAttribs = bodyAttribs;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public static String aglobeURL(String urlRel) {
        return "aglobe/" + urlRel;
    }

    public static String containerURL(String containerName) {
        return "aglobe/" + containerName;
    }

    public static String agentURL(String containerName, String agentName) {
        return "aglobe/" + containerName + "/agents/" + agentName;
    }

    public static String serviceURL(String containerName, String serviceName) {
        return "aglobe/" + containerName + "/services/" + serviceName;
    }

    public static String imageURL(String urlRel) {
        return "images/" + urlRel;
    }

    public static String genericURL(String urlRel) {
        return urlRel;
    }

    private String a(String url, String content) {
        return "<A href=\"" + url + "\">" + content + "</A>";
    }

    private String ax(String url, String attribs, String content) {
        return "<A href=\"" + url + "\" " + attribs + ">" + content + "</A>";
    }

    private String img(String url, int width, int height) {
        return "<IMG src=\"" + url + "\" width=\"" + width + "\" height=\"" + height + "\">";
    }

    private String imgx(String attribs, String url, int width, int height) {
        return "<IMG src=\"" + url + "\" width=\"" + width + "\" height=\"" + height + "\" attribs=\"" + attribs + "\">";
    }

    private String tr(String content) {
        return "<TR>" + content + "</TR>";
    }

    private String trx(String attribs, String content) {
        return "<TR " + attribs + ">" + content + "</TR>";
    }

    private String td(String content) {
        return "<TD>" + content + "</TD>";
    }

    private String tdx(String attribs, String content) {
        return "<TD " + attribs + ">" + content + "</TD>";
    }

    private String cssRules() {
        String s = new String();
        s = String.valueOf(s) + "HTML { width: 100%; height: 123% }\n";
        s = String.valueOf(s) + "BODY { width: 100%; height: 80%; margin: 0px }\n";
        s = String.valueOf(s) + "TABLE.mainFrame { width: 100%; height: 100% }\n";
        s = String.valueOf(s) + "TABLE.mainFrame TD.bar { height: 60px; background: url(images/bar.png); background-repeat: repeat-x }\n";
        s = String.valueOf(s) + "TABLE.mainFrame TD.barsep { width: 10px; height: 60px; background: url(images/barsep.png); background-repeat: no-repeat }\n";
        s = String.valueOf(s) + "TABLE.mainFrame TD.sepv { width: 10px; background: url(images/sepv.png); background-repeat: repeat-y }\n";
        s = String.valueOf(s) + "TABLE.mainFrame TD.seph { height: 10px; background: url(images/seph.png); background-repeat: repeat-x }\n";
        s = String.valueOf(s) + "TABLE.mainFrame TD.sepcross { width: 10px; height: 10px; background: url(images/sepcross.png); background-repeat: no-repeat }\n";
        s = String.valueOf(s) + "TABLE.mainFrame TR.bottom { height: 50px }\n";
        s = String.valueOf(s) + "TABLE.mainFrame TR.bottom TD.logos { padding-left: 10px }\n";
        s = String.valueOf(s) + "BODY { font-family: Arial; background-color: #EEEEEE }\n";
        s = String.valueOf(s) + "TABLE { font-size: inherit }\n";
        s = String.valueOf(s) + "IMG { border: 0px }\n";
        s = String.valueOf(s) + "INPUT { border: 1px solid black }\n";
        s = String.valueOf(s) + "INPUT { font-family: Arial; font-size: 9pt }\n";
        s = String.valueOf(s) + "SELECT { font-family: Arial; font-size: 9pt }\n";
        s = String.valueOf(s) + "OPTION { font-family: Arial; font-size: 9pt }\n";
        s = String.valueOf(s) + "A:link { color: black }\n";
        s = String.valueOf(s) + "A:active { color: black }\n";
        s = String.valueOf(s) + "A:visited { color: black }\n";
        s = String.valueOf(s) + "DIV.menuBlock { font-size: 9pt; padding-left: 10px }\n";
        s = String.valueOf(s) + "DIV.menuBlock TABLE { border-collapse: collapse }\n";
        s = String.valueOf(s) + "DIV.menuBlock IMG { vertical-align: middle }\n";
        s = String.valueOf(s) + "DIV.menuBlock A { text-decoration: none }\n";
        s = String.valueOf(s) + "DIV.menuBlock A:link { color: black }\n";
        s = String.valueOf(s) + "DIV.menuBlock A:active { color: black }\n";
        s = String.valueOf(s) + "DIV.menuBlock A:visited { color: black }\n";
        s = String.valueOf(s) + "DIV.menuBlock TD { white-space: nowrap }\n";
        s = String.valueOf(s) + "DIV.menuBlock TD.containerName { font-weight: bold }\n";
        s = String.valueOf(s) + "DIV.menuBlock TD.agentName { font-weight: bold }\n";
        s = String.valueOf(s) + "DIV.menuBlock TD.serviceName { font-weight: bold }\n";
        s = String.valueOf(s) + "DIV.menuBlock TD.pageName { font-weight: bold }\n";
        s = String.valueOf(s) + "DIV.menuBlock TD.emptyList { font-style: italic }\n";
        s = String.valueOf(s) + "DIV.menuBlock TABLE.webPagesTree A:link { color: #2A3A8C }\n";
        s = String.valueOf(s) + "DIV.menuBlock TABLE.webPagesTree A:active { color: #2A3A8C }\n";
        s = String.valueOf(s) + "DIV.menuBlock TABLE.webPagesTree A:visited { color: #2A3A8C }\n";
        s = String.valueOf(s) + "DIV.contentTitle { font-size: 12pt; font-weight: bold; padding-left: 10px; padding-top: 12px }\n";
        s = String.valueOf(s) + "DIV.userInfo { font-size: 12pt; font-weight: bold; padding-top: 12px; padding-right: 10px }\n";
        s = String.valueOf(s) + "DIV.contentBlock { font-size: 9pt; padding-left: 10px }\n";
        s = String.valueOf(s) + "DIV.loginBlock {}\n";
        s = String.valueOf(s) + "DIV.entityBasicInfo TD.itemContent { width: 400px; background-color: #D9E3ED; padding: 3px; border: 1px solid #808080 }\n";
        s = String.valueOf(s) + "DIV.entityBasicInfo TD.paramTable { padding: 0px }\n";
        s = String.valueOf(s) + "DIV.entityBasicInfo TD.paramTable TABLE { width: 100% }\n";
        s = String.valueOf(s) + "DIV.entityBasicInfo TD.headerName, DIV.entityBasicInfo TD.headerValue { border: 1px solid #808080; padding-left: 5px; background-color: #BED5EB }\n";
        s = String.valueOf(s) + "DIV.entityBasicInfo TD.listNames, DIV.entityBasicInfo TD.listValues { padding-left: 6px }\n";
        s = String.valueOf(s) + "FORM.login INPUT.login, FORM.login INPUT.password { width: 150px }\n";
        s = String.valueOf(s) + "FORM.createAgent TD.itemContent { width: 400px; background-color: #D9E3ED; padding: 3px; border: 1px solid #808080 }\n";
        s = String.valueOf(s) + "FORM.createAgent INPUT.agentName { width: 99% }\n";
        s = String.valueOf(s) + "FORM.createAgent SELECT.mainClass { width: 100% }\n";
        s = String.valueOf(s) + "FORM.createAgent TD.paramTable { padding: 0px }\n";
        s = String.valueOf(s) + "FORM.createAgent TD.paramTable TABLE { width: 100% }\n";
        s = String.valueOf(s) + "FORM.createAgent TD.headerName, FORM.createAgent TD.headerValue { border: 1px solid #808080; padding-left: 5px; background-color: #BED5EB }\n";
        s = String.valueOf(s) + "FORM.createAgent TD.listNames, FORM.createAgent TD.listValues { padding-left: 6px }\n";
        s = String.valueOf(s) + "FORM.createAgent TD.paramName, FORM.createAgent TD.paramValue { width: 40%; padding-left: 0px; padding-right: 4px }\n";
        s = String.valueOf(s) + "FORM.createAgent INPUT.paramName, FORM.createAgent INPUT.paramValue { width: 100% }\n";
        s = String.valueOf(s) + "FORM.createService TD.itemContent { width: 400px; background-color: #D9E3ED; padding: 3px; border: 1px solid #808080 }\n";
        s = String.valueOf(s) + "FORM.createService INPUT.serviceName { width: 99% }\n";
        s = String.valueOf(s) + "FORM.createService SELECT.mainClass { width: 100% }\n";
        s = String.valueOf(s) + ".warning { color: #D00000; font-weight: bold }\n";
        s = String.valueOf(s) + "\n";
        s = String.valueOf(s) + "TABLE.GeneralInfo TD.ItemName {}\n";
        s = String.valueOf(s) + "TABLE.GeneralInfo TD.ItemContent { width: 400px; background-color: #D9E3ED; padding: 3px; border: 1px solid #808080 }\n";
        s = String.valueOf(s) + "TABLE.GeneralInfo TD.AlignLeft { text-align: left }\n";
        s = String.valueOf(s) + "TABLE.GeneralInfo TD.AlignCenter { text-align: center }\n";
        s = String.valueOf(s) + "TABLE.GeneralInfo TD.AlignRight { text-align: right }\n";
        s = String.valueOf(s) + "TABLE.GeneralInfo IMG { vertical-align: middle }\n";
        s = String.valueOf(s) + "TABLE.GeneralInfo A { text-decoration: none }\n";
        s = String.valueOf(s) + "TABLE.Table { width: 400px; border-collapse: collapse }\n";
        s = String.valueOf(s) + "TABLE.Table TD { padding: 3px; border: 1px solid #808080 }\n";
        s = String.valueOf(s) + "TABLE.Table TR.Header TD { background-color: #BED5EB; text-align: center }\n";
        s = String.valueOf(s) + "TABLE.Table TR.Content TD { background-color: #D9E3ED }\n";
        s = String.valueOf(s) + "TABLE.Table TR.NoBorder TD { border: none }\n";
        s = String.valueOf(s) + "TABLE.Table TD.Header { background-color: #BED5EB }\n";
        s = String.valueOf(s) + "TABLE.Table TD.Content { background-color: #D9E3ED }\n";
        s = String.valueOf(s) + "TABLE.Table TD.AlignLeft { text-align: left }\n";
        s = String.valueOf(s) + "TABLE.Table TD.AlignCenter { text-align: center }\n";
        s = String.valueOf(s) + "TABLE.Table TD.AlignRight { text-align: right }\n";
        s = String.valueOf(s) + "TABLE.Table IMG { vertical-align: middle }\n";
        s = String.valueOf(s) + "TABLE.Table A { text-decoration: none }\n";
        return s;
    }

    public String mainBlock(String head, String body) {
        String s = new String();
        if (head == null) {
            head = "";
        }
        if (body == null) {
            body = "";
        }
        s = String.valueOf(s) + "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"><HTML>\n\n<HEAD>\n<META http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\">\n<BASE href=\"https://192.168.0.2/\">\n<STYLE type=\"text/css\" media=\"screen\">\n<!--\n" + this.cssRules() + "-->\n" + "</STYLE>\n" + head + "</HEAD>\n" + "\n" + "<BODY " + this.bodyAttribs + ">\n" + body + "</BODY>\n" + "\n" + "</HTML>\n";
        return s;
    }

    public String htmlPageTemplate(String menu, String contentTitle, String content) {
        return this.htmlPageTemplate(null, menu, contentTitle, content);
    }

    public String htmlPageTemplate(String htmlHead, String menu, String contentTitle, String content) {
        String body = new String();
        if (menu == null) {
            menu = "&nbsp;\n";
        }
        if (contentTitle == null) {
            contentTitle = "";
        }
        String userText = "";
        String logoff = "";
        if (this.userInfo != null) {
            userText = "user&nbsp;&nbsp;" + this.userInfo.getName();
            logoff = this.ax(HtmlGenerator.genericURL("logoff.html"), "title=\"Logoff\"", this.img(HtmlGenerator.imageURL("logoff.png"), 18, 44));
        }
        if (content == null) {
            content = "&nbsp;\n";
        }
        body = String.valueOf(body) + "<TABLE class=\"mainFrame\" cellpadding=\"0\" cellspacing=\"0\">\n";
        body = String.valueOf(body) + "<TR class=\"top\">\n<TD class=\"bar\" valign=\"top\">" + this.ax("http://agents.felk.cvut.cz", "target=\"self\" title=\"ATG\"", this.img(HtmlGenerator.imageURL("atg.png"), 110, 44)) + "\n" + "<TD class=\"barsep\">\n" + "<TD class=\"bar contentTitle\" valign=\"top\">\n" + "<DIV class=\"contentTitle\">" + contentTitle + "</DIV>\n" + "<TD class=\"bar userInfo\" valign=\"top\" align=\"right\">\n" + "<DIV class=\"userInfo\">" + userText + "</DIV>\n" + "<TD class=\"bar logoff\" valign=\"top\">\n" + logoff + "\n" + "</TR>\n";
        body = String.valueOf(body) + "<TR style=\"height: 100%\">\n";
        body = String.valueOf(body) + "<TD class=\"menu\" valign=\"top\">\n";
        body = String.valueOf(body) + "<DIV class=\"menuBlock\">\n";
        body = String.valueOf(body) + menu;
        body = String.valueOf(body) + "</DIV>\n";
        body = String.valueOf(body) + "<TD class=\"sepv\">\n";
        body = String.valueOf(body) + "<TD class=\"content\" colspan=\"3\" valign=\"top\">\n";
        body = String.valueOf(body) + "<DIV class=\"contentBlock\">\n";
        body = String.valueOf(body) + content;
        body = String.valueOf(body) + "</DIV>\n";
        body = String.valueOf(body) + "</TR>\n";
        body = String.valueOf(body) + "<TR>\n<TD class=\"seph\">\n<TD class=\"sepcross\">\n<TD class=\"seph\" colspan=\"3\">\n</TR>\n";
        body = String.valueOf(body) + "<TR class=\"bottom\">\n";
        body = String.valueOf(body) + "<TD class=\"logos\">" + this.ax("http://cyber.felk.cvut.cz/gerstner/", "target=\"_blank\" title=\"Gerstner Lab\"", this.img(HtmlGenerator.imageURL("gl.png"), 100, 40)) + "&nbsp;&nbsp;&nbsp;" + this.ax("http://www.cvut.cz", "target=\"_blank\" title=\"CTU Prague\"", this.img(HtmlGenerator.imageURL("cvut.png"), 60, 40)) + "\n" + "<TD class=\"sepv\">\n" + "<TD colspan=\"3\">\n";
        body = String.valueOf(body) + "</TR>\n";
        body = String.valueOf(body) + "</TABLE>\n";
        return this.mainBlock(htmlHead, body);
    }

    public String loginPage(boolean prevLoginFailed, HashMap<String, String> loginData) {
        String s = new String();
        s = String.valueOf(s) + "<DIV class=\"loginBlock\">\n";
        s = String.valueOf(s) + "<FORM class=\"login\" action=\"" + HtmlGenerator.genericURL("login.html") + "\" method=\"post\">\n";
        s = String.valueOf(s) + "<TABLE>\n";
        if (prevLoginFailed) {
            s = String.valueOf(s) + this.tr(this.tdx("class=\"warning\" colspan=\"2\"", "Invalid login!")) + "\n";
            s = String.valueOf(s) + this.tr(this.tdx("colspan=\"2\"", "&nbsp;")) + "\n";
        }
        s = String.valueOf(s) + this.tr(String.valueOf(this.td("Login: ")) + this.td("<INPUT class=\"login\" type=\"text\" name=\"login\">")) + "\n";
        s = String.valueOf(s) + this.tr(String.valueOf(this.td("Password: ")) + this.td("<INPUT class=\"password\" type=\"password\" name=\"password\">")) + "\n";
        s = String.valueOf(s) + this.tr(this.tdx("colspan=\"2\"", "&nbsp;")) + "\n";
        s = String.valueOf(s) + this.tr(this.tdx("colspan=\"2\"", "<INPUT type=\"submit\" name=\"submit\" value=\"Submit\">")) + "\n";
        s = String.valueOf(s) + "</TABLE>\n";
        if (loginData != null) {
            String data;
            String dataType;
            String url;
            String cmdPost;
            String cmdGet = loginData.get("cmdget");
            if (cmdGet != null) {
                s = String.valueOf(s) + "<INPUT type=\"hidden\" name=\"cmdget\" value=\"true\">\n";
            }
            if ((cmdPost = loginData.get("cmdpost")) != null) {
                s = String.valueOf(s) + "<INPUT type=\"hidden\" name=\"cmdpost\" value=\"true\">\n";
            }
            if ((url = loginData.get("url")) != null) {
                s = String.valueOf(s) + "<INPUT type=\"hidden\" name=\"url\" value=\"" + url + "\">\n";
            }
            if ((dataType = loginData.get("datatype")) != null) {
                s = String.valueOf(s) + "<INPUT type=\"hidden\" name=\"datatype\" value=\"" + dataType + "\">\n";
            }
            if ((data = loginData.get("data")) != null) {
                s = String.valueOf(s) + "<INPUT type=\"hidden\" name=\"data\" value=\"" + data + "\">\n";
            }
        }
        s = String.valueOf(s) + "</FORM>\n";
        s = String.valueOf(s) + "</DIV>\n";
        return s;
    }

    public String containerPage() {
        String s = new String();
        return s;
    }

    public String agentPage(AgentInfo info, String webPageContent) {
        String s = new String();
        if (webPageContent == null) {
            Libraries libs = info.getLibraries();
            s = String.valueOf(s) + this.entityBasicInfo(true, info.getName(), info.getMainClass(), null, libs != null ? libs.getLibrary() : null, info.getAglobeParam());
        } else {
            s = String.valueOf(s) + this.addWebPageContent(webPageContent);
        }
        return s;
    }

    public String servicePage(ServiceInfo info, String webPageContent) {
        String s = new String();
        if (webPageContent == null) {
            Libraries libs = info.getLibraries();
            s = String.valueOf(s) + this.entityBasicInfo(false, info.getName(), info.getMainClass(), info.getDescription(), libs != null ? libs.getLibrary() : null, null);
        } else {
            this.addWebPageContent(webPageContent);
        }
        return s;
    }

    public String formCreateAgent(boolean prevFailed, String agentName, String mainClass, LinkedList<AglobeParam> params) {
        AglobeParam p;
        String s = new String();
        String actionURL = String.valueOf(HtmlGenerator.containerURL(this.containerName)) + "/createagent.html";
        s = String.valueOf(s) + "<FORM class=\"createAgent\" action=\"" + actionURL + "\" method=\"post\">\n";
        s = String.valueOf(s) + "<TABLE>\n";
        if (prevFailed) {
            s = String.valueOf(s) + this.tr(this.tdx("class=\"warning\" colspan=\"2\"", "Error!")) + "\n";
            s = String.valueOf(s) + this.tr(this.tdx("colspan=\"2\"", "&nbsp;")) + "\n";
        }
        if (agentName == null) {
            agentName = "";
        }
        s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"itemName\"", "Agent&nbsp;name: ")) + this.tdx("class=\"itemContent\"", "<INPUT class=\"agentName\" type=\"text\" name=\"agentname\" value=\"" + agentName + "\">")) + "\n";
        s = String.valueOf(s) + "<TR>" + this.tdx("class=\"itemName\"", "Main&nbsp;class: ") + "\n";
        s = String.valueOf(s) + "<TD class=\"itemContent\"><SELECT class=\"mainClass\" name=\"mainclass\" size=\"1\">\n";
        List list = this.container.getClassFinder().getAgentList();
        for (String item : list) {
            s = String.valueOf(s) + "<OPTION ";
            if (item.equals(mainClass)) {
                s = String.valueOf(s) + "selected ";
            }
            s = String.valueOf(s) + "value=\"" + item + "\">" + item + "</OPTION>\n";
        }
        s = String.valueOf(s) + "</SELECT></TD></TR>\n";
        int paramsCount = 0;
        if (params != null) {
            paramsCount = params.size();
        }
        s = String.valueOf(s) + this.tr(this.tdx("colspan=\"2\"", "&nbsp;")) + "\n";
        s = String.valueOf(s) + "<TR><TD class=\"itemName\">Parameters: </TD><TD class=\"itemContent paramTable\">\n";
        s = String.valueOf(s) + "<TABLE>\n";
        String paramNames = "";
        String paramValues = "";
        int i = 0;
        while (i < paramsCount) {
            p = params.get(i);
            paramNames = String.valueOf(paramNames) + p.getName() + "<BR>";
            paramValues = String.valueOf(paramValues) + p.getValue() + "<BR>";
            ++i;
        }
        s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"headerName\"", "name")) + this.tdx("class=\"headerValue\"", "value") + this.td("")) + "\n";
        if (paramsCount > 0) {
            s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"listNames\"", paramNames)) + this.tdx("class=\"listValues\"", paramValues) + this.td("")) + "\n";
            i = 0;
            while (i < paramsCount) {
                p = params.get(i);
                int id = i + 1;
                s = String.valueOf(s) + "<INPUT type=\"hidden\" name=\"paramName" + id + "\" value=\"" + p.getName() + "\">\n";
                s = String.valueOf(s) + "<INPUT type=\"hidden\" name=\"paramValue" + id + "\" value=\"" + p.getValue() + "\">\n";
                ++i;
            }
        }
        s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"paramName\"", "<INPUT class=\"paramName\" type=\"text\" name=\"newParamName\">")) + this.tdx("class=\"paramValue\"", "<INPUT class=\"paramValue\" type=\"text\" name=\"newParamValue\">") + this.td("<INPUT type=\"submit\" name=\"addparam\" value=\"< Add parameter\">")) + "\n";
        s = String.valueOf(s) + "</TABLE>\n";
        s = String.valueOf(s) + "</TD></TR>\n";
        s = String.valueOf(s) + this.tr(this.tdx("colspan=\"2\"", "&nbsp;")) + "\n";
        s = String.valueOf(s) + this.tr(String.valueOf(this.td("")) + this.td("<INPUT type=\"submit\" name=\"submit\" value=\"Submit\">")) + "\n";
        s = String.valueOf(s) + "</TABLE>\n";
        s = String.valueOf(s) + "</FORM>\n";
        return s;
    }

    public String formCreateService(boolean prevFailed, String serviceName, String mainClass) {
        String s = new String();
        String actionURL = String.valueOf(HtmlGenerator.containerURL(this.containerName)) + "/createservice.html";
        s = String.valueOf(s) + "<FORM class=\"createService\" action=\"" + actionURL + "\" method=\"post\">\n";
        s = String.valueOf(s) + "<TABLE>\n";
        if (prevFailed) {
            s = String.valueOf(s) + this.tr(this.tdx("class=\"warning\" colspan=\"2\"", "Error!")) + "\n";
            s = String.valueOf(s) + this.tr(this.tdx("colspan=\"2\"", "&nbsp;")) + "\n";
        }
        if (serviceName == null) {
            serviceName = "";
        }
        s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"itemName\"", "Service&nbsp;name: ")) + this.tdx("class=\"itemContent\"", "<INPUT class=\"serviceName\" type=\"text\" name=\"servicename\" value=\"" + serviceName + "\">")) + "\n";
        s = String.valueOf(s) + "<TR>" + this.tdx("class=\"itemName\"", "Main&nbsp;class: ") + "\n";
        s = String.valueOf(s) + "<TD class=\"itemContent\"><SELECT class=\"mainClass\" name=\"mainclass\" size=\"1\">\n";
        List list = this.container.getClassFinder().getServiceList();
        for (String item : list) {
            s = String.valueOf(s) + "<OPTION ";
            if (item.equals(mainClass)) {
                s = String.valueOf(s) + "selected ";
            }
            s = String.valueOf(s) + "value=\"" + item + "\">" + item + "</OPTION>\n";
        }
        s = String.valueOf(s) + "</SELECT></TD></TR>\n";
        s = String.valueOf(s) + this.tr(this.tdx("colspan=\"2\"", "&nbsp;")) + "\n";
        s = String.valueOf(s) + this.tr(String.valueOf(this.td("")) + this.td("<INPUT type=\"submit\" name=\"submit\" value=\"Submit\">")) + "\n";
        s = String.valueOf(s) + "</TABLE>\n";
        s = String.valueOf(s) + "</FORM>\n";
        return s;
    }

    private String entityBasicInfo(boolean isAgent, String entityName, String mainClass, String description, List libraries, List parameters) {
        String libs;
        String s = new String();
        s = String.valueOf(s) + "<DIV class=\"entityBasicInfo\">\n";
        s = String.valueOf(s) + "<TABLE>\n";
        s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"itemName\"", isAgent ? "Agent&nbsp;name: " : "Service&nbsp;name: ")) + this.tdx("class=\"itemContent\"", entityName)) + "\n";
        s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"itemName\"", "Container&nbsp;name: ")) + this.tdx("class=\"itemContent\"", this.containerName)) + "\n";
        if (mainClass.equals("")) {
            mainClass = "<I>undefined</I>";
        }
        s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"itemName\"", "Main&nbsp;class: ")) + this.tdx("class=\"itemContent\"", mainClass)) + "\n";
        if (!isAgent) {
            if (description == null) {
                description = "";
            }
            s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"itemName\"", "Description: ")) + this.tdx("class=\"itemContent\"", description)) + "\n";
        }
        int libsCount = 0;
        if (libraries != null) {
            libsCount = libraries.size();
        }
        if (libsCount > 0) {
            libs = "";
            int i = 0;
            while (i < libsCount) {
                libs = String.valueOf(libs) + (String)libraries.get(i) + "<BR>";
                ++i;
            }
        } else {
            libs = "<I>no libraries</I>";
        }
        s = String.valueOf(s) + this.tr(this.tdx("colspan=\"2\"", "&nbsp;")) + "\n";
        s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"itemName\"", "Libraries: ")) + this.tdx("class=\"itemContent\"", libs)) + "\n";
        if (isAgent) {
            int paramsCount = 0;
            if (parameters != null) {
                paramsCount = parameters.size();
            }
            s = String.valueOf(s) + this.tr(this.tdx("colspan=\"2\"", "&nbsp;")) + "\n";
            s = String.valueOf(s) + "<TR><TD class=\"itemName\">Parameters: </TD><TD class=\"itemContent paramTable\">\n";
            s = String.valueOf(s) + "<TABLE>\n";
            if (paramsCount > 0) {
                String paramNames = "";
                String paramValues = "";
                int i = 0;
                while (i < paramsCount) {
                    AglobeParam p = (AglobeParam)parameters.get(i);
                    paramNames = String.valueOf(paramNames) + p.getName() + "<BR>";
                    paramValues = String.valueOf(paramValues) + p.getValue() + "<BR>";
                    ++i;
                }
                s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"headerName\"", "name")) + this.tdx("class=\"headerValue\"", "value")) + "\n";
                s = String.valueOf(s) + this.tr(String.valueOf(this.tdx("class=\"listNames\"", paramNames)) + this.tdx("class=\"listValues\"", paramValues)) + "\n";
            } else {
                s = String.valueOf(s) + this.tr(this.td("<I>no parameters</I>")) + "\n";
            }
            s = String.valueOf(s) + "</TABLE>\n";
            s = String.valueOf(s) + "</TD></TR>\n";
        }
        s = String.valueOf(s) + "</TABLE>\n";
        s = String.valueOf(s) + "</DIV>\n";
        return s;
    }

    private String addWebPageContent(String webPageContent) {
        String s = new String();
        if (webPageContent != null) {
            s = String.valueOf(s) + webPageContent;
        }
        return s;
    }

    private String menuContainerList(MenuInfo menuInfo) {
        String s = new String();
        boolean expanded = true;
        s = String.valueOf(s) + "<TABLE class=\"menu\">\n";
        String urlRefresh = HtmlGenerator.genericURL(menuInfo.url);
        s = String.valueOf(s) + this.tr(String.valueOf(this.td(this.img(HtmlGenerator.imageURL(expanded ? "minus.png" : "plus.png"), 9, 9))) + this.td("container list&nbsp;&nbsp;" + this.ax(urlRefresh, "title=\"Refresh\"", this.imgx("align=\"top\"", HtmlGenerator.imageURL("refresh.png"), 14, 16)))) + "\n";
        if (expanded) {
            s = String.valueOf(s) + "<TR><TD></TD><TD>\n";
            s = String.valueOf(s) + "<TABLE class=\"menu\">\n";
            String selName = null;
            if (menuInfo.selContainer != null) {
                selName = menuInfo.selContainer.getContainerName();
            }
            boolean selected = false;
            if (selName != null) {
                selected = selName.equals(this.containerName);
            }
            String urlContainer = HtmlGenerator.containerURL(selected ? "" : this.containerName);
            s = String.valueOf(s) + this.tr(String.valueOf(this.td(this.a(urlContainer, this.img(HtmlGenerator.imageURL(selected ? "minus.png" : "plus.png"), 9, 9)))) + this.tdx("class=\"containerName\"", this.a(urlContainer, this.containerName))) + "\n";
            if (selected) {
                s = String.valueOf(s) + "<TR><TD></TD><TD>\n";
                s = String.valueOf(s) + this.menuAgentList(menuInfo.agentsExpanded, menuInfo.selAgent, menuInfo.webPageKey);
                s = String.valueOf(s) + this.menuServiceList(menuInfo.servicesExpanded, menuInfo.selService, menuInfo.webPageKey);
                s = String.valueOf(s) + "</TD></TR>\n";
            }
            s = String.valueOf(s) + "</TABLE>\n";
            s = String.valueOf(s) + "</TD></TR>\n";
        }
        s = String.valueOf(s) + "</TABLE>\n";
        return s;
    }

    private String menuAgentList(boolean expanded, AgentInfo selection, String webPageKey) {
        String s = new String();
        s = String.valueOf(s) + "<TABLE class=\"menu\">\n";
        String urlList = String.valueOf(HtmlGenerator.containerURL(this.containerName)) + (expanded ? "" : "/agents");
        String urlCreate = String.valueOf(HtmlGenerator.containerURL(this.containerName)) + "/createagenttemp.html";
        String iconCreate = this.userInfo.canCreate() ? this.ax(urlCreate, "title=\"Create agent\"", this.imgx("align=\"top\"", HtmlGenerator.imageURL("create_enabled.png"), 14, 15)) : this.imgx("align=\"top\"", HtmlGenerator.imageURL("create_disabled.png"), 14, 15);
        s = String.valueOf(s) + this.tr(String.valueOf(this.td(this.a(urlList, this.img(HtmlGenerator.imageURL(expanded ? "minus.png" : "plus.png"), 9, 9)))) + this.td(String.valueOf(this.a(urlList, "agent list")) + "&nbsp;&nbsp;&nbsp;" + iconCreate)) + "\n";
        if (expanded) {
            s = String.valueOf(s) + "<TR><TD></TD><TD>\n";
            s = String.valueOf(s) + "<TABLE class=\"menu\">\n";
            List<AgentInfo> list = this.agentManager.getRunningAgents();
            Iterator<AgentInfo> iter = list.iterator();
            if (!iter.hasNext()) {
                s = String.valueOf(s) + this.tr(String.valueOf(this.td("&bull;")) + this.tdx("class=\"emptyList\"", "no agents")) + "\n";
            } else {
                String selName = null;
                if (selection != null) {
                    selName = selection.getName();
                }
                boolean selected = false;
                while (iter.hasNext()) {
                    AgentInfo agent = iter.next();
                    if (selName != null) {
                        selected = selName.equals(agent.getName());
                    }
                    s = String.valueOf(s) + this.menuAgentItem(selected, agent, webPageKey) + "\n";
                }
            }
            s = String.valueOf(s) + "</TABLE>\n";
            s = String.valueOf(s) + "</TD></TR>\n";
        }
        s = String.valueOf(s) + "</TABLE>\n";
        return s;
    }

    private String menuServiceList(boolean expanded, ServiceInfo selection, String webPageKey) {
        String s = new String();
        s = String.valueOf(s) + "<TABLE class=\"menu\">\n";
        String urlList = String.valueOf(HtmlGenerator.containerURL(this.containerName)) + (expanded ? "" : "/services");
        String urlCreate = String.valueOf(HtmlGenerator.containerURL(this.containerName)) + "/createservicetemp.html";
        String iconCreate = this.userInfo.canCreate() ? this.ax(urlCreate, "title=\"Create service\"", this.imgx("align=\"top\"", HtmlGenerator.imageURL("create_enabled.png"), 14, 15)) : this.imgx("align=\"top\"", HtmlGenerator.imageURL("create_disabled.png"), 14, 15);
        s = String.valueOf(s) + this.tr(String.valueOf(this.td(this.a(urlList, this.img(HtmlGenerator.imageURL(expanded ? "minus.png" : "plus.png"), 9, 9)))) + this.td(String.valueOf(this.a(urlList, "service list")) + "&nbsp;&nbsp;&nbsp;" + iconCreate)) + "\n";
        if (expanded) {
            s = String.valueOf(s) + "<TR><TD></TD><TD>\n";
            s = String.valueOf(s) + "<TABLE class=\"menu\">\n";
            List<ServiceInfo> list = this.serviceManager.getRunningServices();
            Iterator<ServiceInfo> iter = list.iterator();
            if (!iter.hasNext()) {
                s = String.valueOf(s) + this.tr(String.valueOf(this.td("&bull;")) + this.tdx("class=\"emptyList\"", "no services")) + "\n";
            } else {
                String selName = null;
                if (selection != null) {
                    selName = selection.getName();
                }
                boolean selected = false;
                while (iter.hasNext()) {
                    ServiceInfo service = iter.next();
                    if (selName != null) {
                        selected = selName.equals(service.getName());
                    }
                    s = String.valueOf(s) + this.menuServiceItem(selected, service, webPageKey) + "\n";
                }
            }
            s = String.valueOf(s) + "</TABLE>\n";
            s = String.valueOf(s) + "</TD></TR>\n";
        }
        s = String.valueOf(s) + "</TABLE>\n";
        return s;
    }

    private String menuAgentItem(boolean expanded, AgentInfo agent, String webPageKey) {
        String s = new String();
        String agentName = agent.getName();
        String urlRoot = String.valueOf(HtmlGenerator.containerURL(this.containerName)) + "/agents/";
        String urlAgent = String.valueOf(urlRoot) + (expanded ? "" : agentName.replace('/', '_'));
        String content = String.valueOf(this.a(urlAgent, agentName)) + "&nbsp;";
        if (this.userInfo.canKill() && agent.getMainClass().length() > 0) {
            String urlKill = String.valueOf(HtmlGenerator.containerURL(this.containerName)) + "/killagent.html?" + agentName;
            content = String.valueOf(content) + this.ax(urlKill, "title=\"Kill agent\"", this.img(HtmlGenerator.imageURL("kill_enabled.png"), 9, 9));
        } else {
            content = String.valueOf(content) + this.img(HtmlGenerator.imageURL("kill_disabled.png"), 9, 9);
        }
        s = String.valueOf(s) + this.tdx("class=\"agentName\"", content) + "\n";
        if (expanded) {
            PageKeyTree tree = this.httpsServer.getAgentKeyTree(agentName);
            s = String.valueOf(s) + "<TR><TD></TD><TD>\n";
            s = String.valueOf(s) + "<TABLE class=\"menu webPagesTree\">\n";
            if (tree != null) {
                PageKeyTree.Item treeRoot;
                StringTokenizer tokens = null;
                if (webPageKey != null) {
                    tokens = new StringTokenizer(webPageKey, "/");
                }
                if ((treeRoot = tree.getTreeRoot()).hasChildren()) {
                    urlRoot = String.valueOf(urlRoot) + agentName.replace('/', '_');
                    s = String.valueOf(s) + this.menuWebPagesTree(treeRoot, tokens, urlRoot);
                } else {
                    s = String.valueOf(s) + this.tr(String.valueOf(this.td("&bull;")) + this.tdx("class=\"emptyList\"", "no pages")) + "\n";
                }
            } else {
                s = String.valueOf(s) + this.tr(String.valueOf(this.td("&bull;")) + this.tdx("class=\"emptyList\"", "no pages")) + "\n";
            }
            s = String.valueOf(s) + "</TABLE>\n";
            s = String.valueOf(s) + "</TD></TR>\n";
        }
        s = this.tr(String.valueOf(this.td(this.a(urlAgent, this.img(HtmlGenerator.imageURL(expanded ? "minus.png" : "plus.png"), 9, 9)))) + s);
        return s;
    }

    private String menuServiceItem(boolean expanded, ServiceInfo service, String webPageKey) {
        String s = new String();
        String serviceName = service.getName();
        String urlRoot = String.valueOf(HtmlGenerator.containerURL(this.containerName)) + "/services/";
        String urlService = String.valueOf(urlRoot) + (expanded ? "" : serviceName.replace('/', '_'));
        String content = String.valueOf(this.a(urlService, serviceName)) + "&nbsp;";
        if (this.userInfo.canKill() && service.getMainClass().length() > 0) {
            String urlKill = String.valueOf(HtmlGenerator.containerURL(this.containerName)) + "/killservice.html?" + serviceName;
            content = String.valueOf(content) + this.ax(urlKill, "title=\"Kill service\"", this.img(HtmlGenerator.imageURL("kill_enabled.png"), 9, 9));
        } else {
            content = String.valueOf(content) + this.img(HtmlGenerator.imageURL("kill_disabled.png"), 9, 9);
        }
        s = String.valueOf(s) + this.tdx("class=\"serviceName\"", content) + "\n";
        if (expanded) {
            PageKeyTree tree = this.httpsServer.getServiceKeyTree(serviceName);
            s = String.valueOf(s) + "<TR><TD></TD><TD>\n";
            s = String.valueOf(s) + "<TABLE class=\"menu webPagesTree\">\n";
            if (tree != null) {
                PageKeyTree.Item treeRoot;
                StringTokenizer tokens = null;
                if (webPageKey != null) {
                    tokens = new StringTokenizer(webPageKey, "/");
                }
                if ((treeRoot = tree.getTreeRoot()).hasChildren()) {
                    urlRoot = String.valueOf(urlRoot) + serviceName.replace('/', '_');
                    s = String.valueOf(s) + this.menuWebPagesTree(treeRoot, tokens, urlRoot);
                    s = String.valueOf(s) + "</TD></TR>\n";
                } else {
                    s = String.valueOf(s) + this.tr(String.valueOf(this.td("&bull;")) + this.tdx("class=\"emptyList\"", "no pages")) + "\n";
                }
            } else {
                s = String.valueOf(s) + this.tr(String.valueOf(this.td("&bull;")) + this.tdx("class=\"emptyList\"", "no pages")) + "\n";
            }
            s = String.valueOf(s) + "</TABLE>\n";
        }
        s = this.tr(String.valueOf(this.td(this.a(urlService, this.img(HtmlGenerator.imageURL(expanded ? "minus.png" : "plus.png"), 9, 9)))) + s);
        return s;
    }

    private String menuWebPagesTree(PageKeyTree.Item root, StringTokenizer tokens, String urlRoot) {
        return this.menuWebPagesTree(0, root, tokens, urlRoot);
    }

    private String menuWebPagesTree(int treeLevel, PageKeyTree.Item root, StringTokenizer tokens, String urlRoot) {
        String s = new String();
        s = String.valueOf(s) + "<TR>";
        if (treeLevel > 0) {
            s = String.valueOf(s) + "<TD></TD>";
        }
        s = String.valueOf(s) + "<TD>\n";
        s = String.valueOf(s) + "<TABLE class=\"menu webPagesTree\">\n";
        String key = null;
        if (tokens != null && tokens.hasMoreTokens()) {
            key = tokens.nextToken();
        }
        Vector<PageKeyTree.Item> children = root.getChildren();
        int size = children.size();
        int i = 0;
        while (i < size) {
            PageKeyTree.Item child = children.get(i);
            String childName = child.getName();
            boolean childIsSelected = false;
            if (key != null) {
                childIsSelected = childName.equals(key);
            }
            boolean hasChildren = child.hasChildren();
            String urlChild = urlRoot;
            String symbol = null;
            if (hasChildren) {
                if (childIsSelected) {
                    symbol = this.a(urlChild, this.img(HtmlGenerator.imageURL("minus.png"), 9, 9));
                } else {
                    urlChild = String.valueOf(urlChild) + "/" + childName;
                    symbol = this.a(urlChild, this.img(HtmlGenerator.imageURL("plus.png"), 9, 9));
                }
            } else {
                urlChild = String.valueOf(urlChild) + "/" + childName;
                symbol = "&bull;";
            }
            s = String.valueOf(s) + this.tr(String.valueOf(this.td(symbol)) + this.tdx("class=\"pageName\"", this.a(urlChild, childName))) + "\n";
            if (childIsSelected && hasChildren) {
                urlChild = String.valueOf(urlChild) + "/" + childName;
                s = String.valueOf(s) + this.menuWebPagesTree(treeLevel + 1, child, tokens, urlChild);
            }
            ++i;
        }
        s = String.valueOf(s) + "</TABLE>\n";
        s = String.valueOf(s) + "</TD></TR>\n";
        return s;
    }

    public String menu(MenuInfo menuInfo) {
        String s = new String();
        s = String.valueOf(s) + this.menuContainerList(menuInfo);
        return s;
    }
}

