/*
 * Decompiled with CFR 0.152.
 */
package aglobex.vecmath;

import aglobex.vecmath.Point3d;
import aglobex.vecmath.Tuple3d;

public class Vector3d
extends Tuple3d {
    public static final Vector3d XUNIT = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d YUNIT = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d ZUNIT = new Vector3d(0.0, 0.0, 1.0);
    public static final Vector3d E = new Vector3d(1.0, 1.0, 1.0);

    public Vector3d() {
    }

    public Vector3d(double x, double y, double z) {
        super(x, y, z);
    }

    public Vector3d(double[] v) {
        super(v);
    }

    public Vector3d(Point3d p1, Point3d p2) {
        super(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
    }

    public Vector3d(Vector3d v) {
        super(v);
    }

    public Vector3d set(Vector3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public static double dot(Vector3d v1, Vector3d v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
    }

    public Vector3d cross(Vector3d v1, Vector3d v2) {
        this.x = v1.y * v2.z - v1.z * v2.y;
        this.y = v1.z * v2.x - v1.x * v2.z;
        this.z = v1.x * v2.y - v1.y * v2.x;
        return this;
    }

    public static double length(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double length(Tuple3d v) {
        return Math.sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3d normalize() {
        double len = this.length();
        if (len > 0.0) {
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
        return this;
    }

    public Vector3d normalize(double newlen) {
        double len = this.length();
        if (len > 0.0) {
            len = newlen / len;
            this.x *= len;
            this.y *= len;
            this.z *= len;
        }
        return this;
    }

    public static double angle(Vector3d v1, Vector3d v2) {
        double vDot = Vector3d.dot(v1, v2) / (v1.length() * v2.length());
        if (vDot < -1.0) {
            vDot = -1.0;
        }
        if (vDot > 1.0) {
            vDot = 1.0;
        }
        return Math.acos(vDot);
    }

    public String toString() {
        return String.format("Vector3d (%.2f,%.2f,%.2f)", this.x, this.y, this.z);
    }
}

