/*
 * Decompiled with CFR 0.152.
 */
package aglobex.vecmath;

import aglobex.vecmath.Tuple2d;

public class Vector2d
extends Tuple2d {
    public static final Vector2d XUNIT = new Vector2d(1.0, 0.0);
    public static final Vector2d YUNIT = new Vector2d(0.0, 1.0);

    public Vector2d() {
    }

    public Vector2d(double x, double y) {
        super(x, y);
    }

    public Vector2d(double[] v) {
        super(v);
    }

    public Vector2d(Vector2d v) {
        super(v);
    }

    public Vector2d set(Vector2d v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public static double dot(Vector2d v1, Vector2d v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    public static boolean colinear(Vector2d v1, Vector2d v2) {
        return v1.x * v2.y - v1.y * v2.x == 0.0;
    }

    public static boolean ccw(Vector2d v1, Vector2d v2) {
        return v1.x * v2.y - v1.y * v2.x > 0.0;
    }

    public static boolean cw(Vector2d v1, Vector2d v2) {
        return v1.x * v2.y - v1.y * v2.x < 0.0;
    }

    public static double cross(Vector2d v1, Vector2d v2) {
        return v1.x * v2.y - v1.y * v2.x;
    }

    public static double angle(Vector2d v1, Vector2d v2) {
        double l1 = v1.length();
        double l2 = v2.length();
        double alpha = Math.acos(Math.min(Math.max(Vector2d.dot(v1, v2) / (l1 * l2), -1.0), 1.0));
        if (alpha == 0.0) {
            return 0.0;
        }
        if (Vector2d.ccw(v1, v2)) {
            return alpha;
        }
        return Math.PI * 2 - alpha;
    }

    public static double angle(Vector2d v1, Vector2d v2, boolean direction) {
        double l1 = v1.length();
        double l2 = v2.length();
        double alpha = Math.acos(Math.min(Math.max(Vector2d.dot(v1, v2) / (l1 * l2), -1.0), 1.0));
        if (alpha == 0.0) {
            return 0.0;
        }
        boolean orient = Vector2d.ccw(v1, v2);
        if (orient && direction || !orient && !direction) {
            return alpha;
        }
        return Math.PI * 2 - alpha;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2d normalize() {
        double len = this.x * this.x + this.y * this.y;
        if (len != 1.0 && (len = Math.sqrt(len)) > 0.0) {
            this.x /= len;
            this.y /= len;
        }
        return this;
    }

    public Vector2d normalize(double newlen) {
        double len = this.x * this.x + this.y * this.y;
        if (len != newlen * newlen && (len = Math.sqrt(len)) > 0.0) {
            len = newlen / len;
            this.x *= len;
            this.y *= len;
        }
        return this;
    }

    public String toString() {
        return String.format("Vector2D (%.2f;%.2f)", this.x, this.y);
    }
}

