/*
 * Decompiled with CFR 0.152.
 */
package aglobex.vecmath;

import aglobex.vecmath.Point3d;
import aglobex.vecmath.Vector3d;
import java.io.Serializable;

public class Tuple3d
implements Serializable {
    public double x;
    public double y;
    public double z;

    public Tuple3d() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Tuple3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Tuple3d(double[] v) {
        this.x = v[0];
        this.y = v[1];
        this.z = v[2];
    }

    public Tuple3d(Tuple3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Tuple3d set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Tuple3d set(double[] t) {
        this.x = t[0];
        this.y = t[1];
        this.z = t[2];
        return this;
    }

    public Tuple3d set(Tuple3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public Tuple3d add(Tuple3d v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Tuple3d add(Tuple3d v1, Tuple3d v2) {
        this.x = v1.x + v2.x;
        this.y = v1.y + v2.y;
        this.z = v1.z + v2.z;
        return this;
    }

    public Tuple3d sub(Tuple3d v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public Tuple3d sub(Tuple3d v1, Tuple3d v2) {
        this.x = v1.x - v2.x;
        this.y = v1.y - v2.y;
        this.z = v1.z - v2.z;
        return this;
    }

    public Tuple3d scale(double c) {
        this.x *= c;
        this.y *= c;
        this.z *= c;
        return this;
    }

    public Tuple3d scale(double c, Tuple3d v) {
        this.x = v.x * c;
        this.y = v.y * c;
        this.z = v.z * c;
        return this;
    }

    public Tuple3d scaleAdd(double c, Tuple3d v) {
        this.x = c * this.x + v.x;
        this.y = c * this.y + v.y;
        this.z = c * this.z + v.z;
        return this;
    }

    public Tuple3d scaleAdd(double c, Tuple3d v1, Tuple3d v2) {
        this.x = c * v1.x + v2.x;
        this.y = c * v1.y + v2.y;
        this.z = c * v1.z + v2.z;
        return this;
    }

    public Tuple3d addScaled(double c, Tuple3d v) {
        this.x += c * v.x;
        this.y += c * v.y;
        this.z += c * v.z;
        return this;
    }

    public Tuple3d negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public static Tuple3d product(Tuple3d v1, Tuple3d v2) {
        return new Tuple3d(v1.x * v2.x, v1.y * v2.y, v1.z * v2.z);
    }

    public Tuple3d product(Tuple3d v1) {
        this.x *= v1.x;
        this.y *= v1.y;
        this.z *= v1.z;
        return this;
    }

    public String toString() {
        return "Tuple3d (" + this.x + "," + this.y + "," + this.z + ")";
    }

    public Vector3d toVector() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Point3d toPoint() {
        return new Point3d(this.x, this.y, this.z);
    }

    public Tuple3d maxElements(Tuple3d v1) {
        this.x = Math.max(this.x, v1.x);
        this.y = Math.max(this.y, v1.y);
        this.z = Math.max(this.z, v1.z);
        return this;
    }

    public Tuple3d minElements(Tuple3d v1) {
        this.x = Math.min(this.x, v1.x);
        this.y = Math.min(this.y, v1.y);
        this.z = Math.min(this.z, v1.z);
        return this;
    }
}

