/*
 * Decompiled with CFR 0.152.
 */
package aglobex.vecmath;

import aglobex.vecmath.Point3d;
import aglobex.vecmath.Vector3d;

public class Transform3d {
    public Vector3d u;
    public Vector3d v;
    public Vector3d w;
    public Point3d origin;

    public Transform3d() {
        this.origin = new Point3d(0.0, 0.0, 0.0);
        this.u = new Vector3d(1.0, 0.0, 0.0);
        this.v = new Vector3d(0.0, 1.0, 0.0);
        this.w = new Vector3d(0.0, 0.0, 1.0);
    }

    public Transform3d(Vector3d translation, Vector3d scale) {
        this.origin = new Point3d(translation.x, translation.y, translation.z);
        this.u = new Vector3d(scale.x, 0.0, 0.0);
        this.v = new Vector3d(0.0, scale.y, 0.0);
        this.w = new Vector3d(0.0, 0.0, scale.z);
    }

    public Transform3d(Point3d origin, Vector3d u, Vector3d v, Vector3d w) {
        this.origin = new Point3d(origin);
        this.u = new Vector3d(u);
        this.v = new Vector3d(v);
        this.w = new Vector3d(w);
    }

    public void set(Transform3d trans) {
        this.origin.set(trans.origin);
        this.u.set(trans.u);
        this.v.set(trans.v);
        this.w.set(trans.w);
    }

    public void getOpenGLMatrix(double[] matrix) {
        matrix[0] = this.u.x;
        matrix[1] = this.u.y;
        matrix[2] = this.u.z;
        matrix[3] = 0.0;
        matrix[4] = this.v.x;
        matrix[5] = this.v.y;
        matrix[6] = this.v.z;
        matrix[7] = 0.0;
        matrix[8] = this.w.x;
        matrix[9] = this.w.y;
        matrix[10] = this.w.z;
        matrix[11] = 0.0;
        matrix[12] = this.origin.x;
        matrix[13] = this.origin.y;
        matrix[14] = this.origin.z;
        matrix[15] = 1.0;
    }
}

