/*
 * Decompiled with CFR 0.152.
 */
package aglobex.vecmath;

import aglobex.vecmath.Point3d;
import aglobex.vecmath.Vector3d;

public class Ray3d {
    public Point3d origin;
    public Vector3d direction;

    public Ray3d(Point3d origin, Vector3d direction) {
        this.origin = new Point3d(origin);
        this.direction = new Vector3d(direction);
        this.direction.normalize();
    }

    public Ray3d(Point3d origin, Point3d end) {
        this.origin = new Point3d(origin);
        this.direction = new Vector3d();
        this.direction.sub(end, origin);
        this.direction.normalize();
    }

    public Ray3d(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.origin = new Point3d(x1, y1, z1);
        this.direction = new Vector3d(x2 - x1, y2 - y1, z2 - z1);
        this.direction.normalize();
    }

    public Ray3d() {
        this.origin = new Point3d(0.0, 0.0, 0.0);
        this.direction = new Vector3d(1.0, 0.0, 0.0);
    }

    public Ray3d(Ray3d ln) {
        this.origin = new Point3d(ln.origin);
        this.direction = new Vector3d(ln.direction);
    }

    public void set(Point3d orig, Vector3d dir) {
        this.origin.set(orig);
        this.direction.set(dir);
        this.direction.normalize();
    }

    public void set(Point3d orig, Point3d end) {
        this.origin.set(orig);
        this.direction.sub(end, orig);
        this.direction.normalize();
    }

    public void set(Ray3d ln) {
        this.origin.set(ln.origin);
        this.direction.set(ln.direction);
    }

    public double distance(Point3d p0) {
        Vector3d u = new Vector3d(this.direction.x, this.direction.y, this.direction.z);
        Vector3d v = new Vector3d(this.origin.x - p0.x, this.origin.y - p0.y, this.origin.z - p0.z);
        Vector3d w = new Vector3d();
        w.cross(u, v);
        return w.length() / u.length();
    }

    public String toString() {
        return "Ray3d: origin=" + this.origin + " direction=" + this.direction;
    }
}

