/*
 * Decompiled with CFR 0.152.
 */
package aglobex.vecmath;

import aglobex.vecmath.Point2d;
import aglobex.vecmath.Vector2d;

public class Ray2d {
    public Point2d origin;
    public Vector2d direction;

    public Ray2d(Point2d origin, Vector2d direction) {
        this.origin = new Point2d(origin);
        this.direction = new Vector2d(direction);
        this.direction.normalize();
    }

    public Ray2d(Point2d origin, Point2d end) {
        this.origin = new Point2d(origin);
        this.direction = new Vector2d();
        this.direction.sub(end, origin);
        this.direction.normalize();
    }

    public Ray2d(double x1, double y1, double x2, double y2) {
        this.origin = new Point2d(x1, y1);
        this.direction = new Vector2d(x2 - x1, y2 - y1);
        this.direction.normalize();
    }

    public Ray2d() {
        this.origin = new Point2d(0.0, 0.0);
        this.direction = new Vector2d(1.0, 0.0);
    }

    public Ray2d(Ray2d ln) {
        this.origin = new Point2d(ln.origin);
        this.direction = new Vector2d(ln.direction);
    }

    public void set(Point2d orig, Vector2d dir) {
        this.origin.set(orig);
        this.direction.set(dir);
        this.direction.normalize();
    }

    public void set(Point2d orig, Point2d end) {
        this.origin.set(orig);
        this.direction.sub(end, orig);
        this.direction.normalize();
    }

    public void set(Ray2d ln) {
        this.origin.set(ln.origin);
        this.direction.set(ln.direction);
    }

    public double distance(Point2d p1) {
        return Math.abs(this.signedDistance(p1));
    }

    public double signedDistance(Point2d p1) {
        return -this.direction.y * (p1.x - this.origin.x) + this.direction.x * (p1.y - this.origin.y);
    }

    public String toString() {
        return "Ray2d: origin=" + this.origin + " direction=" + this.direction;
    }
}

