/*
 * Decompiled with CFR 0.152.
 */
package aglobex.vecmath;

import aglobex.vecmath.Tuple3d;
import aglobex.vecmath.Vector3d;

public class Point3d
extends Tuple3d {
    public Point3d() {
    }

    public Point3d(double x, double y, double z) {
        super(x, y, z);
    }

    public Point3d(double[] v) {
        super(v);
    }

    public Point3d(Point3d v) {
        super(v);
    }

    public static double distance(Point3d v1, Point3d v2) {
        return Point3d.distance(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z);
    }

    public static double distance(double[] v1, double[] v2) {
        return Point3d.distance(v1[0], v1[1], v1[2], v2[0], v2[1], v2[2]);
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
    }

    public static double distanceXY(Point3d v1, Point3d v2) {
        return Point3d.distanceXY(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z);
    }

    public static double distanceXY(double[] v1, double[] v2) {
        return Point3d.distanceXY(v1[0], v1[1], v1[2], v2[0], v2[1], v2[2]);
    }

    public static double distanceXY(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static double distanceSquared(Point3d v1, Point3d v2) {
        return (v1.x - v2.x) * (v1.x - v2.x) + (v1.y - v2.y) * (v1.y - v2.y) + (v1.z - v2.z) * (v1.z - v2.z);
    }

    public double distanceXY(Tuple3d t) {
        return Point3d.distanceXY(this.x, this.y, this.z, t.x, t.y, t.z);
    }

    public double distanceXY(double x, double y, double z) {
        return Point3d.distanceXY(this.x, this.y, this.z, x, y, z);
    }

    public double distanceSquaredTo(double x, double y, double z) {
        return (this.x - x) * (this.x - x) + (this.y - y) * (this.y - y) + (this.z - z) * (this.z - z);
    }

    public double distanceSquaredTo(Point3d p) {
        return (this.x - p.x) * (this.x - p.x) + (this.y - p.y) * (this.y - p.y) + (this.z - p.z) * (this.z - p.z);
    }

    public static double distanceL1(Tuple3d v1, Tuple3d v2) {
        return Math.abs(v1.x - v2.x) + Math.abs(v1.y - v2.y) + Math.abs(v1.z - v2.z);
    }

    public static double distanceLinf(Point3d v1, Point3d v2) {
        double d1 = Math.abs(v1.x - v2.x);
        double d2 = Math.abs(v1.y - v2.y);
        double d3 = Math.abs(v1.z - v2.z);
        if (d1 < d2) {
            d1 = d2;
        }
        if (d1 < d3) {
            d1 = d3;
        }
        return d1;
    }

    public Vector3d toVector() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("Point3d [%.2f;%.2f;%.2f]", this.x, this.y, this.z);
    }
}

