/*
 * Decompiled with CFR 0.152.
 */
package aglobex.vecmath;

import aglobex.vecmath.Tuple2d;
import aglobex.vecmath.Vector2d;

public class Point2d
extends Tuple2d {
    public Point2d() {
    }

    public Point2d(double x, double y) {
        super(x, y);
    }

    public Point2d(double[] v) {
        super(v);
    }

    public Point2d(Point2d v) {
        super(v);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static double distance(Point2d v1, Point2d v2) {
        return Math.sqrt((v1.x - v2.x) * (v1.x - v2.x) + (v1.y - v2.y) * (v1.y - v2.y));
    }

    public static double distanceSquared(Point2d v1, Point2d v2) {
        return (v1.x - v2.x) * (v1.x - v2.x) + (v1.y - v2.y) * (v1.y - v2.y);
    }

    public static double distanceL1(Point2d v1, Point2d v2) {
        return Math.abs(v1.x - v2.x) + Math.abs(v1.y - v2.y);
    }

    public static double distanceLinf(Point2d v1, Point2d v2) {
        double d2;
        double d1 = Math.abs(v1.x - v2.x);
        if (d1 < (d2 = Math.abs(v1.y - v2.y))) {
            d1 = d2;
        }
        return d1;
    }

    public static boolean ccw(Point2d a, Point2d b, Point2d c) {
        return (a.x - c.x) * (b.y - c.y) - (a.y - c.y) * (b.x - c.x) > 0.0;
    }

    public static double angle(Point2d a, Point2d b, Point2d c) {
        double l2;
        double l1 = Point2d.distance(a, c);
        double arg = ((a.x - c.x) * (b.x - c.x) + (a.y - c.y) * (b.y - c.y)) / (l1 * (l2 = Point2d.distance(b, c)));
        double alpha = Math.acos(Math.min(Math.max(arg, -1.0), 1.0));
        if (alpha == 0.0) {
            return 0.0;
        }
        if (Point2d.ccw(a, b, c)) {
            return alpha;
        }
        return Math.PI * 2 - alpha;
    }

    public static double angle(Point2d a, Point2d b, Point2d c, boolean orient) {
        double l1 = Point2d.distance(a, c);
        double l2 = Point2d.distance(b, c);
        double arg = ((a.x - c.x) * (b.x - c.x) + (a.y - c.y) * (b.y - c.y)) / (l1 * l2);
        double alpha = Math.acos(Math.min(Math.max(arg, -1.0), 1.0));
        boolean ccw = Point2d.ccw(a, b, c);
        if (alpha == 0.0) {
            return 0.0;
        }
        if (ccw && orient || !ccw && !orient) {
            return alpha;
        }
        return Math.PI * 2 - alpha;
    }

    public Vector2d toVector() {
        return new Vector2d(this.x, this.y);
    }

    public String toString() {
        return String.format("Point2d [%.2f,%.2f]", this.x, this.y);
    }
}

