/*
 * Decompiled with CFR 0.152.
 */
package aglobex.vecmath;

import aglobex.vecmath.Point3d;
import aglobex.vecmath.Vector3d;

public class Line3d {
    public Point3d p1;
    public Point3d p2;

    public Line3d(Point3d p1, Point3d p2) {
        this.p1 = new Point3d(p1);
        this.p2 = new Point3d(p2);
    }

    public Line3d(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.p1 = new Point3d(x1, y1, z1);
        this.p2 = new Point3d(x2, y2, z2);
    }

    public Line3d() {
        this.p1 = new Point3d(0.0, 0.0, 0.0);
        this.p2 = new Point3d(1.0, 0.0, 0.0);
    }

    public Line3d(Line3d ln) {
        this.p1 = new Point3d(ln.p1);
        this.p2 = new Point3d(ln.p2);
    }

    public void set(Point3d p1, Point3d p2) {
        this.p1.set(p1);
        this.p2.set(p2);
    }

    public void set(Line3d ln) {
        this.p1.set(ln.p1);
        this.p2.set(ln.p2);
    }

    public double distance(Point3d p0) {
        Vector3d u = new Vector3d(this.p2.x - this.p1.x, this.p2.y - this.p1.y, this.p2.z - this.p1.z);
        Vector3d v = new Vector3d(this.p1.x - p0.x, this.p1.y - p0.y, this.p1.z - p0.z);
        Vector3d w = new Vector3d();
        w.cross(u, v);
        return w.length() / u.length();
    }

    public String toString() {
        return "Line3d: p1=" + this.p1 + " p2=" + this.p2;
    }
}

