/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.visio;

import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.CommunicationInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobe.visio3D.PlanUpdate;
import aglobe.visio3D.VisioCallbackListener;
import aglobe.visio3D.VisioConnection;
import aglobe.visio3D.ontology.ImageContainer;
import aglobex.simulation.global.AssignZoneMesh;
import aglobex.simulation.global.AuxLineInfo;
import aglobex.simulation.global.EntitiesPositionInfo;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.flightplan.FlightPlan;
import aglobex.simulation.ontology.waypoint.Waypoint;
import aglobex.simulation.ontology.waypoint.Waypoints;
import aglobex.simulation.visio.VisioAgentGUI;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class VisioAgent
extends Agent
implements GISTopicServerListener,
VisioCallbackListener {
    private static final boolean SCREENSHOT_ENABLED = true;
    private static final long SCREENSHOT_UPDATE_INTERVAL = 2000L;
    public static final short VIEW_3D_WIDTH = 320;
    public static final short VIEW_3D_HEIGHT = 240;
    private GISServerService.Shell gisShell;
    private GISServerService.Shell gisShellVisualization;
    private VisioAgentGUI gui;
    short nextScrShotID = 0;
    VisioConnection visio;
    private HashMap<String, EntityRecord> createdEntities = new HashMap();
    private HashMap<Address, EntityRecord> createdEntitiesByContainerAddress = new HashMap();
    private HashMap<Short, EntityRecord> createdEntitiesByVisioID = new HashMap();
    private HashMap<EntityRecord, Integer> requestsForFlightPlan = new HashMap();
    private HashSet<Short> radarViewRequests = new HashSet();
    private HashMap<Short, String> clients3DviewNotParsedRequests = new HashMap();
    private boolean simulationPlanPhase = false;
    private short nextZoneID = 0;
    private HashMap<String, Short> definedZoneMeshes = new HashMap();
    private String selectedEntity = null;

    protected void handleIncomingMessage(Message m) {
        this.logSevere("Unexpected incoming message: " + m);
        m.release();
    }

    public void init(AgentInfo ai, int initState) {
        this.setThreadPersistency(true);
        Thread.currentThread().setPriority(Math.min(6, 10));
        this.gisShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        if (this.gisShell == null) {
            this.logSevere("Can run only on the server container.");
            this.stop();
            return;
        }
        this.gisShellVisualization = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        String confFile = this.getContainer().getProperty("visio3DConf");
        if (confFile == null) {
            this.logSevere("Missing visio3DConf starting atribute.");
            this.stop();
            return;
        }
        try {
            this.visio = new VisioConnection(confFile);
        }
        catch (Exception ex) {
            this.logSevere("Exception during visio module initialization: " + ex.toString());
            this.stop();
            return;
        }
        this.visio.registerCallbackListener(this);
        if (!this.visio.hasSomeRenderer()) {
            this.logInfo("There is no renderer visio available.");
        }
        if (this.visio.hasSomeRenderer()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            VisioAgent.this.gui = new VisioAgentGUI(VisioAgent.this);
                            VisioAgent.this.requestNewScreenShot();
                        }
                        catch (Exception ex) {
                            VisioAgent.this.logWarning("Cannot create GUI due to: " + ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.gisShell.subscribeTopic("VISIO_LOGIN_REQUEST", this);
        this.gisShell.subscribeTopic("VISIO_LOGOUT", this);
        this.gisShell.subscribeTopic("FAST_SIMULATION_PHASE", this);
        this.gisShell.subscribeTopic("VISIO_RESET", this);
        this.switchSimulationPlanPhase(false);
    }

    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
    }

    public void handleLogoutTopic(String topic, String remoteContainerName) {
    }

    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equals("COMMUNICATION_INFO")) {
            CommunicationInfo gi;
            if (remoteContainerName != null && !(gi = (CommunicationInfo)content).getLocal() && !gi.getUndeliverable() && gi.getFrom().isAgent() && gi.getTo().isAgent()) {
                this.parseCommunicationInfo(gi.getFrom().deriveContainerAddress(), gi.getTo().deriveContainerAddress());
            }
            return;
        }
        if (topic.equals("POSITION_UPDATE") && remoteContainerName == null) {
            this.parsePositionUpdate((EntitiesPositionInfo)content);
            return;
        }
        if (topic.equals("VISIO_VISIBILITY_UPDATE") && remoteContainerName == null) {
            this.parseVisibilityUpdate((ByteArrayOutputStream)content);
            return;
        }
        if (topic.equals("SIMULATION_TIME_UPDATE_1_SECOND") && remoteContainerName == null) {
            int curTime = (int)(Long.parseLong((String)content) / 1000L);
            this.visio.sendDisplayTime(curTime);
            return;
        }
        if (topic.equals("VISIO_ACTION")) {
            EntityRecord pr = this.createdEntities.get(remoteContainerName);
            if (pr == null) {
                return;
            }
            this.visio.sendShowAction(reason, pr.visioID, Byte.parseByte((String)content));
            return;
        }
        if (topic.equals("VISIO_FLIGHT_PLAN_UPDATE") && remoteContainerName == null) {
            this.parsePlanUpdate((PlanUpdate)content);
            return;
        }
        if (topic.equals("3D_IMAGE_REQUEST") && remoteContainerName != null) {
            this.requestScreenShotByClient(remoteContainerName);
            return;
        }
        if (topic.equals("VISIO_AUX_MAKE_LINE") && remoteContainerName == null) {
            this.parseAuxLineInfo((AuxLineInfo)content);
            return;
        }
        if (topic.equals("VISIO_AUX_HIDE_LINE") && remoteContainerName == null) {
            short lineID = 0;
            try {
                lineID = (short)Integer.parseInt((String)content);
                this.visio.sendAuxHideLine(lineID);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return;
        }
        if (topic.equals("VISIO_WAYPOINTS_UPDATE")) {
            if (remoteContainerName != null) {
                EntityRecord pr = this.createdEntities.get(remoteContainerName);
                if (pr == null) {
                    this.logWarning("Waypoint update fails. Entity not found: " + remoteContainerName);
                    return;
                }
                this.parseWaypointsUpdate(false, pr.visioID, (Waypoints)content, null);
            }
            return;
        }
        if (topic.equals("VISIO_OFFLINE_WAYPOINTS_UPDATE")) {
            Object[] data = (Object[])content;
            this.parseWaypointsUpdate(true, (short)0, (Waypoints)data[0], (FlightPlan)data[1]);
            return;
        }
        if (topic.equals("VISIO_LOGIN_REQUEST") && remoteContainerName == null) {
            this.entityLogin((EntityRecord)content);
            return;
        }
        if (topic.equals("VISIO_LOGOUT") && remoteContainerName == null) {
            this.entityLogout(reason);
            return;
        }
        if (topic.equals("VISIO_RESET_SIMULATION_SPEED") && remoteContainerName == null) {
            int s = Integer.parseInt((String)content);
            short speed = s <= 32768 ? (short)s : (short)(s - 65536);
            this.visio.sendNewSimulationSpeed(speed);
            return;
        }
        if (topic.equals("ENTITY_CRASH") && remoteContainerName == null) {
            String name = (String)content;
            EntityRecord pr = this.createdEntities.get(name);
            if (pr != null) {
                this.visio.sendObjectCrashed(pr.visioID);
            }
            return;
        }
        if (topic.equals("VISIO_REGISTER_AGENT")) {
            EntityRecord pr = this.createdEntities.get(remoteContainerName);
            String agentName = (String)content;
            if (pr == null) {
                return;
            }
            this.visio.sendAgentInfo(agentName, pr.visioID);
            return;
        }
        if (topic.equals("VISIO_DEREGISTER_AGENT")) {
            this.visio.sendRemoveAgent((String)content);
            return;
        }
        if (topic.equals("FAST_SIMULATION_PHASE") && remoteContainerName == null) {
            boolean on = Boolean.parseBoolean((String)content);
            this.switchSimulationPlanPhase(on);
            return;
        }
        if (topic.equals("VISIO_RESET") && remoteContainerName == null) {
            this.visio.sendReset();
            this.nextZoneID = 0;
            this.definedZoneMeshes.clear();
            this.selectedEntity = null;
            return;
        }
        if (topic.equals("VISIO_DEFINE_ZONE_MESH") && remoteContainerName == null) {
            Object[] data = (Object[])content;
            String name = (String)data[0];
            byte[] definition = (byte[])data[1];
            byte[] forDefine = new byte[definition.length + 2];
            this.definedZoneMeshes.put(name, this.nextZoneID);
            short s = this.nextZoneID;
            this.nextZoneID = (short)(s + 1);
            short zoneID = s;
            forDefine[0] = (byte)(zoneID & 0xFF);
            zoneID = (short)(zoneID >> 8);
            forDefine[1] = (byte)(zoneID & 0xFF);
            System.arraycopy(definition, 0, forDefine, 2, definition.length);
            this.visio.sendUserCommnad((byte)44, forDefine);
            return;
        }
        if (topic.equals("NON_COOPERATIVE_ZONE_MESHES") && remoteContainerName != null) {
            if (!remoteContainerName.equals(this.selectedEntity)) {
                return;
            }
            AssignZoneMesh azm = (AssignZoneMesh)content;
            EntityRecord er = this.createdEntities.get(azm.entityContainerName);
            if (er == null) {
                return;
            }
            short objectID = er.visioID;
            if (objectID <= 0) {
                return;
            }
            if (azm.zoneMeshName != null && !this.definedZoneMeshes.containsKey(azm.zoneMeshName)) {
                return;
            }
            short zoneID = azm.zoneMeshName == null ? (short)-1 : (short)this.definedZoneMeshes.get(azm.zoneMeshName);
            this.visio.sendAssignZoneMesh(objectID, zoneID, azm.position, azm.rotation, azm.scale[0]);
            return;
        }
        this.logSevere("Unexpected incoming topic: " + topic);
    }

    private void switchSimulationPlanPhase(boolean on) {
        this.simulationPlanPhase = on;
        if (this.simulationPlanPhase) {
            this.visio.objectIndexAllocator.clearObjectIndexBuffer();
            this.gisShellVisualization.unsubscribeAllTopics();
        } else {
            this.visio.sendReset();
            if (this.visio.isConnected()) {
                this.gisShellVisualization.subscribeTopic("POSITION_UPDATE", this);
                this.gisShellVisualization.subscribeTopic("VISIO_VISIBILITY_UPDATE", this);
                this.gisShellVisualization.subscribeTopic("VISIO_FLIGHT_PLAN_UPDATE", this);
                this.gisShellVisualization.subscribeTopic("VISIO_AUX_MAKE_LINE", this);
                this.gisShellVisualization.subscribeTopic("VISIO_AUX_HIDE_LINE", this);
                this.gisShellVisualization.subscribeTopic("COMMUNICATION_INFO", this);
                this.gisShellVisualization.subscribeTopic("VISIO_WAYPOINTS_UPDATE", this);
                this.gisShellVisualization.subscribeTopic("VISIO_RESET_SIMULATION_SPEED", this);
                this.gisShellVisualization.subscribeTopic("ENTITY_CRASH", this);
                this.gisShellVisualization.subscribeTopic("SIMULATION_TIME_UPDATE_1_SECOND", this);
                this.gisShellVisualization.subscribeTopic("VISIO_REGISTER_AGENT", this);
                this.gisShellVisualization.subscribeTopic("VISIO_DEREGISTER_AGENT", this);
                this.gisShellVisualization.subscribeTopic("VISIO_ACTION", this);
                this.gisShellVisualization.subscribeTopic("VISIO_OFFLINE_WAYPOINTS_UPDATE", this);
                this.gisShellVisualization.subscribeTopic("VISIO_DEFINE_ZONE_MESH", this);
                this.gisShellVisualization.subscribeTopic("NON_COOPERATIVE_ZONE_MESHES", this);
                this.gisShellVisualization.sendTopicToLocal("VISIO_RESET_SIMULATION_SPEED_REQUEST", "");
                if (this.visio.hasSomeRenderer()) {
                    this.gisShellVisualization.subscribeTopic("3D_IMAGE_REQUEST", this);
                }
            }
        }
    }

    private void entityLogin(EntityRecord entity) {
        short visioID;
        if (!this.simulationPlanPhase) {
            visioID = this.visio.sendCreateObject(entity.containerName, entity.entityDescriptor.typeDescriptor.visioTypeName, "", entity.entityDescriptor.typeDescriptor.visibilityRange);
            try {
                double safetyRadius = entity.entityDescriptor.typeDescriptor.userParamsDouble.get("SAFETY_RANGE");
                this.visio.sendSetRadarRadius(visioID, safetyRadius * 40.0);
                this.visio.sendSetZoneDimensions(visioID, (byte)0, safetyRadius, safetyRadius * 2.0);
            }
            catch (Exception exception) {}
        } else {
            visioID = this.visio.objectIndexAllocator.allocateNextObjectIndex();
        }
        entity.visioID = visioID;
        this.createdEntities.put(entity.containerName, entity);
        this.createdEntitiesByContainerAddress.put(entity.address, entity);
        this.createdEntitiesByVisioID.put(entity.visioID, entity);
        this.gisShell.sendTopicToLocal("VISIO_LOGIN_RESPONSE", visioID, entity.containerName);
    }

    private void entityLogout(String containerName) {
        EntityRecord pr = this.createdEntities.get(containerName);
        if (pr == null) {
            return;
        }
        if (!this.simulationPlanPhase) {
            this.visio.sendDestroyObject(pr.visioID);
        } else {
            this.visio.objectIndexAllocator.freeVisioID(pr.visioID);
        }
        this.createdEntities.remove(containerName);
        this.createdEntitiesByContainerAddress.remove(pr.address);
        this.createdEntitiesByVisioID.remove(pr.visioID);
    }

    private void parsePositionUpdate(EntitiesPositionInfo epi) {
        this.visio.sendPostionUpdateExt(epi.visioId, epi.x, epi.y, epi.z, epi.yaw, epi.pitch, epi.roll);
    }

    private void parseVisibilityUpdate(ByteArrayOutputStream visibility) {
        this.visio.sendLinesFromBuf(visibility);
    }

    private void parsePlanUpdate(PlanUpdate planUpdate) {
        this.visio.sendPlanUpdate(planUpdate, false);
    }

    private void parseAuxLineInfo(AuxLineInfo auxLineInfo) {
        this.visio.sendAuxMakeLine(auxLineInfo.lineID, auxLineInfo.x1, auxLineInfo.y1, auxLineInfo.z1, auxLineInfo.x2, auxLineInfo.y2, auxLineInfo.z2, auxLineInfo.r, auxLineInfo.g, auxLineInfo.b);
    }

    private void parseCommunicationInfo(Address fromContainerAddress, Address toContainerAddress) {
        EntityRecord pr1 = this.createdEntitiesByContainerAddress.get(fromContainerAddress);
        EntityRecord pr2 = this.createdEntitiesByContainerAddress.get(toContainerAddress);
        if (pr1 != null && pr2 != null) {
            this.visio.sendCommunication(pr1.visioID, pr2.visioID, (byte)2);
        }
    }

    private void parseWaypointsUpdate(boolean virtual, short objectId, Waypoints waypoints, FlightPlan flightPlan) {
        int cnt = waypoints.getWaypoint().size();
        double[][] wp = new double[cnt][3];
        String[] comments = new String[cnt];
        int i = 0;
        for (Waypoint elem : waypoints.getWaypoint()) {
            wp[i][0] = elem.x;
            wp[i][1] = elem.y;
            wp[i][2] = elem.z;
            StringBuilder sb = new StringBuilder(elem.name);
            if (elem.timeAllowance != Long.MAX_VALUE) {
                sb.append(" ");
                sb.append((double)elem.time.longValue() / 1000.0);
                if (elem.timeAllowance != 0L) {
                    sb.append("+-");
                    sb.append(elem.timeAllowance / 1000L);
                }
            }
            comments[i] = sb.toString();
            ++i;
        }
        if (virtual) {
            objectId = this.visio.objectIndexAllocator.allocateNextObjectIndex();
        }
        this.visio.sendWaypoints(objectId, virtual, wp, comments);
        if (virtual && flightPlan != null) {
            this.sendVirtualFlightPlan(objectId, flightPlan);
        }
    }

    private void sendVirtualFlightPlan(short objectId, FlightPlan flightPlan) {
        try {
            PlanUpdate pu = flightPlan.convertToPlanUpdate(objectId);
            this.visio.sendPlanUpdate(pu, true);
        }
        catch (Exception ex) {
            this.logWarning(ex.toString());
        }
    }

    protected void finish() {
        if (this.gui != null) {
            this.gui.dispose();
        }
        if (this.visio != null) {
            this.visio.deregisterCallbackListener(this);
            this.visio.closeAllConnections();
        }
    }

    public void visioPlanStart(short objectIndex) {
        EntityRecord pr = this.createdEntitiesByVisioID.get(objectIndex);
        if (pr == null) {
            this.logSevere("Plan request for nonexisting plane: " + objectIndex);
            return;
        }
        Integer curRequests = this.requestsForFlightPlan.get(pr);
        if (curRequests == null) {
            curRequests = new Integer(0);
        }
        if (curRequests == 0) {
            this.gisShell.sendTopicToLocal("VISIO_SEND_FLIGHT_PLAN_START", pr.containerName);
        } else {
            this.gisShell.sendTopicToLocal("VISIO_RESEND_FLIGHT_PLAN", pr.containerName);
        }
        curRequests = curRequests + 1;
        this.requestsForFlightPlan.put(pr, curRequests);
    }

    public void visioPlanStop(short objectIndex) {
        EntityRecord pr = this.createdEntitiesByVisioID.get(objectIndex);
        if (pr == null) {
            this.logSevere("Plan request for nonexisting plane: " + objectIndex);
            return;
        }
        Integer curRequests = this.requestsForFlightPlan.get(pr);
        if (curRequests == null) {
            curRequests = new Integer(0);
        }
        curRequests = curRequests - 1;
        this.requestsForFlightPlan.put(pr, curRequests);
        if (curRequests == 0) {
            this.gisShell.sendTopicToLocal("VISIO_SEND_FLIGHT_PLAN_STOP", pr.containerName);
        }
    }

    public void visioRelInfoStart(String agentName, short containerID) {
    }

    public void visioRelInfoEnd(String agentName, short containerID) {
    }

    public void visioSetSimulationSpeed(short speed) {
        int spd = speed;
        if (speed < 0) {
            spd += 65536;
        }
        this.gisShell.sendTopicToLocal("VISIO_SET_SIMULATION_SPEED", Integer.toString(spd));
        this.visio.sendNewSimulationSpeed((short)speed);
    }

    public void visioReceivedScreenShotData(short screenShotID, BufferedImage screenShot) {
        String receiverContainerName = this.clients3DviewNotParsedRequests.get(screenShotID);
        if (receiverContainerName != null) {
            ImageContainer ic = new ImageContainer(screenShot);
            this.gisShell.sendTopic(receiverContainerName, "3D_IMAGE_RESPONSE", ic);
            this.clients3DviewNotParsedRequests.remove(screenShotID);
            return;
        }
        if (this.radarViewRequests.contains(screenShotID)) {
            this.radarViewRequests.remove(screenShotID);
            if (this.gui != null) {
                this.gui.setNewImage(screenShot);
            }
            return;
        }
        this.logInfo("Received unexpected incoming image: " + screenShotID);
    }

    private void requestNewScreenShot() {
        short s = this.nextScrShotID;
        this.nextScrShotID = (short)(s + 1);
        short scrId = s;
        try {
            this.radarViewRequests.add(scrId);
            this.visio.sendScreenShot2DFree(scrId, (short)640, (short)480, new int[]{5000, 5000}, (short)0, null);
        }
        catch (Exception ex) {
            this.logInfo("There is no renederer visio.");
        }
        this.getContainer().TIMER.schedule(new TimerTask(){

            public void run() {
                VisioAgent.this.requestNewScreenShot();
            }
        }, 2000L);
    }

    private void requestScreenShotByClient(String clientContainerName) {
        EntityRecord pr = this.createdEntities.get(clientContainerName);
        if (pr == null || pr.visioID < 0) {
            this.logSevere("Request for screenshot for nonexisting plane: " + clientContainerName);
            return;
        }
        short s = this.nextScrShotID;
        this.nextScrShotID = (short)(s + 1);
        short scrId = s;
        try {
            this.clients3DviewNotParsedRequests.put(scrId, clientContainerName);
            this.visio.sendScreenShot3DFocused(scrId, (short)320, (short)240, pr.visioID, new double[]{1.55, 1.2}, 150, (short)500, null);
        }
        catch (Exception ex) {
            this.logInfo("There is no renderer visio.");
        }
    }

    public void visioSendRequestsIDs() {
    }

    public void visioBatchInfoStart(String requestID) {
    }

    public void visioBatchInfoEnd(String requestID) {
    }

    public void visioSendRequestsIDsStart() {
    }

    public void visioSendRequestsIDsEnd() {
    }

    public void visioAircraftSelected(short containerID) {
        EntityRecord er;
        if (this.selectedEntity != null) {
            this.gisShellVisualization.sendTopic(this.selectedEntity, "NON_COOPERATIVE_ZONE_MESHES", Boolean.toString(false), this.getName());
            this.selectedEntity = null;
        }
        if ((er = this.createdEntitiesByVisioID.get(containerID)) == null) {
            return;
        }
        this.selectedEntity = er.containerName;
        this.gisShellVisualization.sendTopic(er.containerName, "NON_COOPERATIVE_ZONE_MESHES", Boolean.toString(true), this.getName());
    }
}

