/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.visibilitycrash;

import aglobe.container.transport.Address;
import aglobe.ontology.VisibilityUpdate;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.visio3D.VisioConnection;
import aglobex.simulation.global.EntitiesPositionDistanceInfo;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.visibilitycrash.VisibilityCrashAgent;
import aglobex.simulation.visibilitycrash.VisibilityCrashRecord;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;

class VisibilityCrashSimulator
implements Runnable {
    private static final int FAILURE_INTERVAL = 10;
    private static final int VISIBILITY_BUFFERS = 5;
    private static final int VISIBILITY_BUFFER_INITIAL_SIZE = 100000;
    private int currentVisibilityLoop = 0;
    private final VisibilityCrashAgent owner;
    private Thread visibilityCrashThread;
    private boolean finish = false;
    private boolean suspended = false;
    private HashMap<String, VisibilityCrashRecord> entitiesByName = new HashMap();
    private LinkedList<VisibilityCrashRecord> entities = new LinkedList();
    private VisibilityCrashRecord[] entityArray;
    private EntitiesPositionDistanceInfo toParseEPDI;
    private EntitiesPositionDistanceInfo lastEPDI;
    Address serverContainer = null;
    private int arraySize = -1;
    private long visibilityID = 1L;
    private Random pseudoGenerator = new Random(System.currentTimeMillis());
    private ByteArrayOutputStream[] visibilityExport = new ByteArrayOutputStream[5];
    private DataOutputStream[] dVisibilityExport = new DataOutputStream[5];
    private int currentVisibilityExportIndex = 0;

    VisibilityCrashSimulator(VisibilityCrashAgent owner) {
        this.owner = owner;
        this.serverContainer = Address.getLocalContainerAddress(owner.getContainer());
        int i = 0;
        while (i < this.visibilityExport.length) {
            this.visibilityExport[i] = new ByteArrayOutputStream(100000);
            this.dVisibilityExport[i] = new DataOutputStream(this.visibilityExport[i]);
            ++i;
        }
        this.visibilityCrashThread = AglobeThreadPool.getThread(this, "Visibility Crash Thread");
        this.visibilityCrashThread.setPriority(Math.max(4, 1));
        this.visibilityCrashThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configurationUpdated() {
        LinkedList<VisibilityCrashRecord> linkedList = this.entities;
        synchronized (linkedList) {
            this.arraySize = this.owner.configuration.getMaxEntities();
            if (this.entityArray == null) {
                this.entityArray = new VisibilityCrashRecord[this.arraySize];
            } else if (this.arraySize != this.entityArray.length) {
                int minimumEntities = Math.min(this.entityArray.length, this.arraySize);
                int i = 0;
                while (i < minimumEntities) {
                    if (this.entityArray[i] != null) {
                        double[] tmp = new double[this.arraySize];
                        double[] old = this.entityArray[i].crashDistance2;
                        System.arraycopy(old, 0, tmp, 0, minimumEntities);
                        this.entityArray[i].crashDistance2 = tmp;
                        tmp = new double[this.arraySize];
                        old = this.entityArray[i].failurePct;
                        System.arraycopy(old, 0, tmp, 0, minimumEntities);
                        this.entityArray[i].failurePct = tmp;
                        tmp = new double[this.arraySize];
                        old = this.entityArray[i].visibilityRange2;
                        System.arraycopy(old, 0, tmp, 0, minimumEntities);
                        this.entityArray[i].visibilityRange2 = tmp;
                        boolean[] tmp2 = new boolean[this.arraySize];
                        boolean[] old2 = this.entityArray[i].failure;
                        System.arraycopy(old2, 0, tmp, 0, minimumEntities);
                        this.entityArray[i].failure = tmp2;
                        tmp2 = new boolean[this.arraySize];
                        old2 = this.entityArray[i].visible;
                        System.arraycopy(old2, 0, tmp, 0, minimumEntities);
                        this.entityArray[i].visible = tmp2;
                    }
                    ++i;
                }
                VisibilityCrashRecord[] newEntityArray = new VisibilityCrashRecord[this.arraySize];
                System.arraycopy(this.entityArray, 0, newEntityArray, 0, minimumEntities);
                this.entityArray = newEntityArray;
            }
        }
    }

    synchronized void dispose() {
        this.finish = true;
        this.resumeThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void entityLogged(EntityRecord pr) {
        LinkedList<VisibilityCrashRecord> linkedList = this.entities;
        synchronized (linkedList) {
            if (this.entitiesByName.containsKey(pr.containerName)) {
                this.owner.logSevere("Entity already registred: " + pr.containerName);
                return;
            }
            VisibilityCrashRecord vcr = new VisibilityCrashRecord(pr);
            vcr.failure = new boolean[this.arraySize];
            vcr.crashDistance2 = new double[this.arraySize];
            vcr.failurePct = new double[this.arraySize];
            vcr.visibilityRange2 = new double[this.arraySize];
            vcr.visible = new boolean[this.arraySize];
            int myIndex = pr.indexToSlotArray;
            for (VisibilityCrashRecord elem : this.entities) {
                int remoteIndex = elem.entityRecord.indexToSlotArray;
                double crashDistance2 = Math.min(pr.entityDescriptor.typeDescriptor.crashRange, elem.entityRecord.entityDescriptor.typeDescriptor.crashRange) < 0.0 ? Double.NEGATIVE_INFINITY : (pr.entityDescriptor.typeDescriptor.crashRange + elem.entityRecord.entityDescriptor.typeDescriptor.crashRange) * (pr.entityDescriptor.typeDescriptor.crashRange + elem.entityRecord.entityDescriptor.typeDescriptor.crashRange);
                double failurePct = Math.max(pr.entityDescriptor.typeDescriptor.visibilityFailurePct, elem.entityRecord.entityDescriptor.typeDescriptor.visibilityFailurePct);
                double visibilityRange2 = Math.min(pr.entityDescriptor.typeDescriptor.visibilityRange, elem.entityRecord.entityDescriptor.typeDescriptor.visibilityRange) * Math.min(pr.entityDescriptor.typeDescriptor.visibilityRange, elem.entityRecord.entityDescriptor.typeDescriptor.visibilityRange);
                vcr.crashDistance2[remoteIndex] = crashDistance2;
                elem.crashDistance2[myIndex] = crashDistance2;
                vcr.failurePct[remoteIndex] = failurePct;
                elem.failurePct[myIndex] = failurePct;
                vcr.visibilityRange2[remoteIndex] = visibilityRange2;
                elem.visibilityRange2[myIndex] = visibilityRange2;
            }
            this.entities.add(vcr);
            this.entitiesByName.put(pr.containerName, vcr);
            this.entityArray[pr.indexToSlotArray] = vcr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void entityLogout(EntityRecord pr) {
        LinkedList<VisibilityCrashRecord> linkedList = this.entities;
        synchronized (linkedList) {
            VisibilityCrashRecord vcr = this.entitiesByName.get(pr.containerName);
            if (vcr == null) {
                this.owner.logSevere("Entity is not registred: " + pr.containerName);
                return;
            }
            this.entities.remove(vcr);
            this.entitiesByName.remove(vcr.entityRecord.containerName);
            this.entityArray[vcr.entityRecord.indexToSlotArray] = null;
            for (VisibilityCrashRecord elem : this.entities) {
                elem.visibilityChanged = elem.visible[vcr.entityRecord.indexToSlotArray];
                elem.visible[vcr.entityRecord.indexToSlotArray] = false;
                elem.failure[vcr.entityRecord.indexToSlotArray] = false;
            }
        }
        this.parseNewPositionDistanceInfo(this.lastEPDI);
    }

    synchronized void parseNewPositionDistanceInfo(EntitiesPositionDistanceInfo epdi) {
        this.toParseEPDI = epdi;
        if (this.suspended) {
            this.resumeThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.suspendThread();
        while (!this.finish) {
            EntitiesPositionDistanceInfo currentEPDI;
            Object object = this;
            synchronized (object) {
                currentEPDI = this.toParseEPDI;
                if (currentEPDI != null) {
                    this.lastEPDI = currentEPDI;
                    this.toParseEPDI = null;
                }
            }
            if (currentEPDI != null) {
                object = this.entities;
                synchronized (object) {
                    boolean anyChanged = false;
                    ListIterator iter = this.entities.listIterator();
                    while (iter.hasNext()) {
                        VisibilityCrashRecord item = (VisibilityCrashRecord)iter.next();
                        int index = item.entityRecord.indexToSlotArray;
                        if (currentEPDI.positions.visioId[index] < 0) continue;
                        Iterator iter2 = this.entities.listIterator(iter.nextIndex());
                        while (iter2.hasNext()) {
                            VisibilityCrashRecord item2 = (VisibilityCrashRecord)iter2.next();
                            int index2 = item2.entityRecord.indexToSlotArray;
                            if (currentEPDI.positions.visioId[index2] < 0) continue;
                            if (currentEPDI.distanceMatrix[index][index2] < item.crashDistance2[index2]) {
                                if (!item.crashed) {
                                    this.owner.logWarning("---------------CRASH plane1: " + item.entityRecord.containerName + ", plane2: " + item2.entityRecord.containerName);
                                    item.crashed = true;
                                    this.owner.gisShell.sendTopic(item.entityRecord.containerName, "ENTITY_CRASHED_NOTIFICATION", item2.entityRecord.containerName);
                                    this.owner.gisShell.sendTopicToLocal("ENTITY_CRASH", item.entityRecord.containerName, item2.entityRecord.containerName);
                                }
                                if (!item2.crashed) {
                                    this.owner.logWarning("---------------CRASH plane1: " + item2.entityRecord.containerName + ", plane2: " + item.entityRecord.containerName);
                                    item2.crashed = true;
                                    this.owner.gisShell.sendTopic(item2.entityRecord.containerName, "ENTITY_CRASHED_NOTIFICATION", item.entityRecord.containerName);
                                    this.owner.gisShell.sendTopicToLocal("ENTITY_CRASH", item2.entityRecord.containerName, item.entityRecord.containerName);
                                }
                            }
                            if (this.currentVisibilityLoop == 0 && item.failurePct[index2] != 0.0) {
                                item.failure[index2] = this.pseudoGenerator.nextDouble() < item.failurePct[index2];
                            }
                            boolean visible = !item.crashed && !item2.crashed && !item.failure[index2] && (Double.isNaN(item.visibilityRange2[index2]) || currentEPDI.distanceMatrix[index][index2] < item.visibilityRange2[index2]);
                            item.visibilityChanged |= item.visible[index2] ^ visible;
                            item.visible[index2] = visible;
                            item2.visibilityChanged |= item2.visible[index] ^ visible;
                            item2.visible[index] = visible;
                            if (!visible) continue;
                            item.gisInfo.getVisibleContainerAddress().add(item2.vcRecord);
                            item2.gisInfo.getVisibleContainerAddress().add(item.vcRecord);
                            VisioConnection.writeLittleEndian16bit(this.dVisibilityExport[this.currentVisibilityExportIndex], currentEPDI.positions.visioId[index]);
                            VisioConnection.writeLittleEndian16bit(this.dVisibilityExport[this.currentVisibilityExportIndex], currentEPDI.positions.visioId[index2]);
                        }
                        if (item.visibilityChanged) {
                            item.gisInfo.setVisibilityID(this.visibilityID);
                            this.owner.gisShell.sendTopic(item.entityRecord.containerName, "VISIBILITY_UPDATES", item.gisInfo);
                            item.gisInfo = new VisibilityUpdate();
                            item.visibilityChanged = false;
                            anyChanged = true;
                            continue;
                        }
                        item.gisInfo.getVisibleContainerAddress().clear();
                    }
                    if (anyChanged) {
                        this.owner.gisShell.sendTopicToLocal("VISIO_VISIBILITY_UPDATE", this.visibilityExport[this.currentVisibilityExportIndex]);
                        this.currentVisibilityExportIndex = (this.currentVisibilityExportIndex + 1) % this.visibilityExport.length;
                        this.visibilityExport[this.currentVisibilityExportIndex].reset();
                        ++this.visibilityID;
                    } else {
                        this.visibilityExport[this.currentVisibilityExportIndex].reset();
                    }
                    this.currentVisibilityLoop = (this.currentVisibilityLoop + 1) % 10;
                }
            }
            object = this;
            synchronized (object) {
                if (this.toParseEPDI == null) {
                    this.suspendThread();
                }
            }
        }
    }

    private synchronized void suspendThread() {
        this.suspended = true;
        while (this.suspended && !this.finish) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void resumeThread() {
        this.suspended = false;
        this.notify();
    }
}

