/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.visibilitycrash;

import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobex.simulation.global.EntitiesPositionDistanceInfo;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.Configuration;
import aglobex.simulation.visibilitycrash.VisibilityCrashSimulator;

public class VisibilityCrashAgent
extends Agent
implements GISTopicServerListener {
    GISServerService.Shell gisShell;
    Configuration configuration;
    private VisibilityCrashSimulator visibilityCrashSimulator;

    protected void handleIncomingMessage(Message m) {
        this.logSevere("Unexpected incoming message: " + m);
        m.release();
    }

    public void init(AgentInfo ai, int initState) {
        this.setThreadPersistency(true);
        Thread.currentThread().setPriority(Math.min(6, 10));
        this.gisShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        if (this.gisShell == null) {
            this.logSevere("Can run only on the server container.");
            this.stop();
            return;
        }
        this.visibilityCrashSimulator = new VisibilityCrashSimulator(this);
        this.gisShell.subscribeTopic("ENTITY_LOGGED", this);
        this.gisShell.subscribeTopic("ENTITY_LOGOUT", this);
        this.gisShell.subscribeTopic("POSITION_DISTANCE_UPDATE", this);
        this.gisShell.subscribeTopic("CONFIGURATION", this);
        this.gisShell.sendTopicToLocal("CONFIGURATION_REQUEST", null, this.getName());
    }

    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
    }

    public void handleLogoutTopic(String topic, String remoteContainerName) {
    }

    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equals("POSITION_DISTANCE_UPDATE") && remoteContainerName == null) {
            this.visibilityCrashSimulator.parseNewPositionDistanceInfo((EntitiesPositionDistanceInfo)content);
            return;
        }
        if (topic.equals("ENTITY_LOGGED") && remoteContainerName == null) {
            this.visibilityCrashSimulator.entityLogged((EntityRecord)content);
            return;
        }
        if (topic.equals("ENTITY_LOGOUT") && remoteContainerName == null) {
            this.visibilityCrashSimulator.entityLogout((EntityRecord)content);
            return;
        }
        if (topic.equals("CONFIGURATION")) {
            if (this.getName().equals(reason)) {
                this.configuration = (Configuration)content;
                this.visibilityCrashSimulator.configurationUpdated();
            }
            return;
        }
        this.logSevere("Unexpected incoming topic: " + topic);
    }

    protected void finish() {
        if (this.visibilityCrashSimulator != null) {
            this.visibilityCrashSimulator.dispose();
        }
    }
}

