/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.utils.timer;

import aglobe.container.AgentContainer;
import aglobe.container.ElementaryEntity;
import aglobe.container.service.ServiceShell;
import aglobe.container.transport.Address;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListenerWithoutLogin;
import aglobex.simulation.utils.timer.TimerTask;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Timer
implements AgentContainer.ShutdownListener {
    private static Timer instance = null;
    private static Object creationLock = new Object();
    private TimerTask[] taskQueue = new TimerTask[128];
    private int size = 0;
    private boolean validTime = false;
    private long simulationTimestamp = -1L;
    private LinkedHashMap<String, AgentContainer> availableContainers = new LinkedHashMap();
    private String currentlySubscribedVia = null;
    private GISServerService.Shell gisServerShell = null;
    private GISClientService.Shell gisClientShell = null;

    private Timer() {
    }

    private synchronized void scheduleImpl(ElementaryEntity entity, TimerTask task, long delay, long period) throws IllegalArgumentException {
        if (entity == null || task == null || delay <= 0L || period < 0L) {
            throw new IllegalArgumentException("Invalid attributes");
        }
        if (task.state != 0) {
            throw new IllegalArgumentException("Invalid state of timer task");
        }
        AgentContainer container = entity.getContainer();
        if (!container.isClientContainer() && !container.isServerContainer()) {
            throw new IllegalArgumentException("Entity doesn't run on server or client container");
        }
        this.availableContainers.put(container.getContainerName(), container);
        container.registerShutdownListener(this);
        if (++this.size == this.taskQueue.length) {
            TimerTask[] newQueue = new TimerTask[this.taskQueue.length * 2];
            System.arraycopy(this.taskQueue, 0, newQueue, 0, this.taskQueue.length);
            this.taskQueue = newQueue;
        }
        this.taskQueue[this.size] = task;
        task.state = 1;
        task.delay = delay;
        task.period = period;
        task.belongsToContainerName = container.getContainerName();
        task.entityOwner = entity;
        if (this.validTime) {
            task.nextExecutionTime = this.simulationTimestamp + task.delay;
            this.fixUp(this.size);
        }
        if (this.currentlySubscribedVia == null) {
            this.makeNewSubscription();
        }
    }

    private synchronized void rescheduleImpl(ElementaryEntity entity, TimerTask task, long delay, long period) throws IllegalArgumentException {
        if (task == null) {
            throw new IllegalArgumentException("Invalid attributes");
        }
        if (task.state != 1) {
            throw new IllegalArgumentException("Cannot re-schedule new or cancelled task");
        }
        TimerTask deadTask = new TimerTask(){

            public void run() {
            }
        };
        deadTask.state = 1;
        deadTask.delay = task.delay;
        deadTask.entityOwner = task.entityOwner;
        deadTask.nextExecutionTime = task.nextExecutionTime;
        deadTask.period = task.period;
        deadTask.belongsToContainerName = task.belongsToContainerName;
        boolean found = false;
        int i = 1;
        while (i <= this.size) {
            if (this.taskQueue[i] == task) {
                this.taskQueue[i] = deadTask;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            throw new IllegalStateException("Illegal state of timer");
        }
        task.state = 0;
        this.scheduleImpl(entity, task, delay, period);
    }

    public synchronized void shutdownNotification(String containerName) {
        this.availableContainers.remove(containerName);
        if (this.size != 0 && containerName.equals(this.currentlySubscribedVia)) {
            this.removeSubscription(false);
            try {
                this.makeNewSubscription();
            }
            catch (RuntimeException ex) {
                this.clearQueue();
            }
        }
        int i = 1;
        while (i <= this.size) {
            if (containerName.equals(this.taskQueue[i].belongsToContainerName)) {
                this.taskQueue[i].state = 2;
            }
            ++i;
        }
    }

    private void clearQueue() {
        int i = 1;
        while (i <= this.size) {
            this.taskQueue[i] = null;
            ++i;
        }
        this.size = 0;
    }

    private void fixUp(int k) {
        while (k > 1) {
            int j = k >> 1;
            if (this.taskQueue[j].nextExecutionTime <= this.taskQueue[k].nextExecutionTime) break;
            TimerTask tmp = this.taskQueue[j];
            this.taskQueue[j] = this.taskQueue[k];
            this.taskQueue[k] = tmp;
            k = j;
        }
    }

    private void fixDown(int k) {
        int j;
        while ((j = k << 1) <= this.size && j > 0) {
            if (j < this.size && this.taskQueue[j].nextExecutionTime > this.taskQueue[j + 1].nextExecutionTime) {
                ++j;
            }
            if (this.taskQueue[k].nextExecutionTime <= this.taskQueue[j].nextExecutionTime) break;
            TimerTask tmp = this.taskQueue[j];
            this.taskQueue[j] = this.taskQueue[k];
            this.taskQueue[k] = tmp;
            k = j;
        }
    }

    void heapify() {
        int i = this.size / 2;
        while (i >= 1) {
            this.fixDown(i);
            --i;
        }
    }

    private void makeNewSubscription() {
        boolean invalid = true;
        Iterator<Map.Entry<String, AgentContainer>> iter = this.availableContainers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, AgentContainer> item = iter.next();
            this.gisServerShell = (GISServerService.Shell)item.getValue().getServiceManager().getService(null, "gis/master");
            if (this.gisServerShell != null) {
                this.gisServerShell.subscribeTopic("SIMULATION_TIME_UPDATE", new GISTopicServerListenerWithoutLogin(){

                    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                        Timer.this.handleIncomingTopic(content);
                    }

                    public void addEvent(Runnable e) {
                        e.run();
                    }
                });
                this.currentlySubscribedVia = item.getKey();
                this.gisServerShell.sendTopicToLocal("SIMULATION_TIME_UPDATE_REQUEST", "");
                invalid = false;
                break;
            }
            this.gisClientShell = (GISClientService.Shell)item.getValue().getServiceManager().getService(null, "gis/client");
            if (this.gisClientShell != null) {
                this.gisClientShell.subscribeTopic("SIMULATION_TIME_UPDATE", new GISTopicListener(){

                    public void addEvent(Runnable e) {
                        e.run();
                    }

                    public void handleTopic(String topic, Object content, String reason) {
                        Timer.this.handleIncomingTopic(content);
                    }
                });
                this.currentlySubscribedVia = item.getKey();
                this.gisClientShell.submitTopicToServer("SIMULATION_TIME_UPDATE_REQUEST", "");
                invalid = false;
                break;
            }
            iter.remove();
        }
        if (invalid) {
            throw new RuntimeException("Illegal state of timer.");
        }
    }

    private void removeSubscription(boolean safe) {
        ServiceShell cpyGISShell;
        if (this.gisServerShell != null) {
            if (safe) {
                cpyGISShell = this.gisServerShell;
                AglobeThreadPool.startInNewThread(new Runnable((GISServerService.Shell)cpyGISShell){
                    private final /* synthetic */ GISServerService.Shell val$cpyGISShell;
                    {
                        this.val$cpyGISShell = shell;
                    }

                    public void run() {
                        try {
                            this.val$cpyGISShell.dispose();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, "Unsubscribe thread");
            }
            this.gisServerShell = null;
        }
        if (this.gisClientShell != null) {
            if (safe) {
                cpyGISShell = this.gisClientShell;
                AglobeThreadPool.startInNewThread(new Runnable((GISClientService.Shell)cpyGISShell){
                    private final /* synthetic */ GISClientService.Shell val$cpyGISShell;
                    {
                        this.val$cpyGISShell = shell;
                    }

                    public void run() {
                        try {
                            this.val$cpyGISShell.dispose();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, "Unsubscribe thread");
            }
            this.gisClientShell = null;
        }
        this.currentlySubscribedVia = null;
        this.validTime = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void timeUpdate(long simulationTimestamp) {
        this.simulationTimestamp = simulationTimestamp;
        if (!this.validTime) {
            int i = 1;
            while (i <= this.size) {
                if (this.taskQueue[i].nextExecutionTime < 0L) {
                    this.taskQueue[i].nextExecutionTime = this.taskQueue[i].delay + simulationTimestamp;
                }
                ++i;
            }
            this.heapify();
            this.validTime = true;
        }
        while (this.size > 0) {
            TimerTask candidate = this.taskQueue[1];
            Object object = candidate.lock;
            synchronized (object) {
                if (candidate.state == 2) {
                    this.taskQueue[1] = this.taskQueue[this.size];
                    this.taskQueue[this.size--] = null;
                    this.fixDown(1);
                    continue;
                }
                if (candidate.nextExecutionTime <= simulationTimestamp) {
                    candidate.entityOwner.addEvent(candidate);
                    if (candidate.period > 0L) {
                        candidate.nextExecutionTime += candidate.period;
                        this.fixDown(1);
                    } else {
                        candidate.state = 2;
                        this.taskQueue[1] = this.taskQueue[this.size];
                        this.taskQueue[this.size--] = null;
                        this.fixDown(1);
                    }
                    continue;
                }
                break;
            }
        }
        if (this.size == 0) {
            this.removeSubscription(true);
        }
    }

    private void handleIncomingTopic(Object content) {
        try {
            final long time = Long.parseLong((String)content);
            AglobeThreadPool.startInNewThread(new Runnable(){

                public void run() {
                    Timer.this.timeUpdate(time);
                }
            }, "Timer: Update request thread");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void schedule(ElementaryEntity entity, TimerTask task, long delay) {
        Timer.schedule(entity, task, delay, 0L);
    }

    public static void schedule(ElementaryEntity entity, final Runnable action, long delay) {
        Timer.schedule(entity, new TimerTask(){

            public void run() {
                action.run();
            }
        }, delay, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(ElementaryEntity entity, TimerTask task, long delay, long period) {
        Object object = creationLock;
        synchronized (object) {
            if (instance == null) {
                instance = new Timer();
            }
        }
        instance.scheduleImpl(entity, task, delay, period);
    }

    public static void schedule(ElementaryEntity entity, final Runnable action, long delay, long period) {
        Timer.schedule(entity, new TimerTask(){

            public void run() {
                action.run();
            }
        }, delay, period);
    }

    public static void reschedule(ElementaryEntity entity, TimerTask task, long delay) {
        Timer.reschedule(entity, task, delay, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reschedule(ElementaryEntity entity, TimerTask task, long delay, long period) {
        Object object = creationLock;
        synchronized (object) {
            if (instance == null) {
                instance = new Timer();
            }
        }
        instance.rescheduleImpl(entity, task, delay, period);
    }
}

