/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.utils;

public class Tables {
    public static int sinCosLength = 1000;
    public static int asinAcosLength = 1000;
    public static double[] sinTable;
    public static double[] cosTable;
    public static double[] asinTable;
    public static double[] acosTable;
    private static double sinCosCoef;

    public static void initTables(int sinCosLength, int asinAcosLength) {
        Tables.sinCosLength = sinCosLength;
        Tables.asinAcosLength = asinAcosLength;
        sinTable = new double[sinCosLength];
        cosTable = new double[sinCosLength];
        asinTable = new double[asinAcosLength];
        acosTable = new double[asinAcosLength];
        sinCosCoef = (double)sinCosLength / (Math.PI * 2);
        int i = 0;
        while (i < sinCosLength) {
            double angle = Math.PI * 2 * (double)i / (double)sinCosLength;
            Tables.sinTable[i] = Math.sin(angle);
            Tables.cosTable[i] = Math.cos(angle);
            ++i;
        }
        int j = 0;
        while (j < asinAcosLength) {
            double x = -1.0 + 2.0 * (double)j / (double)(asinAcosLength - 1);
            Tables.asinTable[j] = Math.asin(x);
            Tables.acosTable[j] = Math.acos(x);
            ++j;
        }
    }

    public static double sin(double arg) {
        return arg >= 0.0 ? sinTable[(int)(sinCosCoef * arg) % sinCosLength] : -sinTable[(int)(sinCosCoef * -arg) % sinCosLength];
    }

    public static double cos(double arg) {
        return arg >= 0.0 ? cosTable[(int)(sinCosCoef * arg) % sinCosLength] : cosTable[(int)(sinCosCoef * -arg) % sinCosLength];
    }

    public static double asin(double x) {
        if (x < -1.0) {
            x = -1.0;
        }
        if (x > 1.0) {
            x = 1.0;
        }
        return asinTable[(int)((double)(asinAcosLength - 1) * (x + 1.0) / 2.0)];
    }

    public static double acos(double x) {
        if (x < -1.0) {
            x = -1.0;
        }
        if (x > 1.0) {
            x = 1.0;
        }
        return acosTable[(int)((double)(asinAcosLength - 1) * (x + 1.0) / 2.0)];
    }

    public static double atan2(double y, double x) {
        double atan;
        if (x == 0.0) {
            if (y > 0.0) {
                return 1.5707963267948966;
            }
            if (y == 0.0) {
                return 0.0;
            }
            return -1.5707963267948966;
        }
        double z = y / x;
        if (Math.abs(z) < 1.0) {
            atan = z / (1.0 + 0.28 * z * z);
            if (x < 0.0) {
                if (y < 0.0) {
                    return atan - Math.PI;
                }
                return atan + Math.PI;
            }
        } else {
            atan = 1.5707963267948966 - z / (z * z + 0.28);
            if (y < 0.0) {
                return atan - Math.PI;
            }
        }
        return atan;
    }

    public static void main(String[] args) {
        double x;
        Tables.initTables(3600, 3600);
        System.out.println("Starting benchmark...");
        System.out.println("Computing the sine function for arguments 0-1000");
        long tm1 = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            x = 0.0;
            while (x < 1000.0) {
                Math.sin(x);
                x += 1.0;
            }
            ++i;
        }
        long tm2 = System.currentTimeMillis() - tm1;
        System.out.println("Elapsed time: " + tm2);
        System.out.println("Computing the LUT-sine function for arguments 0-1000");
        tm1 = System.currentTimeMillis();
        i = 0;
        while (i < 100000) {
            x = 0.0;
            while (x < 1000.0) {
                Tables.sin(x);
                x += 1.0;
            }
            ++i;
        }
        tm2 = System.currentTimeMillis() - tm1;
        System.out.println("Elapsed time: " + tm2);
        System.out.println("Computing the arcsin function for arguments -1..1");
        tm1 = System.currentTimeMillis();
        i = 0;
        while (i < 50000) {
            x = -1.0;
            while (x <= 1.0) {
                Math.asin(x);
                x += 0.001;
            }
            ++i;
        }
        tm2 = System.currentTimeMillis() - tm1;
        System.out.println("Elapsed time: " + tm2);
        System.out.println("Computing the LUT-arcsin function for arguments -1..1");
        tm1 = System.currentTimeMillis();
        i = 0;
        while (i < 50000) {
            x = -1.0;
            while (x <= 1.0) {
                Tables.asin(x);
                x += 0.001;
            }
            ++i;
        }
        tm2 = System.currentTimeMillis() - tm1;
        System.out.println("Elapsed time: " + tm2);
        System.out.println("Arctan test");
        double maxerr = 0.0;
        double avgerr = 0.0;
        int cnt = 0;
        double angle = 0.0;
        while (angle < Math.PI * 2) {
            x = Math.sin(angle);
            double y = Math.cos(angle);
            double ang1 = Math.atan2(y, x);
            double ang2 = Tables.atan2(y, x);
            if (ang2 != 0.0) {
                double err = Math.abs((ang1 - ang2) / ang2);
                if (err > maxerr) {
                    maxerr = err;
                }
                avgerr += err;
                ++cnt;
            }
            angle += 0.001;
        }
        System.out.println("Maximum error: " + maxerr + " Average error: " + (avgerr /= (double)cnt));
    }
}

