/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.sensor;

import aglobe.platform.thread.AglobeThreadPool;
import aglobex.simulation.global.EntitiesPositionDistanceInfo;
import aglobex.simulation.global.EntitiesPositionInfo;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.Sensor;
import aglobex.simulation.ontology.SensorDescription;
import aglobex.simulation.ontology.SensoryData;
import aglobex.simulation.ontology.SensoryDataRecord;
import aglobex.simulation.sensor.SensorCylindrical;
import aglobex.simulation.sensor.SensorFunnel;
import aglobex.simulation.sensor.SensorSpherical;
import aglobex.simulation.sensor.Transformation;
import aglobex.simulation.sensor.UniversalSensorAgent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class UniversalSensorSimulator
implements Runnable {
    private static final double DEFAULT_SENSOR_RADIUS = 10.0;
    private static final double DEFAULT_SENSOR_HEIGHT = 10.0;
    private static final double DEFAULT_SENSOR_ANGLE = 45.0;
    private static final int DEFAULT_UNSKIPPED_ROUND = 2;
    private final UniversalSensorAgent owner;
    private Thread universalSensorThread;
    private boolean finish = false;
    private boolean suspended = false;
    private double[][] distanceMatrix;
    private double[][] xydistanceMatrix;
    private int distanceSize;
    private EntitiesPositionInfo entitiesPositionInfo;
    private EntityRecord[] slotToEntityMapping;
    private Map<String, List<SensorSpherical>> sphericalSensorsWRTEntities = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, List<SensorCylindrical>> cylindricalSensorsWRTEntities = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, List<SensorFunnel>> funnelSensorsWRTEntities = Collections.synchronizedMap(new LinkedHashMap());
    private Transformation transformation = new Transformation();
    private double[][] transformedEntitiesPositionInfo;
    private int skipRoundCounter = 0;

    public UniversalSensorSimulator(UniversalSensorAgent owner) {
        this.owner = owner;
        this.universalSensorThread = AglobeThreadPool.getThread(this, "Universal Sensor Thread");
        this.universalSensorThread.setPriority(Math.max(4, 1));
        this.universalSensorThread.start();
    }

    public synchronized void configurationChanged() {
        int oldDistanceSize = this.distanceSize;
        this.distanceSize = this.owner.configuration.getMaxEntities();
        this.distanceMatrix = new double[this.distanceSize][this.distanceSize];
        this.xydistanceMatrix = new double[this.distanceSize][this.distanceSize];
        this.transformedEntitiesPositionInfo = new double[2][this.distanceSize];
        if (oldDistanceSize != this.distanceSize) {
            EntityRecord[] oldSlotToPlaneMapping = this.slotToEntityMapping;
            this.slotToEntityMapping = new EntityRecord[this.distanceSize];
            if (oldSlotToPlaneMapping != null) {
                System.arraycopy(oldSlotToPlaneMapping, 0, this.slotToEntityMapping, 0, Math.min(oldSlotToPlaneMapping.length, this.slotToEntityMapping.length));
            }
        }
    }

    public synchronized void entityLogged(EntityRecord entity) {
        this.slotToEntityMapping[entity.indexToSlotArray] = entity;
    }

    public synchronized void entityLogout(EntityRecord entity) {
        int i = 0;
        while (i < this.slotToEntityMapping.length) {
            if (this.slotToEntityMapping[i] != null && this.slotToEntityMapping[i].containerName.equalsIgnoreCase(entity.containerName)) {
                this.sphericalSensorsWRTEntities.remove(this.slotToEntityMapping[i].containerName);
                this.cylindricalSensorsWRTEntities.remove(this.slotToEntityMapping[i].containerName);
                this.funnelSensorsWRTEntities.remove(this.slotToEntityMapping[i].containerName);
                this.slotToEntityMapping[i] = null;
                break;
            }
            ++i;
        }
    }

    public synchronized void registerSensor(String remoteContainerName, SensorDescription sensorDescription) {
        int slotID;
        List<Object> sensors;
        if (sensorDescription.getSensorType().equalsIgnoreCase("spherical")) {
            sensors = this.sphericalSensorsWRTEntities.get(remoteContainerName);
            if (sensors == null) {
                sensors = new ArrayList<SensorSpherical>();
                this.sphericalSensorsWRTEntities.put(remoteContainerName, sensors);
            }
            slotID = -1;
            int i = 0;
            while (i < this.slotToEntityMapping.length) {
                if (this.slotToEntityMapping[i] != null && this.slotToEntityMapping[i].containerName.equalsIgnoreCase(remoteContainerName)) {
                    slotID = i;
                    break;
                }
                ++i;
            }
            if (slotID >= 0) {
                Double radius = 10.0;
                try {
                    radius = Double.parseDouble(sensorDescription.getAglobeParam().get(0).getValue());
                }
                catch (Exception e) {
                    this.owner.logSevere("Error: no radius found for spherical sensor registration!");
                }
                sensors.add(new SensorSpherical(sensorDescription.getSensorID(), slotID, radius));
            } else {
                this.owner.logSevere("Error: trying to register spherical sensor for unlogged plane!");
            }
        }
        if (sensorDescription.getSensorType().equalsIgnoreCase("cylindrical")) {
            sensors = this.cylindricalSensorsWRTEntities.get(remoteContainerName);
            if (sensors == null) {
                sensors = new ArrayList<SensorSpherical>();
                this.cylindricalSensorsWRTEntities.put(remoteContainerName, sensors);
            }
            slotID = -1;
            int i = 0;
            while (i < this.slotToEntityMapping.length) {
                if (this.slotToEntityMapping[i] != null && this.slotToEntityMapping[i].containerName.equalsIgnoreCase(remoteContainerName)) {
                    slotID = i;
                    break;
                }
                ++i;
            }
            if (slotID >= 0) {
                Double radius = 10.0;
                Double height = 10.0;
                try {
                    radius = Double.parseDouble(sensorDescription.getAglobeParam().get(0).getValue());
                }
                catch (Exception e) {
                    this.owner.logSevere("Error: no radius found for cylindrical sensor registration!");
                }
                try {
                    height = Double.parseDouble(sensorDescription.getAglobeParam().get(1).getValue());
                }
                catch (Exception e) {
                    this.owner.logSevere("Error: no height found for cylindrical sensor registration!");
                }
                sensors.add(new SensorCylindrical(sensorDescription.getSensorID(), slotID, radius, height));
            } else {
                this.owner.logSevere("Error: trying to register cylindrical sensor for unlogged plane!");
            }
        }
        if (sensorDescription.getSensorType().equalsIgnoreCase("funnel")) {
            sensors = this.funnelSensorsWRTEntities.get(remoteContainerName);
            System.out.println(remoteContainerName);
            if (sensors == null) {
                sensors = new ArrayList<SensorSpherical>();
                this.funnelSensorsWRTEntities.put(remoteContainerName, sensors);
            }
            slotID = -1;
            int i = 0;
            while (i < this.slotToEntityMapping.length) {
                if (this.slotToEntityMapping[i] != null && this.slotToEntityMapping[i].containerName.equalsIgnoreCase(remoteContainerName)) {
                    slotID = i;
                    break;
                }
                ++i;
            }
            if (slotID >= 0) {
                Double radius = 10.0;
                Double angle = 10.0;
                try {
                    radius = Double.parseDouble(sensorDescription.getAglobeParam().get(0).getValue());
                }
                catch (Exception e) {
                    this.owner.logSevere("Error: no radius found for funnel sensor registration!");
                }
                try {
                    angle = Double.parseDouble(sensorDescription.getAglobeParam().get(1).getValue());
                }
                catch (Exception e) {
                    this.owner.logSevere("Error: no angle found for funnel sensor registration!");
                }
                sensors.add(new SensorFunnel(sensorDescription.getSensorID(), slotID, radius, angle));
            } else {
                this.owner.logSevere("Error: trying to register funnel sensor for unlogged plane!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parseNewData(EntitiesPositionDistanceInfo newData) {
        if (this.skipRoundCounter >= 2) {
            this.skipRoundCounter = 0;
            if (this.suspended) {
                UniversalSensorSimulator universalSensorSimulator = this;
                synchronized (universalSensorSimulator) {
                    this.distanceMatrix = newData.distanceMatrix;
                    this.xydistanceMatrix = newData.XYdistanceMatrix;
                    this.entitiesPositionInfo = newData.positions;
                }
                this.resumeThread();
            }
        } else {
            ++this.skipRoundCounter;
        }
    }

    public synchronized void dispose() {
        this.finish = true;
        this.resumeThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public void run() {
        this.suspendThread();
        while (!this.finish) {
            SensoryDataRecord dataRecord;
            ArrayList<SensoryDataRecord> data;
            SensoryData sensoryData;
            int entitySlotID;
            Map<String, List<Object>> map = this.sphericalSensorsWRTEntities;
            synchronized (map) {
                for (List<Object> list : this.sphericalSensorsWRTEntities.values()) {
                    if (list.size() <= 0 || this.entitiesPositionInfo.visioId[entitySlotID = list.get(0).getSlotID()] < 0) continue;
                    sensoryData = new SensoryData();
                    sensoryData.simulationTimestamp = this.entitiesPositionInfo.simulationTimestamp;
                    for (Object sensor : list) {
                        data = new ArrayList<SensoryDataRecord>();
                        int i = 0;
                        while (i < this.distanceSize) {
                            if (this.slotToEntityMapping[i] != null && this.entitiesPositionInfo.visioId[i] >= 0 && this.distanceMatrix[entitySlotID][i] < ((SensorSpherical)sensor).getRadius() && i != entitySlotID) {
                                dataRecord = new SensoryDataRecord();
                                dataRecord.targetContainerName = this.slotToEntityMapping[i].containerName;
                                dataRecord.targetEntityType = this.slotToEntityMapping[i].entityDescriptor.typeDescriptor.typeName;
                                dataRecord.ownerX = this.entitiesPositionInfo.x[entitySlotID];
                                dataRecord.ownerY = this.entitiesPositionInfo.y[entitySlotID];
                                dataRecord.ownerZ = this.entitiesPositionInfo.z[entitySlotID];
                                dataRecord.targetX = this.entitiesPositionInfo.x[i];
                                dataRecord.targetY = this.entitiesPositionInfo.y[i];
                                dataRecord.targetZ = this.entitiesPositionInfo.z[i];
                                data.add(dataRecord);
                            }
                            ++i;
                        }
                        if (data.size() <= 0 && ((SensorSpherical)sensor).emptySetSent) continue;
                        Sensor s = new Sensor();
                        s.sensorID = ((SensorSpherical)sensor).getSensorID();
                        s.sensoryDataRecord.addAll(data);
                        sensoryData.sensor.add(s);
                        boolean bl = ((SensorSpherical)sensor).emptySetSent = data.size() == 0;
                    }
                    if (sensoryData.sensor.size() <= 0) continue;
                    this.owner.gisShell.sendTopic(this.slotToEntityMapping[entitySlotID].containerName, "SENSORY_DATA", sensoryData);
                }
            }
            map = this.cylindricalSensorsWRTEntities;
            synchronized (map) {
                for (List<Object> list : this.cylindricalSensorsWRTEntities.values()) {
                    if (list.size() <= 0 || this.entitiesPositionInfo.visioId[entitySlotID = ((SensorCylindrical)list.get(0)).getSlotID()] < 0) continue;
                    sensoryData = new SensoryData();
                    sensoryData.simulationTimestamp = this.entitiesPositionInfo.simulationTimestamp;
                    for (Object sensor : list) {
                        data = new ArrayList();
                        int i = 0;
                        while (i < this.distanceSize) {
                            if (this.slotToEntityMapping[i] != null && this.entitiesPositionInfo.visioId[i] >= 0 && this.xydistanceMatrix[entitySlotID][i] < ((SensorCylindrical)sensor).getRadius() && Math.abs(this.entitiesPositionInfo.z[i] - this.entitiesPositionInfo.z[entitySlotID]) < ((SensorCylindrical)sensor).getHeight() && i != entitySlotID) {
                                dataRecord = new SensoryDataRecord();
                                dataRecord.targetContainerName = this.slotToEntityMapping[i].containerName;
                                dataRecord.targetEntityType = this.slotToEntityMapping[i].entityDescriptor.typeDescriptor.typeName;
                                dataRecord.ownerX = this.entitiesPositionInfo.x[entitySlotID];
                                dataRecord.ownerY = this.entitiesPositionInfo.y[entitySlotID];
                                dataRecord.ownerZ = this.entitiesPositionInfo.z[entitySlotID];
                                dataRecord.targetX = this.entitiesPositionInfo.x[i];
                                dataRecord.targetY = this.entitiesPositionInfo.y[i];
                                dataRecord.targetZ = this.entitiesPositionInfo.z[i];
                                data.add(dataRecord);
                            }
                            ++i;
                        }
                        if (data.size() <= 0 && ((SensorCylindrical)sensor).emptySetSent) continue;
                        Sensor s = new Sensor();
                        s.sensorID = ((SensorCylindrical)sensor).getSensorID();
                        s.sensoryDataRecord.addAll(data);
                        sensoryData.sensor.add(s);
                        boolean bl = ((SensorCylindrical)sensor).emptySetSent = data.size() == 0;
                    }
                    if (sensoryData.sensor.size() <= 0) continue;
                    this.owner.gisShell.sendTopic(this.slotToEntityMapping[entitySlotID].containerName, "SENSORY_DATA", sensoryData);
                }
            }
            map = this.funnelSensorsWRTEntities;
            synchronized (map) {
                for (List<Object> list : this.funnelSensorsWRTEntities.values()) {
                    if (list.size() <= 0 || this.entitiesPositionInfo.visioId[entitySlotID = ((SensorFunnel)list.get(0)).getSlotID()] < 0) continue;
                    sensoryData = new SensoryData();
                    sensoryData.simulationTimestamp = this.entitiesPositionInfo.simulationTimestamp;
                    this.transformation.createTransformationMatrix(this.entitiesPositionInfo.x[entitySlotID], this.entitiesPositionInfo.y[entitySlotID], this.entitiesPositionInfo.z[entitySlotID], this.entitiesPositionInfo.roll[entitySlotID], -this.entitiesPositionInfo.pitch[entitySlotID], -this.entitiesPositionInfo.yaw[entitySlotID]);
                    int i = 0;
                    while (i < this.distanceSize) {
                        if (this.slotToEntityMapping[i] != null) {
                            double[] tcoord = this.transformation.transformXYZIntoPlaneRFArguments(this.entitiesPositionInfo.x[i], this.entitiesPositionInfo.y[i], this.entitiesPositionInfo.z[i]);
                            this.transformedEntitiesPositionInfo[0][i] = tcoord[0];
                            this.transformedEntitiesPositionInfo[1][i] = tcoord[1];
                        }
                        ++i;
                    }
                    for (SensorFunnel sensor : list) {
                        if (list.size() <= 0) continue;
                        data = new ArrayList();
                        int i2 = 0;
                        while (i2 < this.distanceSize) {
                            if (this.slotToEntityMapping[i2] != null && this.entitiesPositionInfo.visioId[i2] >= 0 && this.transformedEntitiesPositionInfo[0][i2] < sensor.getRadius() && this.transformedEntitiesPositionInfo[1][i2] > sensor.getRatio() && i2 != entitySlotID) {
                                dataRecord = new SensoryDataRecord();
                                dataRecord.targetContainerName = this.slotToEntityMapping[i2].containerName;
                                dataRecord.targetEntityType = this.slotToEntityMapping[i2].entityDescriptor.typeDescriptor.typeName;
                                dataRecord.ownerX = this.entitiesPositionInfo.x[entitySlotID];
                                dataRecord.ownerY = this.entitiesPositionInfo.y[entitySlotID];
                                dataRecord.ownerZ = this.entitiesPositionInfo.z[entitySlotID];
                                dataRecord.targetX = this.entitiesPositionInfo.x[i2];
                                dataRecord.targetY = this.entitiesPositionInfo.y[i2];
                                dataRecord.targetZ = this.entitiesPositionInfo.z[i2];
                                data.add(dataRecord);
                            }
                            ++i2;
                        }
                        System.out.println();
                        if (data.size() <= 0 && sensor.emptySetSent) continue;
                        Sensor s = new Sensor();
                        s.sensorID = sensor.getSensorID();
                        s.sensoryDataRecord.addAll(data);
                        sensoryData.sensor.add(s);
                        boolean bl = sensor.emptySetSent = data.size() == 0;
                    }
                    if (sensoryData.sensor.size() <= 0) continue;
                    this.owner.gisShell.sendTopic(this.slotToEntityMapping[entitySlotID].containerName, "SENSORY_DATA", sensoryData);
                }
            }
            this.suspendThread();
        }
    }

    private synchronized void suspendThread() {
        this.suspended = true;
        while (this.suspended && !this.finish) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void resumeThread() {
        this.suspended = false;
        this.notify();
    }
}

