/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.sensor;

import aglobe.container.agent.CMAgent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobex.simulation.global.EntitiesPositionDistanceInfo;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.Configuration;
import aglobex.simulation.ontology.SensorDescription;
import aglobex.simulation.sensor.UniversalSensorSimulator;

public class UniversalSensorAgent
extends CMAgent
implements GISTopicServerListener {
    public static final String TOPIC_REGISTER_SENSOR = "REGISTER_SENSOR";
    public static final String TOPIC_SENSORY_DATA = "SENSORY_DATA";
    GISServerService.Shell gisShell;
    private UniversalSensorSimulator universalSensorSimulator;
    Configuration configuration;

    public void init(AgentInfo ai, int initState) {
        this.setThreadPersistency(true);
        Thread.currentThread().setPriority(Math.min(6, 10));
        this.gisShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        if (this.gisShell == null) {
            this.logSevere("Can run only on the server container.");
            this.stop();
            return;
        }
        this.universalSensorSimulator = new UniversalSensorSimulator(this);
        this.gisShell.subscribeTopic("ENTITY_LOGGED", this);
        this.gisShell.subscribeTopic("ENTITY_LOGOUT", this);
        this.gisShell.subscribeTopic("POSITION_DISTANCE_UPDATE", this);
        this.gisShell.subscribeTopic("CONFIGURATION", this);
        this.gisShell.subscribeTopic(TOPIC_REGISTER_SENSOR, this);
        this.gisShell.sendTopicToLocal("CONFIGURATION_REQUEST", null, this.getName());
    }

    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
    }

    public void handleLogoutTopic(String topic, String remoteContainerName) {
    }

    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equals("CONFIGURATION")) {
            if (this.getName().equals(reason)) {
                this.configuration = (Configuration)content;
                this.universalSensorSimulator.configurationChanged();
            }
            return;
        }
        if (topic.equals("POSITION_DISTANCE_UPDATE") && remoteContainerName == null) {
            this.universalSensorSimulator.parseNewData((EntitiesPositionDistanceInfo)content);
            return;
        }
        if (topic.equals("ENTITY_LOGGED") && remoteContainerName == null) {
            this.universalSensorSimulator.entityLogged((EntityRecord)content);
            return;
        }
        if (topic.equals("ENTITY_LOGOUT") && remoteContainerName == null) {
            this.universalSensorSimulator.entityLogout((EntityRecord)content);
            return;
        }
        if (topic.equals(TOPIC_REGISTER_SENSOR) && remoteContainerName != null) {
            this.universalSensorSimulator.registerSensor(remoteContainerName, (SensorDescription)content);
            return;
        }
        this.logSevere("Unexpected incoming topic: " + topic);
    }
}

