/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.sensor;

import aglobex.simulation.sensor.SinCosLookUpTable;

public class Transformation {
    private static final int TRANSFORMATION_PRECISION = 10;
    private SinCosLookUpTable lt = new SinCosLookUpTable(10);
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double offsetZ = 0.0;
    private double[][] matrix = new double[3][3];

    public double[][] createTransformationMatrix(double x, double y, double z, double ax, double ay, double az) {
        double[][] result = new double[3][3];
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        result[0][0] = this.lt.cos(ay) * this.lt.cos(az);
        result[0][1] = -this.lt.cos(ay) * this.lt.sin(az);
        result[0][2] = this.lt.sin(ay);
        result[1][0] = this.lt.sin(ax) * this.lt.sin(ay) * this.lt.cos(az) + this.lt.cos(ax) * this.lt.sin(az);
        result[1][1] = -this.lt.sin(ax) * this.lt.sin(ay) * this.lt.sin(az) + this.lt.cos(ax) * this.lt.cos(az);
        result[1][2] = -this.lt.sin(ax) * this.lt.cos(ay);
        result[2][0] = -this.lt.cos(ax) * this.lt.sin(ay) * this.lt.cos(az) + this.lt.sin(ax) * this.lt.sin(az);
        result[2][1] = this.lt.cos(ax) * this.lt.sin(ay) * this.lt.sin(az) + this.lt.sin(ax) * this.lt.cos(az);
        result[2][2] = this.lt.cos(ax) * this.lt.cos(ay);
        this.matrix = result;
        return result;
    }

    public double[] transformXYZIntoPlaneXYZ(double x, double y, double z) {
        double[] result = new double[]{this.matrix[0][0] * (x - this.offsetX) + this.matrix[0][1] * (y - this.offsetY) + this.matrix[0][2] * (z - this.offsetZ), this.matrix[1][0] * (x - this.offsetX) + this.matrix[1][1] * (y - this.offsetY) + this.matrix[1][2] * (z - this.offsetZ), this.matrix[2][0] * (x - this.offsetX) + this.matrix[2][1] * (y - this.offsetY) + this.matrix[2][2] * (z - this.offsetZ)};
        return result;
    }

    public double[] transformXYZIntoPlaneREB(double x, double y, double z) {
        double[] result = new double[3];
        double[] tXYZ = this.transformXYZIntoPlaneXYZ(x, y, z);
        result[0] = tXYZ[0] * tXYZ[0] + tXYZ[1] * tXYZ[1] + tXYZ[2] * tXYZ[2];
        result[1] = Math.toDegrees(Math.asin(Math.min(Math.max(tXYZ[2] / Math.sqrt(result[0]), -1.0), 1.0)));
        result[2] = Math.toDegrees(Math.asin(Math.min(Math.max(tXYZ[1] / Math.sqrt(tXYZ[0] * tXYZ[0] + tXYZ[1] * tXYZ[1]), -1.0), 1.0)));
        return result;
    }

    public double[] transformXYZIntoPlaneRF(double x, double y, double z) {
        double[] result = new double[2];
        double[] tXYZ = this.transformXYZIntoPlaneXYZ(x, y, z);
        result[0] = tXYZ[0] * tXYZ[0] + tXYZ[1] * tXYZ[1] + tXYZ[2] * tXYZ[2];
        result[1] = Math.toDegrees(Math.acos(Math.min(Math.max(tXYZ[0] / Math.sqrt(result[0]), -1.0), 1.0)));
        return result;
    }

    public double[] transformXYZIntoPlaneRFArguments(double x, double y, double z) {
        double[] result = new double[2];
        double[] tXYZ = this.transformXYZIntoPlaneXYZ(x, y, z);
        result[0] = tXYZ[0] * tXYZ[0] + tXYZ[1] * tXYZ[1] + tXYZ[2] * tXYZ[2];
        result[1] = tXYZ[0] / Math.sqrt(result[0]);
        return result;
    }

    public double[][] getTransformationMatrix() {
        return this.matrix;
    }
}

