/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.sensor;

public class SinCosLookUpTable {
    private int acc = 1;
    private double[] sine;
    private double[] cosine;

    public SinCosLookUpTable(int accuracy) {
        this.acc = accuracy;
        this.sine = new double[this.acc * 360 + 1];
        this.cosine = new double[this.acc * 360 + 1];
        int i = 0;
        while (i <= this.acc * 360) {
            this.sine[i] = Math.sin(Math.toRadians((double)i / (double)this.acc));
            this.cosine[i] = Math.cos(Math.toRadians((double)i / (double)this.acc));
            ++i;
        }
    }

    public double sin(double deg) {
        double angle = deg % 360.0;
        if (angle < 0.0) {
            angle += 360.0;
        }
        return this.sine[(int)angle * this.acc];
    }

    public double cos(double deg) {
        double angle = deg % 360.0;
        if (angle < 0.0) {
            angle += 360.0;
        }
        return this.cosine[(int)angle * this.acc];
    }

    public void print() {
        System.out.println("sine : ");
        int i = 0;
        while (i < this.sine.length) {
            System.out.println("angle : " + (double)i / (double)this.acc + "; value : " + this.sine[i]);
            ++i;
        }
        System.out.println();
        System.out.println("cosine : ");
        i = 0;
        while (i < this.cosine.length) {
            System.out.println("angle : " + (double)i / (double)this.acc + "; value : " + this.cosine[i]);
            ++i;
        }
    }
}

