/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.ontology.flightplan;

import aglobe.visio3D.PlanUpdate;
import aglobex.simulation.ontology.flightplan.EntitycontrolPlan;
import aglobex.simulation.ontology.flightplan.FlightPlanElement;
import aglobex.simulation.ontology.flightplan.QuickTurnFlightPlanElement;
import aglobex.simulation.ontology.flightplan.StraightFlightPlanElement;
import aglobex.simulation.ontology.flightplan.TurnFlightPlanElement;
import aglobex.simulation.ontology.flightplan.TurnType;
import aglobex.simulation.ontology.flightplan.WarpFlightPlanElement;
import aglobex.vecmath.Point3d;
import aglobex.vecmath.Vector3d;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"flightPlan"})
@XmlRootElement(name="FlightPlan")
public class FlightPlan
implements Externalizable,
EntitycontrolPlan {
    private static final byte TYPE_WARP = 0;
    private static final byte TYPE_QUICK_TURN = 1;
    private static final byte TYPE_STRAIGHT = 2;
    private static final byte TYPE_TURN = 3;
    @XmlElements(value={@XmlElement(name="Straight", type=StraightFlightPlanElement.class), @XmlElement(name="Turn", type=TurnFlightPlanElement.class), @XmlElement(name="QuickTurn", type=QuickTurnFlightPlanElement.class), @XmlElement(name="Warp", type=WarpFlightPlanElement.class)})
    public LinkedList<FlightPlanElement> flightPlan = new LinkedList();
    @XmlAttribute(name="BlockHeight3d")
    public double blockHeight3d = 0.0;
    @XmlAttribute(name="BlockWidth3d")
    public double blockWidth3d = 0.0;
    @XmlAttribute(name="PlanVersion")
    public int planVersion = -1;
    @XmlAttribute(name="Range2d")
    public double range2d = 0.0;
    @XmlAttribute(name="StartTimestamp")
    public long startTimeStamp = -1L;
    @XmlAttribute(name="TruncatePrevious")
    public double truncateDurationOfPreviousElement = 0.0;

    public FlightPlan() {
    }

    public FlightPlan(FlightPlan flightPlan, long newStartTimeStamp) {
        this.flightPlan.addAll(flightPlan.flightPlan);
        this.truncateDurationOfPreviousElement = flightPlan.truncateDurationOfPreviousElement;
        this.startTimeStamp = newStartTimeStamp;
    }

    public double getFlightPlanDuration() {
        double dur = 0.0;
        for (FlightPlanElement elem : this.flightPlan) {
            if (elem instanceof WarpFlightPlanElement || elem instanceof QuickTurnFlightPlanElement) continue;
            if (elem instanceof StraightFlightPlanElement) {
                dur += ((StraightFlightPlanElement)elem).duration;
                continue;
            }
            if (elem instanceof TurnFlightPlanElement) {
                dur += ((TurnFlightPlanElement)elem).duration;
                continue;
            }
            throw new RuntimeException("Flight element not supported: " + elem.getClass().getName());
        }
        return dur;
    }

    public double getFlightPlanLength() {
        double len = 0.0;
        double vel = 0.0;
        for (FlightPlanElement elem : this.flightPlan) {
            if (elem instanceof WarpFlightPlanElement) {
                vel = ((WarpFlightPlanElement)elem).velocity;
                continue;
            }
            if (elem instanceof QuickTurnFlightPlanElement) continue;
            if (elem instanceof StraightFlightPlanElement) {
                StraightFlightPlanElement sfpe = (StraightFlightPlanElement)elem;
                len += sfpe.duration * (0.5 * sfpe.velocityAcceleration * sfpe.duration + vel);
                vel += sfpe.velocityAcceleration * sfpe.duration;
                continue;
            }
            if (elem instanceof TurnFlightPlanElement) {
                len += ((TurnFlightPlanElement)elem).duration * vel;
                continue;
            }
            throw new RuntimeException("Flight element not supported: " + elem.getClass().getName());
        }
        return len;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.flightPlan.size());
        for (FlightPlanElement elem : this.flightPlan) {
            if (elem instanceof WarpFlightPlanElement) {
                out.writeByte(0);
            } else if (elem instanceof QuickTurnFlightPlanElement) {
                out.writeByte(1);
            } else if (elem instanceof StraightFlightPlanElement) {
                out.writeByte(2);
            } else if (elem instanceof TurnFlightPlanElement) {
                out.writeByte(3);
            } else {
                throw new IOException("Cannot write unknown flight plan element type: " + elem.getClass().getName());
            }
            elem.writeExternal(out);
        }
        out.writeInt(this.planVersion);
        out.writeDouble(this.truncateDurationOfPreviousElement);
        out.writeLong(this.startTimeStamp);
        out.writeDouble(this.blockWidth3d);
        out.writeDouble(this.blockHeight3d);
        out.writeDouble(this.range2d);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            FlightPlanElement fpe;
            byte type = in.readByte();
            switch (type) {
                case 0: {
                    fpe = new WarpFlightPlanElement();
                    break;
                }
                case 2: {
                    fpe = new StraightFlightPlanElement();
                    break;
                }
                case 1: {
                    fpe = new QuickTurnFlightPlanElement();
                    break;
                }
                case 3: {
                    fpe = new TurnFlightPlanElement();
                    break;
                }
                default: {
                    throw new IOException("Cannot read unknown flight plan element type: " + type);
                }
            }
            fpe.readExternal(in);
            this.flightPlan.add(fpe);
            ++i;
        }
        this.planVersion = in.readInt();
        this.truncateDurationOfPreviousElement = in.readDouble();
        this.startTimeStamp = in.readLong();
        this.blockWidth3d = in.readDouble();
        this.blockHeight3d = in.readDouble();
        this.range2d = in.readDouble();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Flight plan:\n");
        for (FlightPlanElement elem : this.flightPlan) {
            sb.append(elem.toString());
        }
        sb.append("truncateDurationOfPreviousElement: ");
        sb.append(this.truncateDurationOfPreviousElement);
        sb.append("\nstartTimeStamp: ");
        sb.append(this.startTimeStamp);
        sb.append("\n");
        sb.append("blockWidth3d: ").append(this.blockWidth3d).append("\nblockHeight3d: ").append(this.blockHeight3d);
        sb.append("\nrange2d: ").append(this.range2d).append("\n");
        return sb.toString();
    }

    public PlanUpdate convertToPlanUpdate(short objectId) throws Exception {
        short planSize = 0;
        for (FlightPlanElement elem : this.flightPlan) {
            if (!(elem instanceof StraightFlightPlanElement) && !(elem instanceof TurnFlightPlanElement)) continue;
            planSize = (short)(planSize + 1);
        }
        PlanUpdate pu = new PlanUpdate(objectId, 3, 0, this.blockWidth3d, this.blockHeight3d, planSize);
        int currentPosition = 0;
        Point3d st1_position = new Point3d();
        Vector3d st1_entityDirection = new Vector3d();
        Point3d st2_position = new Point3d();
        Vector3d st2_entityDirection = new Vector3d();
        double st2_velocity = 0.0;
        Point3d center = new Point3d();
        Point3d cu = new Point3d();
        Point3d cv = new Point3d();
        Vector3d u = new Vector3d();
        Vector3d v = new Vector3d();
        Vector3d z = new Vector3d();
        Vector3d w = new Vector3d();
        double angle = 0.0;
        double elevation = 0.0;
        for (FlightPlanElement elem : this.flightPlan) {
            st1_position.set(st2_position);
            st1_entityDirection.set(st2_entityDirection);
            double st1_velocity = st2_velocity;
            if (elem instanceof WarpFlightPlanElement) {
                WarpFlightPlanElement warp = (WarpFlightPlanElement)elem;
                st2_position.set(warp.positionX, warp.positionY, warp.positionZ);
                st2_entityDirection.set(warp.directionVectorX, warp.directionVectorY, warp.directionVectorZ);
                st2_velocity = warp.velocity;
                continue;
            }
            if (elem instanceof QuickTurnFlightPlanElement) {
                QuickTurnFlightPlanElement quickTurn = (QuickTurnFlightPlanElement)elem;
                st2_position.set(st1_position);
                st2_entityDirection.set(quickTurn.directionVectorX, quickTurn.directionVectorY, quickTurn.directionVectorZ);
                st2_velocity = st1_velocity;
                continue;
            }
            if (elem instanceof StraightFlightPlanElement) {
                StraightFlightPlanElement straight = (StraightFlightPlanElement)elem;
                double s = st1_velocity * straight.duration + 0.5 * straight.velocityAcceleration * straight.duration * straight.duration;
                u.set(st1_entityDirection);
                u.normalize(s);
                st2_position.add(st1_position, u);
                st2_entityDirection.set(st1_entityDirection);
                st2_velocity = st1_velocity + straight.velocityAcceleration * straight.duration;
                pu.segmentID[currentPosition] = elem.elementID;
                pu.segmentType[currentPosition] = 1;
                pu.segmentDescription[currentPosition] = new double[6];
                pu.segmentDescription[currentPosition][0] = st1_position.x;
                pu.segmentDescription[currentPosition][1] = st1_position.y;
                pu.segmentDescription[currentPosition][2] = st1_position.z;
                pu.segmentDescription[currentPosition][3] = st2_position.x;
                pu.segmentDescription[currentPosition][4] = st2_position.y;
                pu.segmentDescription[currentPosition][5] = st2_position.z;
                ++currentPosition;
                continue;
            }
            if (elem instanceof TurnFlightPlanElement) {
                TurnFlightPlanElement turn = (TurnFlightPlanElement)elem;
                if (turn.duration > 1.0E-4) {
                    double sinAlpha;
                    double cosAlpha;
                    if (turn.type == TurnType.WORLDHORIZONTAL) {
                        v.set(0.0, 0.0, 1.0);
                        u.cross(st1_entityDirection, v);
                        u.z = 0.0;
                        u.normalize(turn.radius);
                        center.set(st1_position);
                        center.add(u);
                        v.set(st1_entityDirection);
                        v.z = 0.0;
                        v.normalize(turn.radius);
                        u.scale(-1.0);
                        double xylen = Math.sqrt(st1_entityDirection.x * st1_entityDirection.x + st1_entityDirection.y * st1_entityDirection.y);
                        angle = xylen * st1_velocity * turn.duration / turn.radius;
                        z.set(st1_entityDirection);
                        z.normalize(st1_velocity);
                        elevation = z.z * turn.duration;
                        cosAlpha = Math.cos(angle);
                        sinAlpha = Math.sin(angle);
                        double r = Math.abs(turn.radius);
                        st2_position.set(center);
                        st2_position.addScaled(cosAlpha, u);
                        st2_position.addScaled(sinAlpha, v);
                        st2_position.z = center.z + angle * r * st1_entityDirection.z / xylen;
                        st2_entityDirection.set(cosAlpha * v.x - sinAlpha * u.x, cosAlpha * v.y - sinAlpha * u.y, 0.0);
                        st2_entityDirection.normalize(xylen);
                        st2_entityDirection.z = st1_entityDirection.z;
                        st2_velocity = st1_velocity;
                    } else if (turn.type == TurnType.HORIZONTAL) {
                        z.set(-st1_entityDirection.x * st1_entityDirection.z, -st1_entityDirection.y * st1_entityDirection.z, st1_entityDirection.x * st1_entityDirection.x + st1_entityDirection.y * st1_entityDirection.y);
                        if (z.z < 0.0) {
                            z.negate();
                        }
                        z.normalize();
                        u.cross(st1_entityDirection, z);
                        u.z = 0.0;
                        u.normalize(turn.radius);
                        center.set(st1_position);
                        center.add(u);
                        v.set(st1_entityDirection);
                        v.normalize(turn.radius);
                        u.scale(-1.0);
                        angle = st1_velocity * turn.duration / turn.radius;
                        elevation = 0.0;
                        double cosAlpha2 = Math.cos(angle);
                        double sinAlpha2 = Math.sin(angle);
                        w.scale(cosAlpha2, u);
                        w.addScaled(sinAlpha2, v);
                        st2_position.add(center, w);
                        if (turn.radius >= 0.0) {
                            st2_entityDirection.cross(w, z);
                            st2_entityDirection.normalize();
                        } else {
                            st2_entityDirection.cross(z, w);
                            st2_entityDirection.normalize();
                        }
                        st2_velocity = st1_velocity;
                    } else if (turn.type == TurnType.VERTICAL) {
                        z.set(-st1_entityDirection.x * st1_entityDirection.z, -st1_entityDirection.y * st1_entityDirection.z, st1_entityDirection.x * st1_entityDirection.x + st1_entityDirection.y * st1_entityDirection.y);
                        if (z.z < 0.0) {
                            z.negate();
                        }
                        z.normalize();
                        center.set(st1_position);
                        center.addScaled(turn.radius, z);
                        double r = Math.abs(turn.radius);
                        v.set(st1_entityDirection);
                        v.normalize(r);
                        u.set(z);
                        u.scale(-turn.radius);
                        angle = st1_velocity * turn.duration / r;
                        elevation = 0.0;
                        cosAlpha = Math.cos(angle);
                        sinAlpha = Math.sin(angle);
                        st2_position.set(center);
                        st2_position.addScaled(cosAlpha, u);
                        st2_position.addScaled(sinAlpha, v);
                        w.cross(st1_entityDirection, z);
                        if (turn.radius >= 0.0) {
                            z.sub(center, st2_position);
                        } else {
                            z.sub(st2_position, center);
                        }
                        z.normalize();
                        st2_entityDirection.cross(z, w);
                        st2_entityDirection.normalize();
                        st2_velocity = st1_velocity;
                    }
                    pu.segmentID[currentPosition] = elem.elementID;
                    pu.segmentType[currentPosition] = 2;
                    pu.segmentDescription[currentPosition] = new double[11];
                    pu.segmentDescription[currentPosition][0] = center.x;
                    pu.segmentDescription[currentPosition][1] = center.y;
                    pu.segmentDescription[currentPosition][2] = center.z;
                    pu.segmentDescription[currentPosition][3] = center.x + u.x;
                    pu.segmentDescription[currentPosition][4] = center.y + u.y;
                    pu.segmentDescription[currentPosition][5] = center.z + u.z;
                    pu.segmentDescription[currentPosition][6] = center.x + v.x;
                    pu.segmentDescription[currentPosition][7] = center.y + v.y;
                    pu.segmentDescription[currentPosition][8] = center.z + v.z;
                    pu.segmentDescription[currentPosition][9] = angle;
                    pu.segmentDescription[currentPosition][10] = elevation;
                } else {
                    pu.segmentID[currentPosition] = elem.elementID;
                    pu.segmentType[currentPosition] = 1;
                    pu.segmentDescription[currentPosition] = new double[6];
                    pu.segmentDescription[currentPosition][0] = st1_position.x;
                    pu.segmentDescription[currentPosition][1] = st1_position.y;
                    pu.segmentDescription[currentPosition][2] = st1_position.z;
                    pu.segmentDescription[currentPosition][3] = st2_position.x;
                    pu.segmentDescription[currentPosition][4] = st2_position.y;
                    pu.segmentDescription[currentPosition][5] = st2_position.z;
                }
                ++currentPosition;
                continue;
            }
            throw new Exception("Unknown plan element type: " + elem.getClass().getName());
        }
        return pu;
    }

    public int getPlanVersion() {
        return this.planVersion;
    }
}

