/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.ontology.entity;

import aglobe.ontology.Message;
import aglobex.simulation.configurator.ConfiguratorTools;
import aglobex.simulation.entitymanager.GISShellProvider;
import aglobex.simulation.ontology.ConfFile;
import aglobex.simulation.ontology.ConfObject;
import aglobex.simulation.ontology.EntityType;
import aglobex.simulation.ontology.Param;
import aglobex.simulation.ontology.VisibilityCategory;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTypeDescriptor
implements Externalizable {
    private static final long serialVersionUID = 9163976680660875288L;
    public String typeName;
    public String simulationClass;
    public String visioTypeName;
    public double crashRange;
    public double visibilityRange;
    public double visibilityFailurePct;
    public LinkedHashMap<String, String> userParamsString;
    public LinkedHashMap<String, Double> userParamsDouble;
    public LinkedHashMap<String, Integer> userParamsInteger;
    public LinkedHashMap<String, Boolean> userParamsBoolean;
    public LinkedHashMap<String, Long> userParamsLong;
    public LinkedHashMap<String, InputStream> userFiles;
    public LinkedHashMap<String, Object> userObjects;

    public EntityTypeDescriptor() {
    }

    public EntityTypeDescriptor(String typeName, String simulationClass, String visioTypeName, double crashRange, double visibilityRange, double visibilityFailurePct, LinkedHashMap<String, String> userParamsString, LinkedHashMap<String, Double> userParamsDouble, LinkedHashMap<String, Integer> userParamsInteger, LinkedHashMap<String, Boolean> userParamsBoolean, LinkedHashMap<String, Long> userParamsLong, LinkedHashMap<String, InputStream> userFiles, LinkedHashMap<String, Object> userObjects) {
        this.typeName = typeName;
        this.simulationClass = simulationClass;
        this.visioTypeName = visioTypeName;
        this.crashRange = crashRange;
        this.visibilityRange = visibilityRange;
        this.visibilityFailurePct = visibilityFailurePct;
        this.userParamsString = userParamsString;
        this.userParamsDouble = userParamsDouble;
        this.userParamsInteger = userParamsInteger;
        this.userParamsBoolean = userParamsBoolean;
        this.userParamsLong = userParamsLong;
        this.userFiles = userFiles;
        this.userObjects = userObjects;
    }

    public EntityTypeDescriptor(GISShellProvider shellProvider, EntityType entityType, VisibilityCategory visibilityCategory) throws Exception {
        Object content;
        this.typeName = entityType.getName();
        this.simulationClass = entityType.getSimulationClass();
        this.visioTypeName = entityType.getVisioTypeName();
        this.crashRange = entityType.getCrashRange();
        this.visibilityRange = visibilityCategory.getVisibilityRange();
        this.visibilityFailurePct = visibilityCategory.getFailurePct();
        this.userParamsString = new LinkedHashMap();
        this.userParamsDouble = new LinkedHashMap();
        this.userParamsInteger = new LinkedHashMap();
        this.userParamsBoolean = new LinkedHashMap();
        this.userParamsLong = new LinkedHashMap();
        for (Param item : entityType.getParam()) {
            if (item.getType().equals("String")) {
                this.userParamsString.put(item.getName(), item.getValue());
                continue;
            }
            if (item.getType().equals("Double")) {
                try {
                    this.userParamsDouble.put(item.getName(), Double.parseDouble(item.getValue()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("Double param: " + item.getName() + " contains not double value.");
                }
            }
            if (item.getType().equals("Integer")) {
                try {
                    this.userParamsInteger.put(item.getName(), Integer.parseInt(item.getValue()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("Integer param: " + item.getName() + " contains not integer value.");
                }
            }
            if (item.getType().equals("Boolean")) {
                try {
                    this.userParamsBoolean.put(item.getName(), Boolean.parseBoolean(item.getValue()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("Boolean param: " + item.getName() + " contains not boolean value.");
                }
            }
            if (!item.getType().equals("Long")) continue;
            try {
                this.userParamsLong.put(item.getName(), Long.parseLong(item.getValue()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Long param: " + item.getName() + " contains not long value.");
            }
        }
        this.userFiles = new LinkedHashMap();
        if (entityType.getConfFile().size() != 0) {
            LinkedHashSet<String> fileToLoad = new LinkedHashSet<String>();
            for (ConfFile confFile : entityType.getConfFile()) {
                fileToLoad.add(confFile.getFilePath());
            }
            Map<String, InputStream> f = ConfiguratorTools.getConfFiles(shellProvider, fileToLoad);
            for (ConfFile confFile : entityType.getConfFile()) {
                content = f.get(confFile.getFilePath());
                if (content == null) {
                    throw new Exception("Cannot fetch user file: " + confFile.getFilePath());
                }
                this.userFiles.put(confFile.getName(), (InputStream)content);
            }
        }
        this.userObjects = new LinkedHashMap();
        if (entityType.getConfObject().size() != 0) {
            LinkedHashMap<String, String> objectsToLoad = new LinkedHashMap<String, String>();
            for (ConfObject confObject : entityType.getConfObject()) {
                objectsToLoad.put(confObject.getFilePath(), confObject.getDefClass());
            }
            Map<String, Object> o = ConfiguratorTools.getConfObjects(shellProvider, objectsToLoad);
            for (ConfObject confObject : entityType.getConfObject()) {
                content = o.get(confObject.getFilePath());
                if (content == null) {
                    throw new Exception("Cannot fetch user object: " + confObject.getFilePath());
                }
                this.userObjects.put(confObject.getName(), content);
            }
        }
    }

    public void set(EntityTypeDescriptor entityTypeDescriptor) throws Exception {
        this.typeName = entityTypeDescriptor.typeName;
        this.simulationClass = entityTypeDescriptor.simulationClass;
        this.visioTypeName = entityTypeDescriptor.visioTypeName;
        this.crashRange = entityTypeDescriptor.crashRange;
        this.visibilityRange = entityTypeDescriptor.visibilityRange;
        this.visibilityFailurePct = entityTypeDescriptor.visibilityFailurePct;
        this.userParamsString = entityTypeDescriptor.userParamsString;
        this.userParamsDouble = entityTypeDescriptor.userParamsDouble;
        this.userParamsInteger = entityTypeDescriptor.userParamsInteger;
        this.userParamsBoolean = entityTypeDescriptor.userParamsBoolean;
        this.userParamsLong = entityTypeDescriptor.userParamsLong;
        this.userFiles = entityTypeDescriptor.userFiles;
        this.userObjects = entityTypeDescriptor.userObjects;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Message.writeString(out, this.typeName);
        Message.writeString(out, this.simulationClass);
        Message.writeString(out, this.visioTypeName);
        out.writeDouble(this.crashRange);
        out.writeDouble(this.visibilityRange);
        out.writeDouble(this.visibilityFailurePct);
        out.writeInt(this.userParamsString.size());
        for (Map.Entry<String, String> entry : this.userParamsString.entrySet()) {
            Message.writeString(out, entry.getKey());
            Message.writeString(out, entry.getValue());
        }
        out.writeInt(this.userParamsDouble.size());
        for (Map.Entry<String, Object> entry : this.userParamsDouble.entrySet()) {
            Message.writeString(out, entry.getKey());
            out.writeDouble((Double)entry.getValue());
        }
        out.writeInt(this.userParamsInteger.size());
        for (Map.Entry<String, Object> entry : this.userParamsInteger.entrySet()) {
            Message.writeString(out, entry.getKey());
            out.writeInt((Integer)entry.getValue());
        }
        out.writeInt(this.userParamsBoolean.size());
        for (Map.Entry<String, Object> entry : this.userParamsBoolean.entrySet()) {
            Message.writeString(out, entry.getKey());
            out.writeBoolean((Boolean)entry.getValue());
        }
        out.writeInt(this.userParamsLong.size());
        for (Map.Entry<String, Object> entry : this.userParamsLong.entrySet()) {
            Message.writeString(out, entry.getKey());
            out.writeLong((Long)entry.getValue());
        }
        out.writeInt(this.userFiles.size());
        for (Map.Entry<String, Object> entry : this.userFiles.entrySet()) {
            Message.writeString(out, entry.getKey());
            InputStream is = (InputStream)entry.getValue();
            int cnt = is.available();
            out.writeInt(cnt);
            int i = 0;
            while (i < cnt) {
                out.writeByte(is.read());
                ++i;
            }
            is.reset();
        }
        out.writeInt(this.userObjects.size());
        for (Map.Entry<String, Object> entry : this.userObjects.entrySet()) {
            Message.writeString(out, entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeName = Message.readString(in);
        this.simulationClass = Message.readString(in);
        this.visioTypeName = Message.readString(in);
        this.crashRange = in.readDouble();
        this.visibilityRange = in.readDouble();
        this.visibilityFailurePct = in.readDouble();
        int params = in.readInt();
        this.userParamsString = new LinkedHashMap();
        int i = 0;
        while (i < params) {
            this.userParamsString.put(Message.readString(in), Message.readString(in));
            ++i;
        }
        params = in.readInt();
        this.userParamsDouble = new LinkedHashMap();
        i = 0;
        while (i < params) {
            this.userParamsDouble.put(Message.readString(in), in.readDouble());
            ++i;
        }
        params = in.readInt();
        this.userParamsInteger = new LinkedHashMap();
        i = 0;
        while (i < params) {
            this.userParamsInteger.put(Message.readString(in), in.readInt());
            ++i;
        }
        params = in.readInt();
        this.userParamsBoolean = new LinkedHashMap();
        i = 0;
        while (i < params) {
            this.userParamsBoolean.put(Message.readString(in), in.readBoolean());
            ++i;
        }
        params = in.readInt();
        this.userParamsLong = new LinkedHashMap();
        i = 0;
        while (i < params) {
            this.userParamsLong.put(Message.readString(in), in.readLong());
            ++i;
        }
        this.userFiles = new LinkedHashMap();
        params = in.readInt();
        i = 0;
        while (i < params) {
            String k = Message.readString(in);
            int nb = in.readInt();
            byte[] data = new byte[nb];
            int j = 0;
            while (j < nb) {
                data[j] = in.readByte();
                ++j;
            }
            this.userFiles.put(k, new ByteArrayInputStream(data));
            ++i;
        }
        params = in.readInt();
        this.userObjects = new LinkedHashMap();
        i = 0;
        while (i < params) {
            this.userObjects.put(Message.readString(in), in.readObject());
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EntityTypeDescriptor: typeName=");
        sb.append(this.typeName).append(" simulationClass=").append(this.simulationClass).append(" visioTypeName=").append(this.visioTypeName);
        sb.append(" crashRange=").append(this.crashRange).append(" visibilityRange=").append(this.visibilityRange);
        sb.append(" visibilityFailurePct=").append(this.visibilityFailurePct);
        sb.append(" StringParams=(");
        for (Map.Entry<String, String> entry : this.userParamsString.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append((Object)entry.getValue()).append(";");
        }
        sb.append(") DoubleParams=(");
        for (Map.Entry<String, Object> entry : this.userParamsDouble.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        sb.append(") IntegerParams=(");
        for (Map.Entry<String, Object> entry : this.userParamsInteger.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        sb.append(") BooleanParams=(");
        for (Map.Entry<String, Object> entry : this.userParamsBoolean.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        sb.append(") LongParams=(");
        for (Map.Entry<String, Object> entry : this.userParamsLong.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        sb.append(") confFiles=(");
        for (Map.Entry<String, Object> entry : this.userFiles.entrySet()) {
            if (entry.getValue() == null) continue;
            sb.append((Object)entry.getKey()).append(";");
        }
        sb.append(") confObjects=(");
        for (Map.Entry<String, Object> entry : this.userObjects.entrySet()) {
            if (entry.getValue() == null) continue;
            sb.append((Object)entry.getKey()).append("=\n").append(entry.getValue().toString()).append("\n;");
        }
        sb.append(")");
        return sb.toString();
    }
}

