/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.ontology.entity;

import aglobe.ontology.Message;
import aglobex.simulation.ontology.entity.EntityTypeDescriptor;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityDescriptor
implements Externalizable {
    public long startTime;
    public EntityTypeDescriptor typeDescriptor;
    public LinkedHashMap<String, String> confParamsString;
    public LinkedHashMap<String, Double> confParamsDouble;
    public LinkedHashMap<String, Integer> confParamsInteger;
    public LinkedHashMap<String, Boolean> confParamsBoolean;
    public LinkedHashMap<String, Long> confParamsLong;
    public LinkedHashMap<String, InputStream> confFiles;
    public LinkedHashMap<String, Object> confObjects;

    public EntityDescriptor() {
    }

    public EntityDescriptor(long startTime, EntityTypeDescriptor typeDescriptor, LinkedHashMap<String, String> confParamsString, LinkedHashMap<String, Double> confParamsDouble, LinkedHashMap<String, Integer> confParamsInteger, LinkedHashMap<String, Boolean> confParamsBoolean, LinkedHashMap<String, Long> confParamsLong, LinkedHashMap<String, InputStream> confFiles, LinkedHashMap<String, Object> confObjects) {
        this.startTime = startTime;
        this.typeDescriptor = typeDescriptor;
        this.confParamsString = confParamsString;
        this.confParamsDouble = confParamsDouble;
        this.confParamsInteger = confParamsInteger;
        this.confParamsBoolean = confParamsBoolean;
        this.confParamsLong = confParamsLong;
        this.confFiles = confFiles;
        this.confObjects = confObjects;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.startTime);
        this.typeDescriptor.writeExternal(out);
        out.writeInt(this.confParamsString.size());
        for (Map.Entry<String, String> entry : this.confParamsString.entrySet()) {
            Message.writeString(out, entry.getKey());
            Message.writeString(out, entry.getValue());
        }
        out.writeInt(this.confParamsDouble.size());
        for (Map.Entry<String, Object> entry : this.confParamsDouble.entrySet()) {
            Message.writeString(out, entry.getKey());
            out.writeDouble((Double)entry.getValue());
        }
        out.writeInt(this.confParamsInteger.size());
        for (Map.Entry<String, Object> entry : this.confParamsInteger.entrySet()) {
            Message.writeString(out, entry.getKey());
            out.writeInt((Integer)entry.getValue());
        }
        out.writeInt(this.confParamsBoolean.size());
        for (Map.Entry<String, Object> entry : this.confParamsBoolean.entrySet()) {
            Message.writeString(out, entry.getKey());
            out.writeBoolean((Boolean)entry.getValue());
        }
        out.writeInt(this.confParamsLong.size());
        for (Map.Entry<String, Object> entry : this.confParamsLong.entrySet()) {
            Message.writeString(out, entry.getKey());
            out.writeLong((Long)entry.getValue());
        }
        out.writeInt(this.confFiles.size());
        for (Map.Entry<String, Object> entry : this.confFiles.entrySet()) {
            Message.writeString(out, entry.getKey());
            InputStream is = (InputStream)entry.getValue();
            int cnt = is.available();
            out.writeInt(cnt);
            int i = 0;
            while (i < cnt) {
                out.writeByte(is.read());
                ++i;
            }
            is.reset();
        }
        out.writeInt(this.confObjects.size());
        for (Map.Entry<String, Object> entry : this.confObjects.entrySet()) {
            Message.writeString(out, entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startTime = in.readLong();
        this.typeDescriptor = new EntityTypeDescriptor();
        this.typeDescriptor.readExternal(in);
        int cnt = in.readInt();
        this.confParamsString = new LinkedHashMap();
        int i = 0;
        while (i < cnt) {
            this.confParamsString.put(Message.readString(in), Message.readString(in));
            ++i;
        }
        cnt = in.readInt();
        this.confParamsDouble = new LinkedHashMap();
        i = 0;
        while (i < cnt) {
            this.confParamsDouble.put(Message.readString(in), in.readDouble());
            ++i;
        }
        cnt = in.readInt();
        this.confParamsInteger = new LinkedHashMap();
        i = 0;
        while (i < cnt) {
            this.confParamsInteger.put(Message.readString(in), in.readInt());
            ++i;
        }
        cnt = in.readInt();
        this.confParamsBoolean = new LinkedHashMap();
        i = 0;
        while (i < cnt) {
            this.confParamsBoolean.put(Message.readString(in), in.readBoolean());
            ++i;
        }
        cnt = in.readInt();
        this.confParamsLong = new LinkedHashMap();
        i = 0;
        while (i < cnt) {
            this.confParamsLong.put(Message.readString(in), in.readLong());
            ++i;
        }
        this.confFiles = new LinkedHashMap();
        cnt = in.readInt();
        i = 0;
        while (i < cnt) {
            String k = Message.readString(in);
            int nb = in.readInt();
            byte[] data = new byte[nb];
            int j = 0;
            while (j < nb) {
                data[j] = in.readByte();
                ++j;
            }
            this.confFiles.put(k, new ByteArrayInputStream(data));
            ++i;
        }
        cnt = in.readInt();
        this.confObjects = new LinkedHashMap();
        i = 0;
        while (i < cnt) {
            this.confObjects.put(Message.readString(in), in.readObject());
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EntityDescriptor: startTime=");
        sb.append(this.startTime).append(" millis StringParams=(");
        for (Map.Entry<String, String> entry : this.confParamsString.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append((Object)entry.getValue()).append(";");
        }
        sb.append(") DoubleParams=(");
        for (Map.Entry<String, Object> entry : this.confParamsDouble.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        sb.append(") IntegerParams=(");
        for (Map.Entry<String, Object> entry : this.confParamsInteger.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        sb.append(") BooleanParams=(");
        for (Map.Entry<String, Object> entry : this.confParamsBoolean.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        sb.append(") LongParams=(");
        for (Map.Entry<String, Object> entry : this.confParamsLong.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        sb.append(") confFiles=(");
        for (Map.Entry<String, Object> entry : this.confFiles.entrySet()) {
            if (entry.getValue() == null) continue;
            sb.append((Object)entry.getKey()).append(";");
        }
        sb.append(") confObjects=(");
        for (Map.Entry<String, Object> entry : this.confObjects.entrySet()) {
            if (entry.getValue() == null) continue;
            sb.append((Object)entry.getKey()).append("=\n").append(entry.getValue().toString()).append("\n;");
        }
        sb.append(")\n").append(this.typeDescriptor.toString());
        return sb.toString();
    }
}

