/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.global;

import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobex.simulation.entitymanager.GISShellProvider;
import aglobex.simulation.entitymanager.PlatformRecord;
import aglobex.simulation.ontology.EntityType;
import aglobex.simulation.ontology.VisibilityCategory;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import aglobex.simulation.ontology.entity.EntityTypeDescriptor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityRecord
implements Externalizable {
    public String containerName;
    public String linkedToContainerName;
    public Address address;
    public PlatformRecord platform;
    public short visioID;
    public int indexToSlotArray;
    public EntityDescriptor entityDescriptor;

    public EntityRecord() {
    }

    public EntityRecord(GISShellProvider shellProvider, String containerName, String linkedToContainerName, EntityType entityType, VisibilityCategory visibilityCategory, long startTime, LinkedHashMap<String, String> confParamsString, LinkedHashMap<String, Double> confParamsDouble, LinkedHashMap<String, Integer> confParamsInteger, LinkedHashMap<String, Boolean> confParamsBoolean, LinkedHashMap<String, Long> confParamsLong, LinkedHashMap<String, InputStream> confFiles, LinkedHashMap<String, Object> confObjects) throws Exception {
        this(containerName, linkedToContainerName, new EntityTypeDescriptor(shellProvider, entityType, visibilityCategory), startTime, confParamsString, confParamsDouble, confParamsInteger, confParamsBoolean, confParamsLong, confFiles, confObjects);
    }

    public EntityRecord(GISShellProvider shellProvider, String containerName, String linkedToContainerName, EntityType entityType, VisibilityCategory visibilityCategory, long startTime) throws Exception {
        this(shellProvider, containerName, linkedToContainerName, entityType, visibilityCategory, startTime, null, null, null, null, null, null, null);
    }

    public EntityRecord(String containerName, String linkedToContainerName, EntityTypeDescriptor typeDescriptor, long startTime, LinkedHashMap<String, String> confParamsString, LinkedHashMap<String, Double> confParamsDouble, LinkedHashMap<String, Integer> confParamsInteger, LinkedHashMap<String, Boolean> confParamsBoolean, LinkedHashMap<String, Long> confParamsLong, LinkedHashMap<String, InputStream> confFiles, LinkedHashMap<String, Object> confObjects) {
        this.containerName = containerName;
        this.linkedToContainerName = linkedToContainerName;
        this.visioID = (short)-1;
        if (confParamsString == null) {
            confParamsString = new LinkedHashMap();
        }
        if (confParamsDouble == null) {
            confParamsDouble = new LinkedHashMap();
        }
        if (confParamsInteger == null) {
            confParamsInteger = new LinkedHashMap();
        }
        if (confParamsBoolean == null) {
            confParamsBoolean = new LinkedHashMap();
        }
        if (confParamsLong == null) {
            confParamsLong = new LinkedHashMap();
        }
        if (confFiles == null) {
            confFiles = new LinkedHashMap();
        }
        if (confObjects == null) {
            confObjects = new LinkedHashMap();
        }
        this.entityDescriptor = new EntityDescriptor(startTime, typeDescriptor, confParamsString, confParamsDouble, confParamsInteger, confParamsBoolean, confParamsLong, confFiles, confObjects);
    }

    public EntityRecord(String containerName, String linkedToContainerName, EntityTypeDescriptor typeDescriptor, long startTime) {
        this(containerName, linkedToContainerName, typeDescriptor, startTime, null, null, null, null, null, null, null);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Message.writeString(out, this.containerName);
        Message.writeString(out, this.linkedToContainerName);
        Message.writeString(out, this.address != null ? this.address.toString() : null);
        out.writeShort(this.visioID);
        out.writeInt(this.indexToSlotArray);
        this.entityDescriptor.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.containerName = Message.readString(in);
        this.linkedToContainerName = Message.readString(in);
        String tmp = Message.readString(in);
        this.address = null;
        if (tmp != null) {
            this.address = Address.getAddress(tmp);
        }
        this.visioID = in.readShort();
        this.indexToSlotArray = in.readInt();
        this.entityDescriptor = new EntityDescriptor();
        this.entityDescriptor.readExternal(in);
    }
}

