/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.global;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class EntitiesPositionInfo
implements Externalizable {
    public long simulationTimestamp;
    public double[] x;
    public double[] y;
    public double[] z;
    public double[] yaw;
    public double[] pitch;
    public double[] roll;
    public double[][] userState;
    public short[] visioId;

    public EntitiesPositionInfo() {
    }

    public EntitiesPositionInfo(int slots, int numberOfUserStateValues) {
        this.x = new double[slots];
        this.y = new double[slots];
        this.z = new double[slots];
        this.yaw = new double[slots];
        this.pitch = new double[slots];
        this.roll = new double[slots];
        this.userState = new double[slots][numberOfUserStateValues];
        this.visioId = new short[slots];
        this.clear();
    }

    public EntitiesPositionInfo(EntitiesPositionInfo epi) {
        int slots = epi.x.length;
        int numberOfUserStateValues = epi.userState[0].length;
        this.x = new double[slots];
        this.y = new double[slots];
        this.z = new double[slots];
        this.yaw = new double[slots];
        this.pitch = new double[slots];
        this.roll = new double[slots];
        this.userState = new double[slots][numberOfUserStateValues];
        this.visioId = new short[slots];
        int i = 0;
        while (i < slots) {
            this.simulationTimestamp = epi.simulationTimestamp;
            this.visioId[i] = epi.visioId[i];
            if (this.visioId[i] >= 0) {
                this.x[i] = epi.x[i];
                this.y[i] = epi.y[i];
                this.z[i] = epi.z[i];
                this.roll[i] = epi.roll[i];
                this.pitch[i] = epi.pitch[i];
                this.yaw[i] = epi.yaw[i];
                System.arraycopy(epi.userState[i], 0, this.userState[i], 0, numberOfUserStateValues);
            }
            ++i;
        }
    }

    public void changeNumberOfSlots(int slots, int numberOfUserStateValues) {
        int oldSlots = this.x.length;
        int minimum = Math.min(oldSlots, slots);
        int oldNumberOfUserStateValues = this.userState[0].length;
        int minimumUserStateValues = Math.min(oldNumberOfUserStateValues, numberOfUserStateValues);
        double[] newx = new double[slots];
        double[] newy = new double[slots];
        double[] newz = new double[slots];
        double[] newroll = new double[slots];
        double[] newpitch = new double[slots];
        double[] newyaw = new double[slots];
        double[][] newUserState = new double[slots][numberOfUserStateValues];
        short[] newvisioId = new short[slots];
        System.arraycopy(this.x, 0, newx, 0, minimum);
        System.arraycopy(this.y, 0, newy, 0, minimum);
        System.arraycopy(this.z, 0, newz, 0, minimum);
        System.arraycopy(this.roll, 0, newroll, 0, minimum);
        System.arraycopy(this.pitch, 0, newpitch, 0, minimum);
        System.arraycopy(this.yaw, 0, newyaw, 0, minimum);
        System.arraycopy(this.visioId, 0, newvisioId, 0, minimum);
        int i = 0;
        while (i < minimum) {
            System.arraycopy(this.userState[i], 0, newUserState[i], 0, minimumUserStateValues);
            ++i;
        }
        i = this.visioId.length;
        while (i < slots) {
            newvisioId[i] = -1;
            ++i;
        }
        this.x = newx;
        this.y = newy;
        this.z = newz;
        this.roll = newroll;
        this.pitch = newpitch;
        this.yaw = newyaw;
        this.userState = newUserState;
        this.visioId = newvisioId;
    }

    public void clear() {
        int i = 0;
        while (i < this.visioId.length) {
            this.visioId[i] = -1;
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Entities position info: SimulationTimestamp: ").append(this.simulationTimestamp).append("\n");
        sb.append("X: ");
        StringBuilder sy = new StringBuilder("\nY: ");
        StringBuilder sz = new StringBuilder("\nZ: ");
        StringBuilder syaw = new StringBuilder("\nYaw: ");
        StringBuilder spitch = new StringBuilder("\nPitch: ");
        StringBuilder sroll = new StringBuilder("\nRoll: ");
        StringBuilder usroll = new StringBuilder("\nUserState: ");
        int i = 0;
        while (i < this.x.length) {
            sb.append(this.x[i]);
            sb.append(", ");
            sy.append(this.y[i]);
            sy.append(", ");
            sz.append(this.z[i]);
            sz.append(", ");
            syaw.append(this.yaw[i]);
            syaw.append(", ");
            spitch.append(this.pitch[i]);
            spitch.append(", ");
            sroll.append(this.roll[i]);
            sroll.append(", ");
            usroll.append("{");
            int j = 0;
            while (j < this.userState[i].length) {
                usroll.append(this.userState[i][j]);
                usroll.append(", ");
                ++j;
            }
            usroll.append("}, ");
            ++i;
        }
        sb.append((CharSequence)sy);
        sb.append((CharSequence)sz);
        sb.append((CharSequence)syaw);
        sb.append((CharSequence)spitch);
        sb.append((CharSequence)sroll);
        sb.append((CharSequence)usroll);
        sb.append("\n");
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int slots = this.x.length;
        int userStateLength = this.userState[0].length;
        out.writeLong(this.simulationTimestamp);
        out.writeInt(slots);
        out.writeInt(userStateLength);
        int i = 0;
        while (i < slots) {
            out.writeShort(this.visioId[i]);
            if (this.visioId[i] >= 0) {
                out.writeDouble(this.x[i]);
                out.writeDouble(this.y[i]);
                out.writeDouble(this.z[i]);
                out.writeDouble(this.yaw[i]);
                out.writeDouble(this.pitch[i]);
                out.writeDouble(this.roll[i]);
                int j = 0;
                while (j < userStateLength) {
                    out.writeDouble(this.userState[i][j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.simulationTimestamp = in.readLong();
        int slots = in.readInt();
        int userStateLength = in.readInt();
        this.x = new double[slots];
        this.y = new double[slots];
        this.z = new double[slots];
        this.yaw = new double[slots];
        this.pitch = new double[slots];
        this.roll = new double[slots];
        this.userState = new double[slots][userStateLength];
        this.visioId = new short[slots];
        int i = 0;
        while (i < slots) {
            this.visioId[i] = in.readShort();
            if (this.visioId[i] >= 0) {
                this.x[i] = in.readDouble();
                this.y[i] = in.readDouble();
                this.z[i] = in.readDouble();
                this.yaw[i] = in.readDouble();
                this.pitch[i] = in.readDouble();
                this.roll[i] = in.readDouble();
                int j = 0;
                while (j < userStateLength) {
                    this.userState[i][j] = in.readDouble();
                    ++j;
                }
            }
            ++i;
        }
    }
}

