/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.global;

import aglobex.simulation.global.EntitiesPositionInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class EntitiesPositionDistanceInfo
implements Externalizable {
    public EntitiesPositionInfo positions;
    public double[][] distanceMatrix;
    public double[] minimalDistances2;
    public double overalMinimalDistance2;
    public double[][] XYdistanceMatrix;

    public String toString() {
        StringBuilder sb = new StringBuilder("Entities position distance info:\n=================================\n");
        sb.append(this.positions.toString());
        sb.append("Distances:\n");
        int i = 0;
        while (i < this.distanceMatrix.length) {
            sb.append("( ");
            int j = 0;
            while (j < this.distanceMatrix.length) {
                sb.append(this.distanceMatrix[i][j]);
                sb.append(" ");
                ++j;
            }
            sb.append(")\n");
            ++i;
        }
        sb.append("=================================\n");
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.positions.writeExternal(out);
        short[] visioId = this.positions.visioId;
        int size = visioId.length;
        int i = 0;
        while (i < size) {
            if (visioId[i] >= 0) {
                int j = 0;
                while (j < size) {
                    if (visioId[j] >= 0) {
                        out.writeDouble(this.distanceMatrix[i][j]);
                        out.writeDouble(this.XYdistanceMatrix[i][j]);
                    }
                    ++j;
                }
                out.writeDouble(this.minimalDistances2[i]);
            }
            ++i;
        }
        out.writeDouble(this.overalMinimalDistance2);
    }

    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.positions = new EntitiesPositionInfo();
        this.positions.readExternal(in);
        short[] visioId = this.positions.visioId;
        int size = visioId.length;
        this.distanceMatrix = new double[size][size];
        this.XYdistanceMatrix = new double[size][size];
        this.minimalDistances2 = new double[size];
        int i = 0;
        while (i < size) {
            if (visioId[i] >= 0) {
                int j = 0;
                while (j < size) {
                    if (visioId[j] >= 0) {
                        this.distanceMatrix[i][j] = in.readDouble();
                        this.XYdistanceMatrix[i][j] = in.readDouble();
                    }
                    ++j;
                }
                this.minimalDistances2[i] = in.readDouble();
            }
            ++i;
        }
        this.overalMinimalDistance2 = in.readDouble();
    }
}

