/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.entitysimulator;

import aglobe.platform.thread.AglobeThreadPool;
import aglobex.simulation.entitysimulator.EntitySimulatorAgent;

public class EntitySimulatorThread
implements Runnable {
    private final EntitySimulatorAgent owner;
    private long minimal_wait;
    private long updateInterval;
    private long simulationTimeStamp;
    private double speed = 1.0;
    private boolean paused = false;
    private Thread entitySimulatorThread;
    private boolean finish = false;
    private boolean suspended = false;
    private boolean initialized = false;
    private boolean simulationPlanPhase = false;
    private long trueTime;

    EntitySimulatorThread(EntitySimulatorAgent owner) {
        this.owner = owner;
        this.entitySimulatorThread = AglobeThreadPool.getThread(this, "Entity simulator thread");
        this.entitySimulatorThread.start();
    }

    synchronized void configurationChanged() {
        while (!this.suspended && !this.initialized) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.updateInterval = this.owner.configuration.getSimulationCyclePeriod();
        this.minimal_wait = 0L;
        if (!this.initialized) {
            this.initialized = true;
            this.resumeThread();
        }
    }

    public int getSpeedCode() {
        return (int)Math.round(4096.0 * this.speed);
    }

    public synchronized void setSpeedCode(int speed) {
        this.speed = (double)speed / 4096.0;
    }

    public synchronized void setPaused(boolean paused) {
        this.paused = paused;
        if (!paused) {
            this.trueTime = System.currentTimeMillis();
        }
    }

    synchronized void dispose() {
        this.finish = true;
        this.resumeThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.suspendThread();
        this.simulationTimeStamp = 0L;
        this.trueTime = System.currentTimeMillis();
        while (!this.finish) {
            EntitySimulatorThread entitySimulatorThread;
            if (!this.paused) {
                long waitInterval;
                double cpySpeed;
                long cpyUpdateInterval;
                boolean cpySimulationPlanPhase;
                entitySimulatorThread = this;
                synchronized (entitySimulatorThread) {
                    cpySimulationPlanPhase = this.simulationPlanPhase;
                    cpyUpdateInterval = this.updateInterval;
                    cpySpeed = this.speed;
                }
                if (!cpySimulationPlanPhase) {
                    this.simulationTimeStamp = (long)((double)this.simulationTimeStamp + (double)cpyUpdateInterval * cpySpeed);
                    if (cpySpeed > 0.0) {
                        this.owner.updatePositions(this.simulationTimeStamp);
                    }
                    Thread.yield();
                    waitInterval = this.trueTime + cpyUpdateInterval - System.currentTimeMillis();
                    this.trueTime += cpyUpdateInterval;
                    long trueWaitInterval = Math.max(waitInterval, this.minimal_wait);
                    if (trueWaitInterval <= 0L) continue;
                    try {
                        entitySimulatorThread = this;
                        synchronized (entitySimulatorThread) {
                            this.wait(trueWaitInterval);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.simulationTimeStamp += cpyUpdateInterval;
                long a = System.nanoTime();
                Thread.yield();
                this.owner.updatePositions(this.simulationTimeStamp);
                Thread.yield();
                waitInterval = (System.nanoTime() - a) / 2L;
                int nanos = (int)(waitInterval % 1000000L);
                if ((waitInterval /= 1000000L) > 0L || nanos > 0) {
                    try {
                        entitySimulatorThread = this;
                        synchronized (entitySimulatorThread) {
                            this.wait(waitInterval, nanos);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    entitySimulatorThread = this;
                    synchronized (entitySimulatorThread) {
                        this.wait(waitInterval, 10000);
                    }
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                entitySimulatorThread = this;
                synchronized (entitySimulatorThread) {
                    this.wait(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    synchronized void suspendThread() {
        this.suspended = true;
        while (this.suspended && !this.finish) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    synchronized void resumeThread() {
        this.suspended = false;
        this.notify();
    }

    synchronized void swithSimulationPlanPhase(boolean on) {
        this.simulationPlanPhase = on;
        if (this.simulationPlanPhase) {
            this.entitySimulatorThread.setPriority(1);
        } else {
            this.entitySimulatorThread.setPriority(5);
            this.trueTime = System.currentTimeMillis();
        }
    }
}

