/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.entitysimulator;

import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobe.service.gis.server.GISTopicServerListenerWithoutLogin;
import aglobe.visio3D.PlanUpdate;
import aglobex.simulation.entitysimulator.ControlLink;
import aglobex.simulation.entitysimulator.EntityBehaviour;
import aglobex.simulation.entitysimulator.EntitySimulatorGUI;
import aglobex.simulation.entitysimulator.EntitySimulatorThread;
import aglobex.simulation.entitysimulator.EntityState;
import aglobex.simulation.global.EntitiesPositionInfo;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.Configuration;
import aglobex.simulation.utils.Tables;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.SwingUtilities;

public class EntitySimulatorAgent
extends Agent
implements GISTopicServerListener {
    GISServerService.Shell gisShell;
    private EntitySimulatorGUI gui;
    Configuration configuration;
    private int detailedFlightPlanSubscribers = 0;
    EntitySimulatorThread updateThread;
    private EntitiesPositionInfo[] entPosInfo;
    private EntitiesPositionInfo lastPosInfo;
    private int entPosSize = 10;
    private int entPosFrame = 0;
    private LinkedHashMap<String, EntityBehaviour> entitiesBehaviours = new LinkedHashMap();
    private HashMap<String, EntityRecord> loggedEntities = new HashMap();
    private HashMap<String, LinkedHashSet<EntityRecord>> linkedEntities = new HashMap();
    private HashMap<String, EntityBehaviour> commandReceivers = new HashMap();
    private static final int MAX_HISTORY_LENGTH = 10;
    private HashMap<String, LinkedList<Object[]>> responseHistory = new HashMap();
    private long lastSimulationTimestamp = 0L;
    private long lastSimulationTimeUpdate1Second = -1L;
    private DataOutputStream crashLogFile;
    private HashMap<String, Integer> sendDetailedFlightPlans = new HashMap();
    private HashSet<String> entityDestroyed = new HashSet();
    private HashSet<String> entityOutOfWorld = new HashSet();
    String[] texts = new String[]{"1/10 x", "1/9 x", "1/8 x", "1/7 x", "1/6 x", "1/5 x", "1/4 x", "1/3 x", "1/2 x", "normal", "2 x", "3 x", "4 x", "5 x", "6 x", "7 x", "8 x", "9 x", "10 x"};
    private int speedCodeBeforePause = 4096;
    private boolean paused = false;
    private HashSet<String> editingPause = new HashSet();
    private boolean fastMode = false;
    private String curTimeInString = "0";

    protected void handleIncomingMessage(Message m) {
        this.logSevere("Unexpected incoming message: " + m);
        m.release();
    }

    public void init(AgentInfo ai, int initState) {
        this.setThreadPersistency(true);
        Thread.currentThread().setPriority(Math.min(6, 10));
        this.gisShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        if (this.gisShell == null) {
            this.logSevere("Agent can run only on the server conatiner.");
            this.stop();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        EntitySimulatorAgent.this.gui = new EntitySimulatorGUI(EntitySimulatorAgent.this);
                    }
                    catch (Exception ex) {
                        EntitySimulatorAgent.this.logWarning("Cannot create GUI due to: " + ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Tables.initTables(3600, 3600);
        try {
            this.crashLogFile = new DataOutputStream(new FileOutputStream(new File("crash.log")));
            this.logCrashMsg("============================================\nCrash logger started:\n");
        }
        catch (IOException ex) {
            this.logSevere("Cannot open crash.log file for writing: " + ex.toString());
        }
        this.updateThread = new EntitySimulatorThread(this);
        this.configuration = null;
        this.gisShell.subscribeTopic("CONFIGURATION", this);
        this.gisShell.subscribeTopic("ENTITY_CONTROL", this);
        this.gisShell.subscribeTopic("ENTITY_LOGGED", this);
        this.gisShell.subscribeTopic("ENTITY_LOGOUT", this);
        this.gisShell.subscribeTopic("ENTITY_CRASH", this);
        this.gisShell.subscribeTopic("VISIO_SEND_FLIGHT_PLAN_START", this);
        this.gisShell.subscribeTopic("VISIO_SEND_FLIGHT_PLAN_STOP", this);
        this.gisShell.subscribeTopic("VISIO_RESEND_FLIGHT_PLAN", this);
        this.gisShell.subscribeTopic("VISIO_SET_SIMULATION_SPEED", this);
        this.gisShell.subscribeTopic("SET_SIMULATION_SPEED", this);
        this.gisShell.subscribeTopic("VISIO_RESET_SIMULATION_SPEED_REQUEST", this);
        this.gisShell.subscribeTopic("FAST_SIMULATION_PHASE", this);
        this.gisShell.subscribeTopic("FLIGHT_PLAN_UPDATE", this);
        this.gisShell.subscribeTopic("ENTITY_CREATION_PAUSE_SIMULATION", this);
        this.gisShell.subscribeTopic("EDITING_PAUSE", this);
        this.gisShell.subscribeTopic("SIMULATION_TIME_UPDATE_REQUEST", this);
        this.gisShell.subscribeTopic("POSITION_UPDATE_REQUEST", this);
        if (this.crashLogFile != null) {
            this.gisShell.subscribeTopic("SIMULATION_STARTED", new GISTopicServerListenerWithoutLogin(){

                public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                    boolean started = Boolean.parseBoolean((String)content);
                    if (EntitySimulatorAgent.this.crashLogFile != null) {
                        try {
                            if (started) {
                                EntitySimulatorAgent.this.crashLogFile.writeBytes("============ SIMULATION STARTED ============\n");
                            } else {
                                EntitySimulatorAgent.this.crashLogFile.writeBytes("============ SIMULATION FINISHED ===========\n");
                            }
                            EntitySimulatorAgent.this.crashLogFile.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }

                public void addEvent(Runnable e) {
                    EntitySimulatorAgent.this.addEvent(e);
                }
            });
        }
        this.gisShell.sendTopicToLocal("CONFIGURATION_REQUEST", null, this.getName());
    }

    private void logCrashMsg(String msg) {
        if (this.crashLogFile != null) {
            try {
                this.crashLogFile.writeBytes(String.valueOf(msg) + "\n");
                this.crashLogFile.flush();
            }
            catch (IOException ex) {
                this.logSevere("Problem during writing to the log: " + ex.toString());
            }
        }
    }

    private void destroyEntity(String entityName) {
        this.gisShell.sendTopicToLocal("DESTROY_ENTITY", entityName);
    }

    private void distributePlanUpdate(String entityName, EntityBehaviour entityBehaviour, boolean removeOld) {
        PlanUpdate pu;
        boolean needsDetailed = this.sendDetailedFlightPlans.containsKey(entityName);
        if ((needsDetailed || this.detailedFlightPlanSubscribers > 0) && (pu = entityBehaviour.getPlanUpdate(removeOld)) != null) {
            if (needsDetailed) {
                this.gisShell.sendTopicToLocal("VISIO_FLIGHT_PLAN_UPDATE", pu);
            }
            if (this.detailedFlightPlanSubscribers > 0) {
                this.gisShell.sendTopicToLocal("FLIGHT_PLAN_UPDATE", pu);
            }
        }
    }

    public synchronized void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
        if (topic.equals("FLIGHT_PLAN_UPDATE") && remoteContainerName == null) {
            ++this.detailedFlightPlanSubscribers;
            return;
        }
        if (topic.equals("ENTITY_CONTROL") && remoteContainerName != null) {
            EntityRecord er = this.loggedEntities.get(remoteContainerName);
            if (er != null) {
                LinkedList<Object[]> history;
                String behaviour = er.containerName;
                if (er.linkedToContainerName != null) {
                    behaviour = er.linkedToContainerName;
                }
                if ((history = this.responseHistory.get(behaviour)) != null) {
                    for (Object[] elem : history) {
                        this.gisShell.sendTopic(remoteContainerName, "ENTITY_CONTROL", elem[0], (String)elem[1]);
                    }
                }
            }
            return;
        }
    }

    public synchronized void handleLogoutTopic(String topic, String remoteContainerName) {
        if (topic.equals("FLIGHT_PLAN_UPDATE") && remoteContainerName == null) {
            --this.detailedFlightPlanSubscribers;
            return;
        }
    }

    public synchronized void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equals("SIMULATION_TIME_UPDATE_REQUEST")) {
            this.gisShell.broadcastTopic("SIMULATION_TIME_UPDATE", this.curTimeInString);
            return;
        }
        if (topic.equals("FLIGHT_PLAN_UPDATE")) {
            return;
        }
        if (topic.equals("ENTITY_CONTROL") && remoteContainerName != null) {
            EntityBehaviour eb = this.commandReceivers.get(remoteContainerName);
            if (eb != null) {
                eb.control(content, reason);
            } else {
                this.logSevere("No such entity is logged: " + remoteContainerName);
            }
            return;
        }
        if (topic.equals("ENTITY_LOGGED") && remoteContainerName == null) {
            boolean updated;
            block64: {
                final EntityRecord er = (EntityRecord)content;
                this.loggedEntities.put(er.containerName, er);
                updated = false;
                int newPosFrame = (this.entPosFrame + 1) % this.entPosSize;
                int slots = this.entPosInfo[newPosFrame].visioId.length;
                this.entPosInfo[newPosFrame].simulationTimestamp = this.entPosInfo[this.entPosFrame].simulationTimestamp;
                System.arraycopy(this.entPosInfo[this.entPosFrame].pitch, 0, this.entPosInfo[newPosFrame].pitch, 0, slots);
                System.arraycopy(this.entPosInfo[this.entPosFrame].roll, 0, this.entPosInfo[newPosFrame].roll, 0, slots);
                System.arraycopy(this.entPosInfo[this.entPosFrame].yaw, 0, this.entPosInfo[newPosFrame].yaw, 0, slots);
                System.arraycopy(this.entPosInfo[this.entPosFrame].x, 0, this.entPosInfo[newPosFrame].x, 0, slots);
                System.arraycopy(this.entPosInfo[this.entPosFrame].y, 0, this.entPosInfo[newPosFrame].y, 0, slots);
                System.arraycopy(this.entPosInfo[this.entPosFrame].z, 0, this.entPosInfo[newPosFrame].z, 0, slots);
                System.arraycopy(this.entPosInfo[this.entPosFrame].visioId, 0, this.entPosInfo[newPosFrame].visioId, 0, slots);
                int i = 0;
                while (i < slots) {
                    System.arraycopy(this.entPosInfo[this.entPosFrame].userState[i], 0, this.entPosInfo[newPosFrame].userState[i], 0, this.entPosInfo[this.entPosFrame].userState[i].length);
                    ++i;
                }
                this.entPosFrame = newPosFrame;
                if (er.linkedToContainerName == null) {
                    try {
                        final EntityBehaviour behaviour = (EntityBehaviour)this.getClassLoader().loadClass(er.entityDescriptor.typeDescriptor.simulationClass).newInstance();
                        this.entitiesBehaviours.put(er.containerName, behaviour);
                        this.commandReceivers.put(er.containerName, behaviour);
                        LinkedHashSet<EntityRecord> linkedWith = this.linkedEntities.get(er.containerName);
                        if (linkedWith != null) {
                            for (EntityRecord elem : linkedWith) {
                                this.commandReceivers.put(elem.containerName, behaviour);
                            }
                        }
                        behaviour.init(new ControlLink(){

                            public GISServerService.Shell getGISShell() {
                                return (GISServerService.Shell)EntitySimulatorAgent.this.getContainer().getServiceManager().getService(EntitySimulatorAgent.this, "gis/master");
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void sendControlResponse(Object content, String reason) {
                                EntitySimulatorAgent entitySimulatorAgent = EntitySimulatorAgent.this;
                                synchronized (entitySimulatorAgent) {
                                    LinkedList<Object[]> history;
                                    EntitySimulatorAgent.this.gisShell.sendTopic(er.containerName, "ENTITY_CONTROL", content, reason);
                                    LinkedHashSet linkedWith = (LinkedHashSet)EntitySimulatorAgent.this.linkedEntities.get(er.containerName);
                                    if (linkedWith != null) {
                                        for (EntityRecord elem : linkedWith) {
                                            EntitySimulatorAgent.this.gisShell.sendTopic(elem.containerName, "ENTITY_CONTROL", content, reason);
                                        }
                                    }
                                    if ((history = (LinkedList<Object[]>)EntitySimulatorAgent.this.responseHistory.get(er.containerName)) == null) {
                                        history = new LinkedList<Object[]>();
                                        EntitySimulatorAgent.this.responseHistory.put(er.containerName, history);
                                    }
                                    if (history.size() == 10) {
                                        history.removeFirst();
                                    }
                                    history.addLast(new Object[]{content, reason});
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void destroyEntity() {
                                EntitySimulatorAgent entitySimulatorAgent = EntitySimulatorAgent.this;
                                synchronized (entitySimulatorAgent) {
                                    if (!EntitySimulatorAgent.this.entityDestroyed.contains(er.containerName)) {
                                        EntitySimulatorAgent.this.entityDestroyed.add(er.containerName);
                                        EntitySimulatorAgent.this.destroyEntity(er.containerName);
                                    }
                                }
                            }

                            public void redistributePlanUpdate() {
                                EntitySimulatorAgent.this.distributePlanUpdate(er.containerName, behaviour, true);
                            }

                            public void redistributePlanUpdateDifferental() {
                                EntitySimulatorAgent.this.distributePlanUpdate(er.containerName, behaviour, false);
                            }

                            public void addEvent(Runnable event) {
                                EntitySimulatorAgent.this.addEvent(event);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void entityOutOfWorld() {
                                EntitySimulatorAgent entitySimulatorAgent = EntitySimulatorAgent.this;
                                synchronized (entitySimulatorAgent) {
                                    if (!EntitySimulatorAgent.this.entityOutOfWorld.contains(er.containerName)) {
                                        EntitySimulatorAgent.this.entityOutOfWorld.add(er.containerName);
                                        EntitySimulatorAgent.this.gisShell.sendTopicToLocal("ENTITY_OUT_OF_WORLD", er.containerName);
                                    }
                                }
                            }
                        }, er, this.configuration.getWorldDimension());
                        EntityState es = behaviour.updateEntityState(0L, this.lastSimulationTimestamp);
                        if (es == null) break block64;
                        updated = true;
                        int index = er.indexToSlotArray;
                        this.entPosInfo[this.entPosFrame].x[index] = es.position.x;
                        this.entPosInfo[this.entPosFrame].y[index] = es.position.y;
                        this.entPosInfo[this.entPosFrame].z[index] = es.position.z;
                        this.entPosInfo[this.entPosFrame].pitch[index] = es.pitch * 180.0 / Math.PI;
                        this.entPosInfo[this.entPosFrame].roll[index] = es.roll * 180.0 / Math.PI;
                        this.entPosInfo[this.entPosFrame].yaw[index] = es.yaw * 180.0 / Math.PI;
                        this.entPosInfo[this.entPosFrame].visioId[index] = er.visioID;
                        int tmp1 = es.userState.length;
                        int tmp2 = this.entPosInfo[this.entPosFrame].userState[index].length;
                        System.arraycopy(es.userState, 0, this.entPosInfo[this.entPosFrame].userState[index], 0, Math.min(tmp1, tmp2));
                        int i2 = tmp1;
                        while (i2 < tmp2) {
                            this.entPosInfo[this.entPosFrame].userState[index][i2] = Double.NaN;
                            ++i2;
                        }
                        if (linkedWith != null) {
                            for (EntityRecord elem1 : linkedWith) {
                                int index2 = elem1.indexToSlotArray;
                                this.entPosInfo[this.entPosFrame].x[index2] = es.position.x;
                                this.entPosInfo[this.entPosFrame].y[index2] = es.position.y;
                                this.entPosInfo[this.entPosFrame].z[index2] = es.position.z;
                                this.entPosInfo[this.entPosFrame].pitch[index2] = es.pitch * 180.0 / Math.PI;
                                this.entPosInfo[this.entPosFrame].roll[index2] = es.roll * 180.0 / Math.PI;
                                this.entPosInfo[this.entPosFrame].yaw[index2] = es.yaw * 180.0 / Math.PI;
                                this.entPosInfo[this.entPosFrame].visioId[index2] = er.visioID;
                                Arrays.fill(this.entPosInfo[this.entPosFrame].userState[index2], Double.NaN);
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.logWarning("Problem during starting simulation behaviour for entity: " + er.containerName + " due to:\n" + ex.toString());
                        this.destroyEntity(er.containerName);
                    }
                } else {
                    EntityRecord linkedToER;
                    LinkedList<Object[]> history;
                    String linkedTo = er.linkedToContainerName;
                    LinkedHashSet<EntityRecord> linkedWith = this.linkedEntities.get(linkedTo);
                    if (linkedWith == null) {
                        linkedWith = new LinkedHashSet();
                        this.linkedEntities.put(linkedTo, linkedWith);
                    }
                    linkedWith.add(er);
                    EntityBehaviour eb = this.entitiesBehaviours.get(linkedTo);
                    if (eb != null) {
                        this.commandReceivers.put(er.containerName, eb);
                    }
                    if ((history = this.responseHistory.get(linkedTo)) != null) {
                        for (Object[] elem : history) {
                            this.gisShell.sendTopic(er.containerName, "ENTITY_CONTROL", elem[0], (String)elem[1]);
                        }
                    }
                    if ((linkedToER = this.loggedEntities.get(linkedTo)) != null) {
                        updated = true;
                        int index = er.indexToSlotArray;
                        int index2 = linkedToER.indexToSlotArray;
                        this.entPosInfo[this.entPosFrame].x[index] = this.entPosInfo[this.entPosFrame].x[index2];
                        this.entPosInfo[this.entPosFrame].y[index] = this.entPosInfo[this.entPosFrame].y[index2];
                        this.entPosInfo[this.entPosFrame].z[index] = this.entPosInfo[this.entPosFrame].z[index2];
                        this.entPosInfo[this.entPosFrame].pitch[index] = this.entPosInfo[this.entPosFrame].pitch[index2];
                        this.entPosInfo[this.entPosFrame].roll[index] = this.entPosInfo[this.entPosFrame].roll[index2];
                        this.entPosInfo[this.entPosFrame].yaw[index] = this.entPosInfo[this.entPosFrame].yaw[index2];
                        this.entPosInfo[this.entPosFrame].visioId[index] = this.entPosInfo[this.entPosFrame].visioId[index2];
                        Arrays.fill(this.entPosInfo[this.entPosFrame].userState[index], Double.NaN);
                    }
                }
            }
            if (updated) {
                this.gisShell.sendTopicToLocal("POSITION_UPDATE", this.entPosInfo[this.entPosFrame]);
                this.lastPosInfo = this.entPosInfo[this.entPosFrame];
            }
            return;
        }
        if (topic.equals("ENTITY_LOGOUT") && remoteContainerName == null) {
            LinkedHashSet<EntityRecord> linkedWith;
            EntityRecord er = (EntityRecord)content;
            this.entityOutOfWorld.remove(er.containerName);
            this.entityDestroyed.remove(er.containerName);
            EntityBehaviour eb = this.entitiesBehaviours.get(er.containerName);
            if (eb != null) {
                eb.dispose();
                this.entitiesBehaviours.remove(er.containerName);
                this.commandReceivers.remove(er.containerName);
                linkedWith = this.linkedEntities.get(er.containerName);
                if (linkedWith != null) {
                    for (EntityRecord elem : linkedWith) {
                        this.commandReceivers.remove(elem.containerName);
                    }
                }
                this.responseHistory.remove(er.containerName);
            }
            if (er.linkedToContainerName != null && (linkedWith = this.linkedEntities.get(er.linkedToContainerName)) != null) {
                linkedWith.remove(er);
                if (linkedWith.size() == 0) {
                    this.linkedEntities.remove(er.linkedToContainerName);
                }
            }
            this.loggedEntities.remove(er.containerName);
            this.sendDetailedFlightPlans.remove(er.containerName);
            return;
        }
        if (topic.equals("ENTITY_CRASH") && remoteContainerName == null) {
            if (((String)content).compareTo(reason) > 0) {
                return;
            }
            this.logCrashMsg("Entity " + content + " has crashed with " + reason);
            EntityRecord er1 = this.loggedEntities.get(content);
            EntityRecord er2 = this.loggedEntities.get(reason);
            EntityBehaviour eb1 = this.entitiesBehaviours.get(content);
            EntityBehaviour eb2 = this.entitiesBehaviours.get(reason);
            if (eb1 != null) {
                eb1.entityCrashed(eb2, this.lastSimulationTimestamp);
            }
            if (eb2 != null) {
                eb2.entityCrashed(eb1, this.lastSimulationTimestamp);
            }
            return;
        }
        if (topic.equals("VISIO_SEND_FLIGHT_PLAN_START") && remoteContainerName == null) {
            String entityName = (String)content;
            EntityBehaviour behaviour = this.entitiesBehaviours.get(entityName);
            if (behaviour == null) {
                this.logSevere("Non existing entity: " + content);
                return;
            }
            int s = 1;
            Integer subsribers = this.sendDetailedFlightPlans.get(entityName);
            if (subsribers != null) {
                s = subsribers;
                ++s;
            }
            this.sendDetailedFlightPlans.put(entityName, s);
            this.distributePlanUpdate(entityName, behaviour, true);
            return;
        }
        if (topic.equals("VISIO_SEND_FLIGHT_PLAN_STOP") && remoteContainerName == null) {
            String entityName = (String)content;
            Integer subscribers = this.sendDetailedFlightPlans.get(entityName);
            if (subscribers != null) {
                int s = subscribers;
                if (--s == 0) {
                    this.sendDetailedFlightPlans.remove(entityName);
                } else {
                    this.sendDetailedFlightPlans.put(entityName, s);
                }
            }
            return;
        }
        if (topic.equals("VISIO_SET_SIMULATION_SPEED") && remoteContainerName == null || topic.equals("SET_SIMULATION_SPEED")) {
            int speed = 4096;
            try {
                speed = Integer.parseInt((String)content);
            }
            catch (NumberFormatException subscribers) {
                // empty catch block
            }
            this.updateThread.setSpeedCode(speed);
            this.updateGUI();
            String speedString = Integer.toString(this.updateThread.getSpeedCode());
            this.gisShell.sendTopicToLocal("VISIO_RESET_SIMULATION_SPEED", speedString);
            this.gisShell.broadcastTopic("SIMULATION_SPEED_CHANGED", speedString);
            return;
        }
        if (topic.equals("ENTITY_CREATION_PAUSE_SIMULATION") && remoteContainerName == null) {
            try {
                boolean pause;
                this.paused = pause = Boolean.valueOf((String)content).booleanValue();
                this.updateThread.setPaused(pause || !this.editingPause.isEmpty());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (pause) {
                            if (EntitySimulatorAgent.this.editingPause.isEmpty()) {
                                ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.currentTime.setText("Waiting for entities");
                                ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.pauseButton.setEnabled(false);
                                ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.jSlider1.setEnabled(false);
                            }
                        } else if (EntitySimulatorAgent.this.editingPause.isEmpty() && !EntitySimulatorAgent.this.fastMode) {
                            EntitySimulatorAgent.this.updateGUI();
                        }
                    }
                });
            }
            catch (Exception pause) {
                // empty catch block
            }
            return;
        }
        if (topic.equals("EDITING_PAUSE") && remoteContainerName == null) {
            try {
                boolean oldState;
                final boolean pause = Boolean.valueOf((String)content);
                boolean bl = oldState = !this.editingPause.isEmpty();
                if (pause) {
                    this.editingPause.add(reason);
                } else {
                    this.editingPause.remove(reason);
                }
                boolean newState = !this.editingPause.isEmpty();
                this.updateThread.setPaused(this.paused || newState);
                if (oldState != newState) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (pause) {
                                ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.currentTime.setText("Edit pause");
                                ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.pauseButton.setEnabled(false);
                                ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.jSlider1.setEnabled(false);
                            } else if (!EntitySimulatorAgent.this.paused) {
                                if (!EntitySimulatorAgent.this.fastMode) {
                                    EntitySimulatorAgent.this.updateGUI();
                                }
                            } else {
                                ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.currentTime.setText("Waiting for entities");
                            }
                        }
                    });
                }
            }
            catch (Exception pause) {
                // empty catch block
            }
            return;
        }
        if (topic.equals("VISIO_RESEND_FLIGHT_PLAN") && remoteContainerName == null) {
            String entityName = (String)content;
            EntityBehaviour behaviour = this.entitiesBehaviours.get(entityName);
            if (behaviour == null) {
                this.logSevere("Non existing entity: " + content);
                return;
            }
            if (!this.sendDetailedFlightPlans.containsKey(entityName)) {
                this.logSevere("Resend request for entities with disabled plan details: " + content);
                return;
            }
            this.distributePlanUpdate(entityName, behaviour, true);
            return;
        }
        if (topic.equals("CONFIGURATION")) {
            if (this.getName().equals(reason)) {
                this.configuration = (Configuration)content;
                int slots = this.configuration.getMaxEntities();
                int numberOfUserStateValues = this.configuration.getNumOfUserStateValues();
                if (this.entPosInfo == null) {
                    this.entPosInfo = new EntitiesPositionInfo[this.entPosSize];
                    int i = 0;
                    while (i < this.entPosSize) {
                        this.entPosInfo[i] = new EntitiesPositionInfo(slots, numberOfUserStateValues);
                        ++i;
                    }
                } else if (slots != this.entPosInfo[0].x.length) {
                    int i = 0;
                    while (i < this.entPosInfo.length) {
                        this.entPosInfo[i].changeNumberOfSlots(slots, this.configuration.getNumOfUserStateValues());
                        ++i;
                    }
                }
                this.paused = false;
                this.editingPause.clear();
                this.updateThread.configurationChanged();
            }
            return;
        }
        if (topic.equals("VISIO_RESET_SIMULATION_SPEED_REQUEST")) {
            String speedString = Short.toString((short)this.updateThread.getSpeedCode());
            this.gisShell.sendTopicToLocal("VISIO_RESET_SIMULATION_SPEED", speedString);
            this.gisShell.broadcastTopic("SIMULATION_SPEED_CHANGED", speedString);
            return;
        }
        if (topic.equals("FAST_SIMULATION_PHASE") && remoteContainerName == null) {
            boolean on = Boolean.parseBoolean((String)content);
            this.updateThread.swithSimulationPlanPhase(on);
            this.switchSimulationPhase(on);
            return;
        }
        if (topic.equals("POSITION_UPDATE_REQUEST")) {
            this.gisShell.sendTopicToLocal("POSITION_UPDATE", this.lastPosInfo);
            return;
        }
        this.logSevere("Unexpected incoming topic: " + topic);
    }

    synchronized void updatePositions(long currentClock) {
        if (this.paused || !this.editingPause.isEmpty()) {
            return;
        }
        this.entPosFrame = (this.entPosFrame + 1) % this.entPosSize;
        this.entPosInfo[this.entPosFrame].clear();
        this.entPosInfo[this.entPosFrame].simulationTimestamp = currentClock;
        for (Map.Entry<String, EntityBehaviour> elem : this.entitiesBehaviours.entrySet()) {
            EntityState es;
            EntityRecord er = this.loggedEntities.get(elem.getKey());
            if (er == null || (es = elem.getValue().updateEntityState(currentClock - this.lastSimulationTimestamp, currentClock)) == null) continue;
            int index = er.indexToSlotArray;
            this.entPosInfo[this.entPosFrame].x[index] = es.position.x;
            this.entPosInfo[this.entPosFrame].y[index] = es.position.y;
            this.entPosInfo[this.entPosFrame].z[index] = es.position.z;
            this.entPosInfo[this.entPosFrame].pitch[index] = es.pitch * 180.0 / Math.PI;
            this.entPosInfo[this.entPosFrame].roll[index] = es.roll * 180.0 / Math.PI;
            this.entPosInfo[this.entPosFrame].yaw[index] = es.yaw * 180.0 / Math.PI;
            this.entPosInfo[this.entPosFrame].visioId[index] = er.visioID;
            int tmp1 = es.userState.length;
            int tmp2 = this.entPosInfo[this.entPosFrame].userState[index].length;
            System.arraycopy(es.userState, 0, this.entPosInfo[this.entPosFrame].userState[index], 0, Math.min(tmp1, tmp2));
            int i = tmp1;
            while (i < tmp2) {
                this.entPosInfo[this.entPosFrame].userState[index][i] = Double.NaN;
                ++i;
            }
            LinkedHashSet<EntityRecord> linkedWith = this.linkedEntities.get(er.containerName);
            if (linkedWith == null) continue;
            for (EntityRecord elem1 : linkedWith) {
                int index2 = elem1.indexToSlotArray;
                this.entPosInfo[this.entPosFrame].x[index2] = es.position.x;
                this.entPosInfo[this.entPosFrame].y[index2] = es.position.y;
                this.entPosInfo[this.entPosFrame].z[index2] = es.position.z;
                this.entPosInfo[this.entPosFrame].pitch[index2] = es.pitch * 180.0 / Math.PI;
                this.entPosInfo[this.entPosFrame].roll[index2] = es.roll * 180.0 / Math.PI;
                this.entPosInfo[this.entPosFrame].yaw[index2] = es.yaw * 180.0 / Math.PI;
                this.entPosInfo[this.entPosFrame].visioId[index2] = er.visioID;
                Arrays.fill(this.entPosInfo[this.entPosFrame].userState[index2], Double.NaN);
            }
        }
        this.lastSimulationTimestamp = currentClock;
        this.gisShell.sendTopicToLocal("POSITION_UPDATE", this.entPosInfo[this.entPosFrame]);
        this.lastPosInfo = this.entPosInfo[this.entPosFrame];
        final long curSeconds = currentClock / 1000L;
        this.curTimeInString = Long.toString(currentClock);
        this.gisShell.broadcastTopic("SIMULATION_TIME_UPDATE", this.curTimeInString);
        if (this.lastSimulationTimeUpdate1Second != curSeconds) {
            this.lastSimulationTimeUpdate1Second = curSeconds;
            this.gisShell.broadcastTopic("SIMULATION_TIME_UPDATE_1_SECOND", this.curTimeInString);
            if (this.gui != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.currentTime.setText(String.valueOf(curSeconds) + " s");
                    }
                });
            }
        }
    }

    protected void finish() {
        this.updateThread.dispose();
        if (this.gui != null) {
            this.gui.dispose();
            this.gui = null;
        }
        if (this.crashLogFile != null) {
            try {
                this.crashLogFile.flush();
                this.crashLogFile.close();
                this.crashLogFile = null;
            }
            catch (IOException ex) {
                this.logSevere(ex.toString());
            }
        }
    }

    void sliderUpdated(int position) {
        double toSpeed = 4096.0;
        if (position > 9) {
            toSpeed *= (double)(position - 8);
        } else if (position < 9) {
            toSpeed /= (double)(10 - position);
        }
        if ((int)toSpeed != this.updateThread.getSpeedCode()) {
            this.updateThread.setSpeedCode((int)toSpeed);
            this.updateGUI();
            String speedString = Integer.toString(this.updateThread.getSpeedCode());
            this.gisShell.sendTopicToLocal("VISIO_RESET_SIMULATION_SPEED", speedString);
            this.gisShell.broadcastTopic("SIMULATION_SPEED_CHANGED", speedString);
        }
    }

    void pause(boolean pause) {
        if (pause) {
            this.speedCodeBeforePause = this.updateThread.getSpeedCode();
            this.updateThread.setSpeedCode(0);
            this.updateGUI();
        } else {
            this.updateThread.setSpeedCode(this.speedCodeBeforePause);
            this.updateGUI();
        }
        String speedString = Integer.toString(this.updateThread.getSpeedCode());
        this.gisShell.sendTopicToLocal("VISIO_RESET_SIMULATION_SPEED", speedString);
        this.gisShell.broadcastTopic("SIMULATION_SPEED_CHANGED", speedString);
    }

    void switchSimulationPhase(boolean on) {
        this.fastMode = on;
        if (on) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.jSlider1.setEnabled(false);
                    ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.pauseButton.setEnabled(false);
                    ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.currentSpeed.setText("Fast simulation");
                }
            });
        } else {
            this.updateGUI();
        }
    }

    void updateGUI() {
        double code = this.updateThread.getSpeedCode();
        int slider = 9;
        if (code != 0.0) {
            if (code > 4096.0) {
                slider = (int)Math.round(code /= 4096.0) + 8;
            } else if (code < 4096.0) {
                code = 4096.0 / code;
                slider = 10 - (int)Math.round(code);
            }
        }
        final int tmp = slider;
        final int tmp2 = this.updateThread.getSpeedCode();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.pauseButton.setEnabled(true);
                if (tmp2 == 0) {
                    ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.currentTime.setText(String.valueOf(EntitySimulatorAgent.this.lastSimulationTimestamp / 1000L) + " s");
                    ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.pauseButton.setText("Start");
                    ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.jSlider1.setEnabled(false);
                    ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.currentSpeed.setText("Paused");
                } else {
                    ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.pauseButton.setText("Pause");
                    ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.jSlider1.setEnabled(true);
                    if (((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.jSlider1.getValue() != tmp) {
                        ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.jSlider1.setValue(tmp);
                    }
                    ((EntitySimulatorAgent)EntitySimulatorAgent.this).gui.currentSpeed.setText(EntitySimulatorAgent.this.texts[tmp]);
                }
            }
        });
    }
}

