/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.entitymanager;

import aglobe.ontology.ContainerStartup;
import aglobe.util.AglobeXMLtools;
import aglobex.simulation.configurator.ConfiguratorTools;
import aglobex.simulation.entitymanager.ScenarioControl;
import aglobex.simulation.entitymanager.ScenarioPlayer;
import aglobex.simulation.global.Constants;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.Agent;
import aglobex.simulation.ontology.ConfFile;
import aglobex.simulation.ontology.ConfObject;
import aglobex.simulation.ontology.Configuration;
import aglobex.simulation.ontology.Entity;
import aglobex.simulation.ontology.EntityParamsTemplate;
import aglobex.simulation.ontology.EntityStartupTemplate;
import aglobex.simulation.ontology.EntityType;
import aglobex.simulation.ontology.Library;
import aglobex.simulation.ontology.Param;
import aglobex.simulation.ontology.Scenario;
import aglobex.simulation.ontology.Service;
import aglobex.simulation.ontology.Variable;
import aglobex.simulation.ontology.VisibilityCategory;
import aglobex.simulation.ontology.entity.EntityTypeDescriptor;
import aglobex.simulation.ontology.flightplan.FlightPlan;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioPlayerMain
implements ScenarioPlayer {
    private static final String CONTAINER_NAME = "%CONTAINER_NAME%";
    private ScenarioControl scenarioControl;
    private Scenario scenario;
    private boolean started = false;
    private boolean replay = false;
    private boolean confFailed = false;
    private long startSimulationTimestamp;
    private Iterator entityIterator;
    private Entity nextEntity;
    private long nextEntityStartSimulationTimestamp;
    private HashMap<String, EntityType> entityTypes = new HashMap();
    private HashMap<String, VisibilityCategory> visibilityCategories = new HashMap();
    private HashMap<String, EntityStartupTemplate> startupTemplates = new HashMap();
    private HashMap<String, EntityParamsTemplate> paramsTemplates = new HashMap();

    private void confFailed(String err) {
        this.scenarioControl.logSevere(err);
        this.confFailed = true;
        if (this.started) {
            this.scenarioControl.endOfScenario(this);
            this.started = false;
        }
    }

    void scenarioUpdated(Configuration newConfiguration, Scenario newScenario) {
        this.confFailed = false;
        this.scenario = newScenario;
        if (this.scenario == null) {
            return;
        }
        this.entityTypes.clear();
        for (EntityType entityType : newConfiguration.getEntityType()) {
            this.entityTypes.put(entityType.getName(), entityType);
        }
        this.visibilityCategories.clear();
        this.visibilityCategories.put(Constants.ALWAYS_VISIBLE.getName(), Constants.ALWAYS_VISIBLE);
        for (VisibilityCategory visibilityCategory : newConfiguration.getVisibilityCategory()) {
            this.visibilityCategories.put(visibilityCategory.getName(), visibilityCategory);
        }
        this.startupTemplates.clear();
        LinkedHashSet<String> libraries = new LinkedHashSet<String>();
        for (EntityStartupTemplate item : this.scenario.getEntityStartupTemplate()) {
            for (Agent agent : item.getAgent()) {
                for (Library library : agent.getLibrary()) {
                    libraries.add(library.getLib());
                }
            }
            for (Service service : item.getService()) {
                for (Library library : service.getLibrary()) {
                    libraries.add(library.getLib());
                }
            }
        }
        Map<String, String> map = ConfiguratorTools.loadLibraries(this.scenarioControl, libraries);
        for (EntityStartupTemplate entityStartupTemplate : this.scenario.getEntityStartupTemplate()) {
            String nlib;
            for (Agent agent : entityStartupTemplate.getAgent()) {
                for (Library item2 : agent.getLibrary()) {
                    nlib = map.get(item2.getLib());
                    if (nlib == null) {
                        this.confFailed("Library for agent: " + agent.getName() + " in Entity Template: " + entityStartupTemplate.getName() + " cannot be loaded.");
                        return;
                    }
                    item2.setLib(nlib);
                }
            }
            for (Service service : entityStartupTemplate.getService()) {
                for (Library item2 : service.getLibrary()) {
                    nlib = map.get(item2.getLib());
                    if (nlib == null) {
                        this.confFailed("Library for service: " + service.getName() + " in Entity Template: " + entityStartupTemplate.getName() + " cannot be loaded.");
                        return;
                    }
                    item2.setLib(nlib);
                }
            }
            this.startupTemplates.put(entityStartupTemplate.getName(), entityStartupTemplate);
        }
        this.paramsTemplates.clear();
        for (EntityParamsTemplate entityParamsTemplate : this.scenario.getEntityParamsTemplate()) {
            this.paramsTemplates.put(entityParamsTemplate.getName(), entityParamsTemplate);
        }
        LinkedHashSet<String> resourcesFiles = new LinkedHashSet<String>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Entity entity : this.scenario.getEntity()) {
            Entity en;
            EntityType entityType = this.entityTypes.get(entity.getEntityTypeName());
            if (entityType == null) {
                this.confFailed("Unknown entity type: " + entity.getEntityTypeName() + " for entity: " + entity.getContainerName());
                return;
            }
            if (!this.visibilityCategories.containsKey(entity.getVisibilityCategoryName())) {
                this.confFailed("Unknown visibility category: " + entity.getVisibilityCategoryName() + " for entity: " + entity.getContainerName());
                return;
            }
            if (!this.startupTemplates.containsKey(entity.getUseEntityStartupTemplateName())) {
                this.confFailed("Unknown entity startup template: " + entity.getUseEntityStartupTemplateName() + " for entity: " + entity.getContainerName());
                return;
            }
            if ((entityType.getSimulationClass() == null || "".equals(entityType.getSimulationClass())) && (entity.getLinkedToEntity() == null || "".equals(entity.getLinkedToEntity()))) {
                this.confFailed("Entity: " + entity.getContainerName() + " is not linked to any other entity and doesn't have simulation class specified in entity type: " + entity.getEntityTypeName());
                return;
            }
            try {
                en = this.specifyEntity(entity);
            }
            catch (Exception ex) {
                this.confFailed(ex.toString());
                return;
            }
            for (Param param : en.getParam()) {
                if (param.getType().equals("Double")) {
                    try {
                        Double.parseDouble(param.getValue());
                    }
                    catch (NumberFormatException ex1) {
                        this.confFailed("Wrong format of double parameter: " + param.getName() + " of entity: " + en.getContainerName());
                    }
                    continue;
                }
                if (param.getType().equals("Integer")) {
                    try {
                        Integer.parseInt(param.getValue());
                    }
                    catch (NumberFormatException ex1) {
                        this.confFailed("Wrong format of integer parameter: " + param.getName() + " of entity: " + en.getContainerName());
                    }
                    continue;
                }
                if (param.getType().equals("Boolean")) {
                    try {
                        Boolean.parseBoolean(param.getValue());
                    }
                    catch (NumberFormatException ex1) {
                        this.confFailed("Wrong format of boolean parameter: " + param.getName() + " of entity: " + en.getContainerName());
                    }
                    continue;
                }
                if (!param.getType().equals("Long")) continue;
                try {
                    Long.parseLong(param.getValue());
                }
                catch (NumberFormatException ex1) {
                    this.confFailed("Wrong format of long parameter: " + param.getName() + " of entity: " + en.getContainerName());
                }
            }
            resourcesFiles.clear();
            for (ConfFile confFile : en.getConfFile()) {
                resourcesFiles.add(confFile.getFilePath());
            }
            if (!ConfiguratorTools.confFilesExists(this.scenarioControl, resourcesFiles)) {
                this.confFailed("Some configuration file for entity: " + en.getContainerName() + " cannot be loaded");
                return;
            }
            linkedHashMap.clear();
            for (ConfObject confObject : en.getConfObject()) {
                linkedHashMap.put(confObject.getFilePath(), confObject.getDefClass());
            }
            if (ConfiguratorTools.confObjectsExists(this.scenarioControl, linkedHashMap)) continue;
            this.confFailed("Some configuration object for entity: " + en.getContainerName() + " cannot be loaded");
            return;
        }
        if (this.started) {
            long cur;
            this.entityIterator = this.scenario.getEntity().iterator();
            long requestedDur = this.nextEntityStartSimulationTimestamp - this.startSimulationTimestamp - 5000L;
            for (cur = 0L; cur < requestedDur; cur += this.nextEntity.getStartTimeDiff()) {
                if (this.entityIterator.hasNext()) {
                    this.nextEntity = (Entity)this.entityIterator.next();
                    continue;
                }
                this.nextEntity = null;
                this.scenarioControl.endOfScenario(this);
                return;
            }
            this.nextEntityStartSimulationTimestamp = this.startSimulationTimestamp + 5000L + cur;
        }
    }

    private String applyReplace(String text, Entity original) {
        String retVal = text.replaceAll(CONTAINER_NAME, original.getContainerName());
        for (Variable item : original.getVariable()) {
            retVal = retVal.replaceAll(item.getName(), item.getReplaceWith());
        }
        return retVal;
    }

    private Entity specifyEntity(Entity original) throws Exception {
        boolean useTemplate = true;
        EntityParamsTemplate template = null;
        if (original.getUseEntityParamsTemplateName() == null || original.getUseEntityParamsTemplateName().length() == 0) {
            useTemplate = false;
        } else {
            template = this.paramsTemplates.get(original.getUseEntityParamsTemplateName());
            if (template == null) {
                throw new Exception("Cannot find EntityParamTemplate: " + original.getUseEntityParamsTemplateName() + " for entity: " + original.getContainerName());
            }
        }
        Entity retVal = (Entity)AglobeXMLtools.cloneSerializable(original);
        retVal.getVariable().clear();
        for (Param param : retVal.getParam()) {
            param.setValue(this.applyReplace(param.getValue(), original));
        }
        for (ConfFile confFile : retVal.getConfFile()) {
            confFile.setFilePath(this.applyReplace(confFile.getFilePath(), original));
        }
        for (ConfObject confObject : retVal.getConfObject()) {
            confObject.setFilePath(this.applyReplace(confObject.getFilePath(), original));
        }
        if (useTemplate) {
            Iterator<Serializable> iter = template.getParam().iterator();
            while (iter.hasNext()) {
                Param param = (Param)AglobeXMLtools.cloneSerializable((Param)iter.next());
                param.setValue(this.applyReplace(param.getValue(), original));
                retVal.getParam().add(0, param);
            }
            iter = template.getConfFile().iterator();
            while (iter.hasNext()) {
                ConfFile confFile = (ConfFile)AglobeXMLtools.cloneSerializable((ConfFile)iter.next());
                confFile.setFilePath(this.applyReplace(confFile.getFilePath(), original));
                retVal.getConfFile().add(0, confFile);
            }
            iter = template.getConfObject().iterator();
            while (iter.hasNext()) {
                ConfObject confObject = (ConfObject)AglobeXMLtools.cloneSerializable((ConfObject)iter.next());
                confObject.setFilePath(this.applyReplace(confObject.getFilePath(), original));
                retVal.getConfObject().add(0, confObject);
            }
        }
        return retVal;
    }

    private ContainerStartup getContainerStartup(Entity entity) throws Exception {
        EntityStartupTemplate est = this.startupTemplates.get(entity.getUseEntityStartupTemplateName());
        if (est == null) {
            throw new Exception("Cannot find entity startup template: " + entity.getUseEntityStartupTemplateName() + " for entity: " + entity.getContainerName());
        }
        ContainerStartup cs = new ContainerStartup();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        LinkedList<String> libs = new LinkedList<String>();
        for (Agent agent : est.getAgent()) {
            params.clear();
            libs.clear();
            for (Library library : agent.getLibrary()) {
                libs.add(library.getLib());
            }
            for (Param param : agent.getParam()) {
                params.put(param.getName(), this.applyReplace(param.getValue(), entity));
            }
            cs.addAgent(this.applyReplace(agent.getName(), entity), agent.getMainClass(), libs, params);
        }
        for (Service service : est.getService()) {
            libs.clear();
            params.clear();
            for (Library library : service.getLibrary()) {
                libs.add(library.getLib());
            }
            for (Param param : service.getParam()) {
                params.put(param.getName(), this.applyReplace(param.getValue(), entity));
            }
            cs.addService(this.applyReplace(service.getName(), entity), service.getMainClass(), libs);
        }
        return cs;
    }

    private EntityRecord getEntityRecord(Entity entity, long startTime) throws Exception {
        Entity spec = this.specifyEntity(entity);
        EntityType entityType = this.entityTypes.get(entity.getEntityTypeName());
        EntityTypeDescriptor etd = new EntityTypeDescriptor(this.scenarioControl, entityType, this.visibilityCategories.get(entity.getVisibilityCategoryName()));
        LinkedHashMap<String, String> paramsString = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Double> paramsDouble = new LinkedHashMap<String, Double>();
        LinkedHashMap<String, Integer> paramsInteger = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Boolean> paramsBoolean = new LinkedHashMap<String, Boolean>();
        LinkedHashMap<String, Long> paramsLong = new LinkedHashMap<String, Long>();
        for (Param item1 : spec.getParam()) {
            if (item1.getType().equals("String")) {
                paramsString.put(item1.getName(), item1.getValue());
                continue;
            }
            if (item1.getType().equals("Double")) {
                try {
                    paramsDouble.put(item1.getName(), Double.parseDouble(item1.getValue()));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (item1.getType().equals("Integer")) {
                try {
                    paramsInteger.put(item1.getName(), Integer.parseInt(item1.getValue()));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (item1.getType().equals("Boolean")) {
                try {
                    paramsBoolean.put(item1.getName(), Boolean.parseBoolean(item1.getValue()));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!item1.getType().equals("Long")) continue;
            try {
                paramsLong.put(item1.getName(), Long.parseLong(item1.getValue()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        LinkedHashMap<String, InputStream> files = new LinkedHashMap<String, InputStream>();
        if (spec.getConfFile().size() != 0) {
            LinkedHashSet<String> fileToLoad = new LinkedHashSet<String>();
            for (ConfFile item1 : spec.getConfFile()) {
                fileToLoad.add(item1.getFilePath());
            }
            Map<String, InputStream> f = ConfiguratorTools.getConfFiles(this.scenarioControl, fileToLoad);
            for (ConfFile confFile : spec.getConfFile()) {
                InputStream content = f.get(confFile.getFilePath());
                files.put(confFile.getName(), content);
            }
        }
        LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
        if (spec.getConfObject().size() != 0) {
            LinkedHashMap<String, String> objectsToLoad = new LinkedHashMap<String, String>();
            for (ConfObject confObject : spec.getConfObject()) {
                objectsToLoad.put(confObject.getFilePath(), confObject.getDefClass());
            }
            Map<String, Object> o = ConfiguratorTools.getConfObjects(this.scenarioControl, objectsToLoad);
            for (ConfObject item1 : spec.getConfObject()) {
                Object content = o.get(item1.getFilePath());
                objects.put(item1.getName(), content);
            }
        }
        String linkedToContainer = spec.getLinkedToEntity() == null || spec.getLinkedToEntity().length() == 0 ? null : spec.getLinkedToEntity();
        EntityRecord er = new EntityRecord(spec.getContainerName(), linkedToContainer, etd, startTime, paramsString, paramsDouble, paramsInteger, paramsBoolean, paramsLong, files, objects);
        return er;
    }

    @Override
    public void setScenarioControl(ScenarioControl scenarioControl) {
        this.scenarioControl = scenarioControl;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void configurationUpdated(Configuration newConfiguration, HashMap<String, String> paramsString, HashMap<String, Double> paramsDouble, HashMap<String, Integer> paramsInteger, HashMap<String, Boolean> paramsBoolean, HashMap<String, Long> paramsLong, HashMap<String, InputStream> files, HashMap<String, Object> objects) {
    }

    @Override
    public void simulationTimestampUpdated(long time) {
        if (!this.started || this.nextEntity == null) {
            return;
        }
        boolean entityGroup = false;
        while (this.nextEntity != null && this.nextEntityStartSimulationTimestamp - 5000L <= time) {
            FlightPlan replayFP = null;
            if (this.replay) {
                replayFP = this.scenarioControl.getLastKnowFlightPlan(this.nextEntity.getContainerName());
                if (replayFP == null) {
                    this.scenarioControl.logWarning("Cannot find replay information for entity: " + this.nextEntity.getContainerName());
                    this.readNextEntity(this.nextEntityStartSimulationTimestamp);
                    continue;
                }
                replayFP.startTimeStamp = 0L;
            }
            try {
                EntityRecord er = this.getEntityRecord(this.nextEntity, this.nextEntityStartSimulationTimestamp);
                ContainerStartup cs = this.getContainerStartup(this.nextEntity);
                if (this.replay) {
                    er.entityDescriptor.confObjects.put("REPLAY_FLIGHT_PLAN", replayFP);
                }
                this.scenarioControl.crateNewEntity(er, cs);
                entityGroup = true;
            }
            catch (Exception ex) {
                this.scenarioControl.logWarning("Cannot start entity: " + this.nextEntity.getContainerName() + "\ndue to: " + ex.toString());
                this.readNextEntity(this.nextEntityStartSimulationTimestamp);
                continue;
            }
            this.readNextEntity(this.nextEntityStartSimulationTimestamp);
        }
        if (entityGroup) {
            this.scenarioControl.entityGroupCreated();
        }
    }

    @Override
    public void startScenario(long startTime, boolean fastSimulation) {
        if (!this.confFailed) {
            this.started = true;
            this.replay = false;
            this.startSimulationTimestamp = startTime;
            this.entityIterator = this.scenario.getEntity().iterator();
            this.readNextEntity(startTime + 5000L);
        } else {
            this.scenarioControl.endOfScenario(this);
        }
    }

    @Override
    public void startReplay(long startTime) {
        if (!this.confFailed) {
            this.replay = true;
            this.started = true;
            this.startSimulationTimestamp = startTime;
            this.entityIterator = this.scenario.getEntity().iterator();
            this.readNextEntity(startTime + 5000L);
        } else {
            this.scenarioControl.endOfScenario(this);
        }
    }

    @Override
    public void endOfScenario(long endTime) {
        this.started = false;
    }

    private void readNextEntity(long lastEntityStartSimulationTimestamp) {
        if (this.entityIterator.hasNext()) {
            this.nextEntity = (Entity)this.entityIterator.next();
            this.nextEntityStartSimulationTimestamp = lastEntityStartSimulationTimestamp + this.nextEntity.getStartTimeDiff();
        } else {
            this.nextEntity = null;
            this.scenarioControl.endOfScenario(this);
        }
    }
}

