/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.entitymanager;

import aglobe.container.transport.Address;
import aglobex.simulation.entitymanager.EntityManagerAgent;
import aglobex.simulation.entitymanager.PlatformRecord;
import aglobex.simulation.global.EntityRecord;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlatformAdministrator {
    private final EntityManagerAgent owner;
    public final PlatformRecord localServerPlatform;
    private PlatformRecord abstractPlatform = null;
    private boolean useLocalServerPlatform;
    private ArrayList<PlatformRecord> platforms = new ArrayList();
    private HashMap<String, PlatformRecord> platformsByName = new HashMap();
    private HashSet<Address> registredPlatformsByPlatformAddress = new HashSet();
    private AbstractTableModel tableModel;
    private int popUpRow = -1;
    private JPopupMenu localPopupMenu = new JPopupMenu();
    private JMenuItem killPlatform = new JMenuItem("Kill platform with all running entities");

    PlatformAdministrator(final EntityManagerAgent owner) {
        this.owner = owner;
        this.localServerPlatform = new PlatformRecord("Local server platform", Address.getLocalContainerAddress(owner.getContainer()));
        this.platforms.add(this.localServerPlatform);
        this.useLocalServerPlatform = true;
        this.registredPlatformsByPlatformAddress.add(Address.getLocalPlatformAddress());
        this.tableModel = new PlatformTableModel();
        if (owner.gui != null) {
            owner.gui.platformTable.setModel(this.tableModel);
            this.localPopupMenu.add(this.killPlatform);
            this.killPlatform.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent e) {
                    if (PlatformAdministrator.this.popUpRow >= 0) {
                        String name = owner.gui.platformTable.getValueAt(PlatformAdministrator.this.popUpRow, 0).toString();
                        PlatformAdministrator platformAdministrator = PlatformAdministrator.this;
                        synchronized (platformAdministrator) {
                            PlatformRecord pr = (PlatformRecord)PlatformAdministrator.this.platformsByName.get(name);
                            owner.shutdownPlatformContainer(pr);
                        }
                    }
                }
            });
            owner.gui.platformTable.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    this.maybePopUp(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.maybePopUp(e);
                }

                private void maybePopUp(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        PlatformAdministrator.this.popUpRow = owner.gui.platformTable.rowAtPoint(e.getPoint());
                        if (!PlatformAdministrator.this.useLocalServerPlatform && PlatformAdministrator.this.popUpRow >= 0 || PlatformAdministrator.this.popUpRow >= 1) {
                            PlatformAdministrator.this.localPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                }
            });
        }
    }

    Collection<PlatformRecord> getLoggedPlatforms() {
        return this.platforms;
    }

    synchronized boolean isThisPlatformRegistred(Address containerAddress) {
        return this.registredPlatformsByPlatformAddress.contains(containerAddress.derivePlatformAddress());
    }

    synchronized void registerPlatform(String name, Address containerAddress) {
        PlatformRecord pr;
        if (this.useLocalServerPlatform) {
            this.platforms.clear();
            this.useLocalServerPlatform = false;
        }
        if ((pr = this.platformsByName.get(name)) != null) {
            this.owner.logSevere("Previous platform named '" + name + "' at '" + pr.address.getHost() + "' has been replaced");
            pr.address = containerAddress;
        } else {
            pr = new PlatformRecord(name, containerAddress);
            this.platformsByName.put(name, pr);
            this.platforms.add(pr);
        }
        this.registredPlatformsByPlatformAddress.add(containerAddress.derivePlatformAddress());
        this.tableModel.fireTableDataChanged();
    }

    synchronized void deregisterPlatform(String name) {
        PlatformRecord pr = this.platformsByName.get(name);
        if (pr != null) {
            this.platforms.remove(pr);
            this.platformsByName.remove(name);
            if (this.platforms.size() == 0) {
                this.platforms.add(this.localServerPlatform);
                this.useLocalServerPlatform = true;
            }
            this.registredPlatformsByPlatformAddress.remove(pr.address.derivePlatformAddress());
            this.tableModel.fireTableDataChanged();
        }
    }

    Collection<EntityRecord> getRunningEntities(String platformName) {
        PlatformRecord pr = this.platformsByName.get(platformName);
        if (pr != null) {
            return new LinkedList<EntityRecord>(pr.entities);
        }
        return new LinkedList<EntityRecord>();
    }

    PlatformRecord getPlatformWithMinimumEntities() {
        int cm = Integer.MAX_VALUE;
        PlatformRecord pr = null;
        for (PlatformRecord item : this.platforms) {
            if (item.entities.size() >= cm) continue;
            cm = item.entities.size();
            pr = item;
        }
        return pr;
    }

    synchronized PlatformRecord getAbstractPlatform() {
        if (this.abstractPlatform == null) {
            this.abstractPlatform = new PlatformRecord("Abstract platform", Address.getLocalContainerAddress(this.owner.getContainer()));
            this.tableModel.fireTableDataChanged();
        }
        return this.abstractPlatform;
    }

    void updatePlatformTable() {
        this.tableModel.fireTableDataChanged();
    }

    private class PlatformTableModel
    extends AbstractTableModel {
        private static final int COL_NAME = 0;
        private static final int COL_RUNNING_ENTITIES = 1;
        private static final int COL_PLATFORM_ADDRESS = 2;
        private final String[] COLUMNS = new String[]{"Name", "#Entities", "Address"};

        private PlatformTableModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            PlatformAdministrator platformAdministrator = PlatformAdministrator.this;
            synchronized (platformAdministrator) {
                if (PlatformAdministrator.this.abstractPlatform == null) {
                    return PlatformAdministrator.this.platforms.size();
                }
                return PlatformAdministrator.this.platforms.size() + 1;
            }
        }

        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                PlatformAdministrator platformAdministrator = PlatformAdministrator.this;
                synchronized (platformAdministrator) {
                    PlatformRecord pr = PlatformAdministrator.this.abstractPlatform != null && rowIndex == 0 ? PlatformAdministrator.this.abstractPlatform : (PlatformRecord)PlatformAdministrator.this.platforms.get(rowIndex + (PlatformAdministrator.this.abstractPlatform != null ? -1 : 0));
                    switch (columnIndex) {
                        case 0: {
                            return pr.name;
                        }
                        case 1: {
                            return pr.entities.size();
                        }
                        case 2: {
                            return pr.address.derivePlatformAddress().toString();
                        }
                    }
                }
            }
            catch (Exception ex) {
                return "";
            }
            return null;
        }

        public String getColumnName(int columnIndex) {
            return this.COLUMNS[columnIndex];
        }
    }
}

