/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.entitymanager;

import aglobe.util.gui.RememberPositionJFrame;
import aglobex.simulation.entitymanager.EntityManagerAgent;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class EntityManagerGUI
extends RememberPositionJFrame {
    private EntityManagerAgent owner;
    JTable platformTable = new JTable();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenuItem showACMenuItem = new JMenuItem();
    JMenuItem killAllMenuItem = new JMenuItem();
    JSplitPane jSplitPane1 = new JSplitPane();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTable entityTable = new JTable();
    JPanel bottomPanel = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel topPanel = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JLabel freeEntitySlotsLabel = new JLabel();
    JButton startScenario = new JButton();
    JButton startPlanPhase = new JButton();
    JButton replayButton = new JButton();
    JButton resetButton = new JButton();

    public EntityManagerGUI(EntityManagerAgent owner) {
        super(owner);
        this.owner = owner;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setTitle(owner.getName());
    }

    protected void saveWindowSettings() {
        this.store.putInt("gui/divider", this.jSplitPane1.getDividerLocation());
    }

    protected void loadWindowSettings() {
        int divPos = this.jSplitPane1.getDividerLocation();
        this.jSplitPane1.setDividerLocation(this.store.getInt("gui/divider", divPos));
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                int res = JOptionPane.showConfirmDialog(EntityManagerGUI.this, "Are you sure to kill all and exit platform?", "Close All", 0);
                if (res != 0) {
                    return;
                }
                EntityManagerGUI.this.action_killAll();
            }
        });
        this.fileMenu.setToolTipText("");
        this.fileMenu.setText("File");
        this.showACMenuItem.setToolTipText("");
        this.showACMenuItem.setText("Show Agent Container GUI");
        this.killAllMenuItem.setText("Kill ALL and Exit Platform");
        this.killAllMenuItem.setToolTipText("");
        this.setJMenuBar(this.jMenuBar1);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setBottomComponent(this.jScrollPane2);
        this.jSplitPane1.setDividerSize(1);
        this.jSplitPane1.setLeftComponent(null);
        this.jSplitPane1.setRightComponent(null);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        this.bottomPanel.setLayout(this.gridBagLayout2);
        this.topPanel.setLayout(this.gridBagLayout3);
        this.jLabel1.setFont(new Font("Arial", 0, 11));
        this.jLabel1.setText("Free entity slots:");
        this.freeEntitySlotsLabel.setFont(new Font("Arial", 1, 11));
        this.freeEntitySlotsLabel.setText("0");
        this.startScenario.setText("Start Scenario");
        this.startScenario.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerGUI.this.startScenario_actionPerformed(e);
            }
        });
        this.startPlanPhase.setText("Start Plan Phase");
        this.startPlanPhase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerGUI.this.startPlanPhase_actionPerformed(e);
            }
        });
        this.replayButton.setSelectedIcon(null);
        this.replayButton.setText("Start Verification");
        this.replayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerGUI.this.replayButton_actionPerformed(e);
            }
        });
        this.resetButton.setText("Reset");
        this.resetButton.setEnabled(false);
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerGUI.this.resetButton_actionPerformed(e);
            }
        });
        this.jMenuBar1.add(this.fileMenu);
        this.fileMenu.add(this.showACMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.killAllMenuItem);
        this.jSplitPane1.add((Component)this.jScrollPane1, "top");
        this.jSplitPane1.add((Component)this.jScrollPane2, "bottom");
        this.jScrollPane2.getViewport().add(this.entityTable);
        this.jScrollPane1.getViewport().add(this.platformTable);
        this.getContentPane().add((Component)this.bottomPanel, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
        this.getContentPane().add((Component)this.jSplitPane1, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.topPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.topPanel.add((Component)this.freeEntitySlotsLabel, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.topPanel, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.bottomPanel.add((Component)this.startScenario, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.bottomPanel.add((Component)this.startPlanPhase, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.bottomPanel.add((Component)this.replayButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.bottomPanel.add((Component)this.resetButton, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.showACMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerGUI.this.action_showAC();
            }
        });
        this.killAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerGUI.this.action_killAll();
            }
        });
        this.startScenario.setVisible(false);
        this.startPlanPhase.setVisible(false);
        this.replayButton.setVisible(false);
        this.resetButton.setVisible(false);
    }

    private void action_showAC() {
        this.owner.addEvent(new Runnable(){

            public void run() {
                EntityManagerGUI.this.owner.showAC();
            }
        });
    }

    private void action_killAll() {
        this.owner.addEvent(new Runnable(){

            public void run() {
                EntityManagerGUI.this.owner.killAll();
            }
        });
    }

    void setFreeEntitySlots(final long planes) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EntityManagerGUI.this.freeEntitySlotsLabel.setText(Long.toString(planes));
            }
        });
    }

    public void startScenario_actionPerformed(ActionEvent e) {
        this.owner.addEvent(new Runnable(){

            public void run() {
                EntityManagerGUI.this.owner.startScenario();
            }
        });
    }

    public void startPlanPhase_actionPerformed(ActionEvent e) {
        this.owner.addEvent(new Runnable(){

            public void run() {
                EntityManagerGUI.this.owner.startPlanPhase();
            }
        });
    }

    public void replayButton_actionPerformed(ActionEvent e) {
        this.owner.addEvent(new Runnable(){

            public void run() {
                EntityManagerGUI.this.owner.startReplay();
            }
        });
    }

    public void resetButton_actionPerformed(ActionEvent e) {
        this.owner.addEvent(new Runnable(){

            public void run() {
                EntityManagerGUI.this.owner.resetScenario();
            }
        });
    }
}

