/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.entitymanager;

import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Command;
import aglobe.ontology.ContainerStartup;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobe.service.gis.server.GISTopicServerListenerWithoutLogin;
import aglobe.util.AglobeXMLtools;
import aglobe.visio3D.ObjectIndexAllocator;
import aglobex.simulation.configurator.ConfiguratorTools;
import aglobex.simulation.entitymanager.EntityAdministrator;
import aglobex.simulation.entitymanager.EntityManagerGUI;
import aglobex.simulation.entitymanager.PlatformAdministrator;
import aglobex.simulation.entitymanager.PlatformRecord;
import aglobex.simulation.entitymanager.ScenarioControl;
import aglobex.simulation.entitymanager.ScenarioPlayer;
import aglobex.simulation.entitymanager.ScenarioPlayerMain;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.ConfFile;
import aglobex.simulation.ontology.ConfObject;
import aglobex.simulation.ontology.Configuration;
import aglobex.simulation.ontology.Param;
import aglobex.simulation.ontology.Scenario;
import aglobex.simulation.ontology.UserScenario;
import aglobex.simulation.ontology.flightplan.FlightPlan;
import aglobex.simulation.ontology.flightplan.FlightPlanElement;
import aglobex.simulation.ontology.flightplan.StraightFlightPlanElement;
import aglobex.simulation.ontology.flightplan.TurnFlightPlanElement;
import aglobex.simulation.ontology.waypoint.Waypoints;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerAgent
extends Agent
implements GISTopicServerListener,
ScenarioControl {
    private static final String MAIN_SCENARIO = "main_scenario";
    GISServerService.Shell gisShell;
    EntityManagerGUI gui;
    Configuration configuration;
    PlatformAdministrator platformAdministrator;
    EntityAdministrator entityAdministrator;
    long currentSimulationTimestamp;
    LinkedHashMap<String, ScenarioPlayer> scenarioPlayers = new LinkedHashMap();
    HashSet<ScenarioPlayer> runningScenarioPlayers = new HashSet();
    ScenarioPlayerMain mainScenarioPlayer;
    private boolean scenarioStarted = false;
    private boolean replayStarted = false;
    private boolean canBeReplayed = false;
    private boolean fastSimulation = false;
    private long startSimulationTimestamp;
    private long startNanotime;
    private LinkedHashMap<String, FlightPlan> knownFlightPlans = new LinkedHashMap();
    private LinkedHashMap<String, Waypoints> knownWaypointsPlans = new LinkedHashMap();
    boolean visioAgentRunning = false;
    ObjectIndexAllocator objectIndexAllocator = null;
    boolean waitForEntityCreation = true;

    @Override
    protected void handleIncomingMessage(Message m) {
        m.release();
    }

    @Override
    public void init(AgentInfo ai, int initState) {
        this.setThreadPersistency(true);
        Thread.currentThread().setPriority(Math.min(6, 10));
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        EntityManagerAgent.this.gui = new EntityManagerGUI(EntityManagerAgent.this);
                        EntityManagerAgent.this.gui.setVisible(true);
                    }
                    catch (Exception ex) {
                        EntityManagerAgent.this.logWarning("Cannot create GUI due to: " + ex);
                        ex.printStackTrace();
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.gisShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        if (this.gisShell == null) {
            this.logSevere("Agent can run only on the server conatiner.");
            this.stop();
            return;
        }
        this.platformAdministrator = new PlatformAdministrator(this);
        this.entityAdministrator = new EntityAdministrator(this);
        this.gisShell.subscribeTopic("CONFIGURATION", this);
        this.gisShell.subscribeTopic("SIMULATION_TIME_UPDATE", this);
        this.gisShell.subscribeTopic("COMMAND", this);
        this.gisShell.subscribeTopic("ENTITY_CONNECTION", this);
        this.gisShell.subscribeTopic("VISIO_LOGIN_RESPONSE", this);
        this.gisShell.subscribeTopic("DESTROY_ENTITY", this);
        this.gisShell.subscribeTopic("KILL_ALL", this);
        this.gisShell.subscribeTopic("CURRENT_ENTITIES_REQUEST", this);
        this.gisShell.sendTopicToLocal("CONFIGURATION_REQUEST", null, this.getName());
        this.gisShell.subscribeTopic("ENTITY_CONTROL", new GISTopicServerListenerWithoutLogin(){

            public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                if (!EntityManagerAgent.this.replayStarted && content instanceof FlightPlan && remoteContainerName != null) {
                    FlightPlan fpUpdate = (FlightPlan)content;
                    FlightPlan fp = (FlightPlan)EntityManagerAgent.this.knownFlightPlans.get(remoteContainerName);
                    if (fp == null) {
                        EntityManagerAgent.this.knownFlightPlans.put(remoteContainerName, fpUpdate);
                    } else {
                        int updateFrom = fpUpdate.flightPlan.getFirst().elementID - 1;
                        Iterator iter = fp.flightPlan.iterator();
                        while (iter.hasNext()) {
                            FlightPlanElement item = (FlightPlanElement)iter.next();
                            if (item.elementID > updateFrom) {
                                iter.remove();
                                continue;
                            }
                            if (item.elementID != updateFrom || !(fpUpdate.truncateDurationOfPreviousElement > 0.0)) continue;
                            if (item instanceof StraightFlightPlanElement) {
                                ((StraightFlightPlanElement)item).duration = fpUpdate.truncateDurationOfPreviousElement;
                                continue;
                            }
                            if (!(item instanceof TurnFlightPlanElement)) continue;
                            ((TurnFlightPlanElement)item).duration = fpUpdate.truncateDurationOfPreviousElement;
                        }
                        fp.flightPlan.addAll(fpUpdate.flightPlan);
                        fp.planVersion = fpUpdate.planVersion;
                    }
                }
            }

            public void addEvent(Runnable e) {
                EntityManagerAgent.this.addEvent(e);
            }
        });
        this.gisShell.subscribeTopic("CURRENT_FLIGHT_PLANS_REQUEST", new GISTopicServerListenerWithoutLogin(){

            public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                for (Map.Entry elem : EntityManagerAgent.this.knownFlightPlans.entrySet()) {
                    Object[] c = new Object[]{elem.getKey(), elem.getValue()};
                    EntityManagerAgent.this.gisShell.sendTopicToLocal("CURRENT_FLIGHT_PLANS", c, reason);
                }
            }

            public void addEvent(Runnable e) {
                EntityManagerAgent.this.addEvent(e);
            }
        });
        this.gisShell.subscribeTopic("VISIO_WAYPOINTS_UPDATE", new GISTopicServerListenerWithoutLogin(){

            public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                if (!EntityManagerAgent.this.replayStarted && remoteContainerName != null && content instanceof Waypoints) {
                    EntityManagerAgent.this.knownWaypointsPlans.put(remoteContainerName, (Waypoints)content);
                }
            }

            public void addEvent(Runnable e) {
                EntityManagerAgent.this.addEvent(e);
            }
        });
        long autostart = -1L;
        String val = this.getContainer().getProperty("autostart");
        if (val != null) {
            try {
                autostart = Long.valueOf(val);
                if (autostart > 0L) {
                    this.getContainer().TIMER.schedule(new TimerTask(){

                        public void run() {
                            EntityManagerAgent.this.addEvent(new Runnable(){

                                public void run() {
                                    EntityManagerAgent.this.startScenario();
                                }
                            });
                        }
                    }, autostart * 1000L);
                    this.logInfo("Scenario autostart within " + autostart + " second(s).");
                }
            }
            catch (NumberFormatException ex1) {
                this.logWarning("Wrong format of autostart attribute: " + val);
            }
        }
    }

    void showAC() {
        this.gisShell.sendTopicToLocal("COMMAND", this.getShowContainerGUICommand());
    }

    void showPlaneAC(EntityRecord plane) {
        this.gisShell.sendTopic(plane.containerName, "COMMAND", this.getShowContainerGUICommand());
    }

    void killAll() {
        this.canBeReplayed = false;
        this.scenarioStarted = false;
        this.replayStarted = false;
        this.shutdownPlatformContainer(this.platformAdministrator.getLoggedPlatforms());
        this.shutdownEntityContainer(this.entityAdministrator.getLoggedEntities());
        this.entityAdministrator.removeNotLoggedEntities();
        this.entityAdministrator.waitForNoEntity(new Runnable(){

            public void run() {
                if (EntityManagerAgent.this.fastSimulation) {
                    EntityManagerAgent.this.gisShell.sendTopicToLocal("FAST_SIMULATION_PHASE", Boolean.toString(false));
                    EntityManagerAgent.this.fastSimulation = false;
                }
                for (ScenarioPlayer elem : EntityManagerAgent.this.scenarioPlayers.values()) {
                    elem.endOfScenario(EntityManagerAgent.this.currentSimulationTimestamp);
                }
                EntityManagerAgent.this.runningScenarioPlayers.clear();
                EntityManagerAgent.this.knownFlightPlans.clear();
                EntityManagerAgent.this.updateGuiButtons();
                EntityManagerAgent.this.sendVisioReset();
                EntityManagerAgent.this.gisShell.broadcastTopicToClients("COMMAND", EntityManagerAgent.this.getShutdownCommand());
                EntityManagerAgent.this.scheduleEvent(new Runnable(){

                    public void run() {
                        EntityManagerAgent.this.shutdownContainer();
                    }
                }, 2000L);
            }
        });
    }

    private Command getShutdownCommand() {
        Command command = new Command();
        command.setName("QUIT");
        return command;
    }

    private Command getShowContainerGUICommand() {
        Command command = new Command();
        command.setName("GUI");
        command.getAglobeParam().add(AglobeXMLtools.makeAglobeParam("Visible", Boolean.toString(true)));
        return command;
    }

    private void shutdownContainer() {
        this.gisShell.sendTopicToLocal("COMMAND", this.getShutdownCommand());
    }

    void shutdownEntityContainer(EntityRecord plane) {
        Command c = this.getShutdownCommand();
        this.gisShell.sendTopic(plane.containerName, "COMMAND", c);
    }

    private void shutdownEntityContainer(Collection<EntityRecord> planes) {
        Command c = this.getShutdownCommand();
        for (EntityRecord pr : planes) {
            if (this.gisShell.sendTopic(pr.containerName, "COMMAND", c)) continue;
            this.entityAdministrator.entityLogout(pr.containerName);
        }
    }

    void shutdownPlatformContainer(PlatformRecord platform) {
        Command c = this.getShutdownCommand();
        this.gisShell.sendTopic(platform.name, "COMMAND", c);
    }

    private void shutdownPlatformContainer(Collection<PlatformRecord> planes) {
        Command c = this.getShutdownCommand();
        Iterator<PlatformRecord> iter = planes.iterator();
        while (iter.hasNext()) {
            this.gisShell.sendTopic(iter.next().name, "COMMAND", c);
        }
    }

    @Override
    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
        if (topic.equals("COMMAND")) {
            if (remoteContainerName != null && !this.platformAdministrator.isThisPlatformRegistred(remoteContainerAddress)) {
                this.platformAdministrator.registerPlatform(remoteContainerName, remoteContainerAddress);
            }
            return;
        }
        if (topic.equals("ENTITY_CONNECTION") && remoteContainerName != null) {
            this.entityAdministrator.entityLogin(remoteContainerName, remoteContainerAddress);
            return;
        }
    }

    @Override
    public void handleLogoutTopic(String topic, String remoteContainerName) {
        if (topic.equals("COMMAND")) {
            if (remoteContainerName != null) {
                this.platformAdministrator.deregisterPlatform(remoteContainerName);
            }
            return;
        }
        if (topic.equals("ENTITY_CONNECTION") && remoteContainerName != null) {
            this.entityAdministrator.entityLogout(remoteContainerName);
            return;
        }
    }

    @Override
    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equals("SIMULATION_TIME_UPDATE") && remoteContainerName == null) {
            this.currentSimulationTimestamp = Long.parseLong((String)content);
            if (this.scenarioStarted || this.replayStarted) {
                for (ScenarioPlayer elem : this.scenarioPlayers.values()) {
                    elem.simulationTimestampUpdated(this.currentSimulationTimestamp);
                }
            }
            return;
        }
        if (topic.equals("CONFIGURATION")) {
            if (this.getName().equals(reason)) {
                this.configuration = (Configuration)content;
                this.configurationUpdated();
                this.entityAdministrator.configurationUpdated();
            }
            return;
        }
        if (topic.equals("VISIO_LOGIN_RESPONSE") && remoteContainerName == null) {
            this.entityAdministrator.entityCreatedNotification(reason, (Short)content);
            return;
        }
        if (topic.equals("DESTROY_ENTITY") && remoteContainerName == null) {
            this.entityAdministrator.destroyEntity((String)content);
            return;
        }
        if (topic.equals("KILL_ALL") && remoteContainerName == null) {
            this.killAll();
            return;
        }
        if (topic.equals("COMMAND")) {
            return;
        }
        if (topic.equals("CURRENT_ENTITIES_REQUEST")) {
            this.entityAdministrator.distributeAllCreateEntities(reason);
            return;
        }
        this.logSevere("Unexpected incoming topic: " + topic);
    }

    @Override
    public void endOfScenario(ScenarioPlayer scenarioPlayer) {
        this.runningScenarioPlayers.remove(scenarioPlayer);
        if (this.scenarioStarted || this.replayStarted) {
            this.testEndOfScenario();
        }
    }

    void testEndOfScenario() {
        if ((this.scenarioStarted || this.replayStarted) && this.runningScenarioPlayers.size() == 0 && this.entityAdministrator.getRunningEntities() == 0) {
            for (ScenarioPlayer elem : this.scenarioPlayers.values()) {
                elem.endOfScenario(this.currentSimulationTimestamp);
            }
            if (this.scenarioStarted) {
                this.logInfo("Scenario " + (this.fastSimulation ? "plan phase " : "") + "completed. Total simulation time: " + (double)(this.currentSimulationTimestamp - this.startSimulationTimestamp) / 1000.0 + " s time: " + (double)(System.nanoTime() - this.startNanotime) / 1.0E9 + " s.");
            }
            this.scenarioStarted = false;
            this.replayStarted = false;
            this.canBeReplayed = true;
            if (this.fastSimulation) {
                this.gisShell.sendTopicToLocal("FAST_SIMULATION_PHASE", Boolean.toString(false));
                this.fastSimulation = false;
            }
            this.updateGuiButtons();
            this.gisShell.sendTopicToLocal("SIMULATION_STARTED", Boolean.toString(false));
            this.sendOfflinePlanDataToTheVisio();
        }
    }

    @Override
    public GISServerService.Shell getGISShell() {
        return (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
    }

    @Override
    public Agent getOwnerAgent() {
        return this;
    }

    @Override
    public EntityRecord getRunningEntityRecord(String containerName) {
        return this.entityAdministrator.getEntityByContainerName(containerName);
    }

    @Override
    public FlightPlan getLastKnowFlightPlan(String containerName) {
        return this.knownFlightPlans.get(containerName);
    }

    @Override
    public void crateNewEntity(EntityRecord entityRecord, ContainerStartup containerStartupConfiguration) throws Exception {
        this.entityAdministrator.crateNewEntity(entityRecord, containerStartupConfiguration);
    }

    @Override
    public void removeEntity(String entityName) {
        this.entityAdministrator.destroyEntity(entityName);
    }

    @Override
    public void entityGroupCreated() {
        this.entityAdministrator.entityGroupCreated();
    }

    private void configurationUpdated() {
        this.waitForEntityCreation = true;
        for (Param item : this.configuration.getParam()) {
            if (!item.getName().equals("WaitForEntityCreation") || !item.getType().equals("Boolean")) continue;
            try {
                boolean bVal;
                this.waitForEntityCreation = bVal = Boolean.parseBoolean(item.getValue());
            }
            catch (Exception ex2) {
                this.logWarning("Wrong format of global parameter: WaitForEntityCreation");
            }
        }
        String mainScenario = this.configuration.getSimulationScenario().getMainScenario();
        boolean removeMainScenario = true;
        if (mainScenario != null && mainScenario.length() != 0) {
            Scenario scenario = (Scenario)ConfiguratorTools.getConfObject(this, mainScenario, Scenario.class.getName());
            if (scenario == null) {
                this.logSevere("Cannot get main scenario configuration object. There will be no MainScenarioPlayer.");
            } else {
                removeMainScenario = false;
                if (this.mainScenarioPlayer != null) {
                    this.mainScenarioPlayer.scenarioUpdated(this.configuration, scenario);
                } else {
                    this.mainScenarioPlayer = new ScenarioPlayerMain();
                    this.mainScenarioPlayer.setScenarioControl(this);
                    this.mainScenarioPlayer.scenarioUpdated(this.configuration, scenario);
                    this.scenarioPlayers.put(MAIN_SCENARIO, this.mainScenarioPlayer);
                    if (this.scenarioStarted) {
                        this.mainScenarioPlayer.startScenario(this.currentSimulationTimestamp, this.fastSimulation);
                        this.runningScenarioPlayers.add(this.mainScenarioPlayer);
                    }
                    if (this.replayStarted) {
                        this.mainScenarioPlayer.startReplay(this.currentSimulationTimestamp);
                        this.runningScenarioPlayers.add(this.mainScenarioPlayer);
                    }
                }
            }
        }
        if (removeMainScenario && this.mainScenarioPlayer != null) {
            this.scenarioPlayers.remove(MAIN_SCENARIO);
            this.runningScenarioPlayers.remove(this.mainScenarioPlayer);
            this.mainScenarioPlayer.dispose();
            this.mainScenarioPlayer = null;
        }
        LinkedHashSet scenarioPlayersToRemove = new LinkedHashSet(this.scenarioPlayers.keySet());
        scenarioPlayersToRemove.remove(MAIN_SCENARIO);
        HashSet<String> scenarioPlayerNames = new HashSet<String>();
        block13: for (UserScenario item : this.configuration.getSimulationScenario().getUserScenario()) {
            ScenarioPlayer existingScenarioPlayer;
            if (scenarioPlayerNames.contains(item.getName())) {
                this.logSevere("UserScenario already defined in the Configuration file: " + item.getName() + "\nSkipped.");
                continue;
            }
            scenarioPlayerNames.add(item.getName());
            LinkedHashMap<String, String> paramsString = new LinkedHashMap<String, String>();
            LinkedHashMap<String, Double> paramsDouble = new LinkedHashMap<String, Double>();
            LinkedHashMap<String, Integer> paramsInteger = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, Boolean> paramsBoolean = new LinkedHashMap<String, Boolean>();
            LinkedHashMap<String, Long> paramsLong = new LinkedHashMap<String, Long>();
            for (Param item1 : item.getParam()) {
                if (item1.getType().equals("String")) {
                    paramsString.put(item1.getName(), item1.getValue());
                    continue;
                }
                if (item1.getType().equals("Double")) {
                    try {
                        paramsDouble.put(item1.getName(), Double.parseDouble(item1.getValue()));
                        continue;
                    }
                    catch (NumberFormatException ex1) {
                        this.logSevere("Double param: " + item1.getName() + " for UserScenario: " + item.getName() + " contains not double value. Scenario is skipped.");
                        continue block13;
                    }
                }
                if (item1.getType().equals("Integer")) {
                    try {
                        paramsInteger.put(item1.getName(), Integer.parseInt(item1.getValue()));
                        continue;
                    }
                    catch (NumberFormatException ex1) {
                        this.logSevere("Integer param: " + item1.getName() + " for UserScenario: " + item.getName() + " contains not integer value. Scenario is skipped.");
                        continue block13;
                    }
                }
                if (item1.getType().equals("Boolean")) {
                    try {
                        paramsBoolean.put(item1.getName(), Boolean.parseBoolean(item1.getValue()));
                        continue;
                    }
                    catch (NumberFormatException ex1) {
                        this.logSevere("Boolean param: " + item1.getName() + " for UserScenario: " + item.getName() + " contains not boolean value. Scenario is skipped.");
                        continue block13;
                    }
                }
                if (!item1.getType().equals("Long")) continue;
                try {
                    paramsLong.put(item1.getName(), Long.parseLong(item1.getValue()));
                }
                catch (NumberFormatException ex1) {
                    this.logSevere("Long param: " + item1.getName() + " for UserScenario: " + item.getName() + " contains not long value. Scenario is skipped.");
                    continue block13;
                }
            }
            LinkedHashMap<String, InputStream> files = new LinkedHashMap<String, InputStream>();
            if (item.getConfFile().size() != 0) {
                LinkedHashSet<String> fileToLoad = new LinkedHashSet<String>();
                for (ConfFile item1 : item.getConfFile()) {
                    fileToLoad.add(item1.getFilePath());
                }
                Map<String, InputStream> f = ConfiguratorTools.getConfFiles(this, fileToLoad);
                for (ConfFile confFile : item.getConfFile()) {
                    InputStream content = f.get(confFile.getFilePath());
                    if (content == null) {
                        this.logSevere("ConfFile: " + confFile.getFilePath() + " for UserScenario: " + item.getName() + " cannot be loaded. Scenario is skipped.");
                        continue block13;
                    }
                    files.put(confFile.getName(), content);
                }
            }
            LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
            if (item.getConfObject().size() != 0) {
                LinkedHashMap<String, String> objectsToLoad = new LinkedHashMap<String, String>();
                for (ConfObject confObject : item.getConfObject()) {
                    objectsToLoad.put(confObject.getFilePath(), confObject.getDefClass());
                }
                Map<String, Object> o = ConfiguratorTools.getConfObjects(this, objectsToLoad);
                for (ConfObject item1 : item.getConfObject()) {
                    Object content = o.get(item1.getFilePath());
                    if (content == null) {
                        this.logSevere("ConfObject: " + item1.getFilePath() + " for UserScenario: " + item.getName() + " cannot be loaded. Scenario is skipped.");
                        continue block13;
                    }
                    objects.put(item1.getName(), content);
                }
            }
            if ((existingScenarioPlayer = this.scenarioPlayers.get(item.getName())) != null) {
                scenarioPlayersToRemove.remove(item.getName());
                existingScenarioPlayer.configurationUpdated(this.configuration, paramsString, paramsDouble, paramsInteger, paramsBoolean, paramsLong, files, objects);
                continue;
            }
            try {
                ClassLoader cl = this.getClassLoader();
                Class<?> clazz = cl.loadClass(item.getDefClass());
                if (!ScenarioPlayer.class.isAssignableFrom(clazz)) {
                    throw new Exception("Class: " + item.getDefClass() + " is not compatible with ScenarioPlayer interface.");
                }
                existingScenarioPlayer = (ScenarioPlayer)clazz.newInstance();
                existingScenarioPlayer.setScenarioControl(this);
                existingScenarioPlayer.configurationUpdated(this.configuration, paramsString, paramsDouble, paramsInteger, paramsBoolean, paramsLong, files, objects);
                this.scenarioPlayers.put(item.getName(), existingScenarioPlayer);
                if (this.scenarioStarted) {
                    existingScenarioPlayer.startScenario(this.currentSimulationTimestamp, this.fastSimulation);
                    this.runningScenarioPlayers.add(existingScenarioPlayer);
                }
                if (!this.replayStarted) continue;
                existingScenarioPlayer.startReplay(this.currentSimulationTimestamp);
                this.runningScenarioPlayers.add(existingScenarioPlayer);
            }
            catch (Exception ex) {
                this.logSevere("Problem during starting ScenarioPlayer named: " + item.getName() + "\ndue to: " + ex.toString());
                ex.printStackTrace();
            }
        }
        for (String elem : scenarioPlayersToRemove) {
            ScenarioPlayer sp = this.scenarioPlayers.get(elem);
            if (sp != null) {
                this.runningScenarioPlayers.remove(sp);
                sp.dispose();
            }
            this.scenarioPlayers.remove(elem);
        }
        this.testEndOfScenario();
        this.updateGuiButtons();
    }

    private void updateGuiButtons() {
        if (this.gui != null) {
            this.gui.startScenario.setVisible(true);
            this.gui.startScenario.setEnabled(!this.scenarioStarted && !this.replayStarted);
            this.gui.resetButton.setVisible(true);
            this.gui.resetButton.setEnabled(this.scenarioStarted || this.replayStarted);
            this.gui.replayButton.setVisible(this.configuration.isAllowReplay());
            this.gui.replayButton.setEnabled(!this.scenarioStarted && !this.replayStarted && this.canBeReplayed);
            this.gui.startPlanPhase.setVisible(this.configuration.isAllowFastSimulation());
            this.gui.startPlanPhase.setEnabled(!this.scenarioStarted && !this.replayStarted);
        }
    }

    @Override
    protected void finish() {
        if (this.gui != null) {
            this.gui.dispose();
        }
        for (ScenarioPlayer elem : this.scenarioPlayers.values()) {
            elem.dispose();
        }
    }

    private void sendOfflinePlanDataToTheVisio() {
        this.gisShell.clearHistoryCache();
        this.sendVisioReset();
        for (Map.Entry<String, Waypoints> elem : this.knownWaypointsPlans.entrySet()) {
            FlightPlan flightPlan = this.knownFlightPlans.get(elem.getKey());
            this.gisShell.sendTopicToLocal("VISIO_OFFLINE_WAYPOINTS_UPDATE", new Object[]{elem.getValue(), flightPlan});
        }
    }

    @Override
    public void startScenario() {
        if (this.scenarioStarted) {
            return;
        }
        this.testVisioAgent();
        this.gisShell.clearHistoryCache();
        this.knownFlightPlans.clear();
        this.knownWaypointsPlans.clear();
        this.sendVisioReset();
        if (this.scenarioPlayers.size() != 0) {
            this.startSimulationTimestamp = this.currentSimulationTimestamp;
            this.startNanotime = System.nanoTime();
            this.gisShell.sendTopicToLocal("SIMULATION_STARTED", Boolean.toString(true));
            for (ScenarioPlayer elem : this.scenarioPlayers.values()) {
                this.runningScenarioPlayers.add(elem);
                elem.startScenario(this.currentSimulationTimestamp, false);
            }
            this.scenarioStarted = true;
            this.updateGuiButtons();
            this.testEndOfScenario();
        }
    }

    @Override
    public void startPlanPhase() {
        if (this.scenarioStarted) {
            return;
        }
        this.testVisioAgent();
        this.gisShell.clearHistoryCache();
        this.knownFlightPlans.clear();
        this.knownWaypointsPlans.clear();
        this.sendVisioReset();
        if (this.scenarioPlayers.size() != 0) {
            this.startSimulationTimestamp = this.currentSimulationTimestamp;
            this.startNanotime = System.nanoTime();
            this.gisShell.sendTopicToLocal("FAST_SIMULATION_PHASE", Boolean.toString(true));
            this.gisShell.sendTopicToLocal("SIMULATION_STARTED", Boolean.toString(true));
            for (ScenarioPlayer elem : this.scenarioPlayers.values()) {
                this.runningScenarioPlayers.add(elem);
                elem.startScenario(this.currentSimulationTimestamp, true);
            }
            this.scenarioStarted = true;
            this.fastSimulation = true;
            this.updateGuiButtons();
            this.testEndOfScenario();
        }
    }

    @Override
    public void startReplay() {
        if (this.scenarioStarted) {
            return;
        }
        this.testVisioAgent();
        this.gisShell.clearHistoryCache();
        this.sendVisioReset();
        if (this.scenarioPlayers.size() != 0) {
            for (ScenarioPlayer elem : this.scenarioPlayers.values()) {
                this.runningScenarioPlayers.add(elem);
                elem.startReplay(this.currentSimulationTimestamp);
            }
            this.replayStarted = true;
            this.updateGuiButtons();
            this.testEndOfScenario();
        }
    }

    @Override
    public void resetScenario() {
        if (!this.scenarioStarted && !this.replayStarted) {
            return;
        }
        this.canBeReplayed = false;
        this.scenarioStarted = false;
        this.replayStarted = false;
        Collection<EntityRecord> notLoggedEntities = this.entityAdministrator.getNotLoggedEntities();
        this.shutdownEntityContainer(this.entityAdministrator.getLoggedEntities());
        Command c = this.getShutdownCommand();
        for (EntityRecord elem : notLoggedEntities) {
            this.gisShell.sendTopic(elem.containerName, "COMMAND", c);
        }
        this.entityAdministrator.removeNotLoggedEntities();
        this.entityAdministrator.waitForNoEntity(new Runnable(){

            public void run() {
                if (EntityManagerAgent.this.fastSimulation) {
                    EntityManagerAgent.this.gisShell.sendTopicToLocal("FAST_SIMULATION_PHASE", Boolean.toString(false));
                    EntityManagerAgent.this.fastSimulation = false;
                }
                for (ScenarioPlayer elem : EntityManagerAgent.this.scenarioPlayers.values()) {
                    elem.endOfScenario(EntityManagerAgent.this.currentSimulationTimestamp);
                }
                EntityManagerAgent.this.runningScenarioPlayers.clear();
                EntityManagerAgent.this.knownFlightPlans.clear();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        (this).EntityManagerAgent.this.gui.resetButton.setEnabled(false);
                    }
                });
                EntityManagerAgent.this.scheduleEvent(new Runnable(){

                    public void run() {
                        EntityManagerAgent.this.updateGuiButtons();
                    }
                }, 1000L);
                EntityManagerAgent.this.gisShell.sendTopicToLocal("SIMULATION_STARTED", Boolean.toString(false));
                EntityManagerAgent.this.sendVisioReset();
            }
        });
    }

    private void sendVisioReset() {
        this.gisShell.sendTopicToLocal("VISIO_RESET", "");
    }

    private void testVisioAgent() {
        if (this.gisShell.hasSomeSubscriber("VISIO_LOGIN_REQUEST")) {
            this.visioAgentRunning = true;
            this.objectIndexAllocator = null;
        } else {
            this.visioAgentRunning = false;
            this.objectIndexAllocator = new ObjectIndexAllocator((short)this.configuration.getMaxEntities());
        }
    }
}

