/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.entitymanager;

import aglobe.container.transport.Address;
import aglobe.ontology.AgentList;
import aglobe.ontology.AglobeParam;
import aglobe.ontology.Command;
import aglobe.ontology.ContainerStartup;
import aglobe.ontology.ServiceList;
import aglobe.platform.Platform;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListenerWithoutLogin;
import aglobe.util.AglobeXMLtools;
import aglobex.simulation.entitymanager.EntityManagerAgent;
import aglobex.simulation.entitymanager.PlatformRecord;
import aglobex.simulation.global.EntityRecord;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityAdministrator {
    private static final int MAX_ENTITIES_WAITING_FOR_LOGIN = 1;
    private final EntityManagerAgent owner;
    private final ArrayList<EntityRecord> entities = new ArrayList();
    private final HashMap<String, EntityRecord> entitiesByName = new HashMap();
    private EntityRecord[] entitySlotArray;
    private int nextSlot = 0;
    private AbstractTableModel tableModel;
    private int popUpRow = -1;
    private JMenuItem killPlane = new JMenuItem("Kill entity");
    private JMenuItem showPlaneGUI = new JMenuItem("Show entity GUI");
    private String startingAttributes;
    private Runnable waitForNoEntity = null;
    private HashSet<String> notLoggedGroupEntities = null;
    private int waitingForLogin = 0;
    private LinkedList<EntityForStartup> entitiesForStartup = new LinkedList();
    private boolean simulationPaused = false;

    EntityAdministrator(final EntityManagerAgent owner) {
        this.owner = owner;
        this.tableModel = new EntityTableModel();
        if (owner.gui != null) {
            owner.gui.entityTable.setModel(this.tableModel);
            this.showPlaneGUI.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent e) {
                    if (EntityAdministrator.this.popUpRow >= 0) {
                        String name = owner.gui.entityTable.getValueAt(EntityAdministrator.this.popUpRow, 0).toString();
                        EntityAdministrator entityAdministrator = EntityAdministrator.this;
                        synchronized (entityAdministrator) {
                            EntityRecord er = (EntityRecord)EntityAdministrator.this.entitiesByName.get(name);
                            if (er.address != null) {
                                owner.showPlaneAC(er);
                            }
                        }
                    }
                }
            });
            this.killPlane.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent e) {
                    if (EntityAdministrator.this.popUpRow >= 0) {
                        String name = owner.gui.entityTable.getValueAt(EntityAdministrator.this.popUpRow, 0).toString();
                        EntityAdministrator entityAdministrator = EntityAdministrator.this;
                        synchronized (entityAdministrator) {
                            EntityRecord er = (EntityRecord)EntityAdministrator.this.entitiesByName.get(name);
                            if (er.address != null) {
                                owner.shutdownEntityContainer(er);
                            }
                        }
                    }
                }
            });
            owner.gui.entityTable.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    this.maybePopUp(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.maybePopUp(e);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void maybePopUp(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        EntityAdministrator.this.popUpRow = owner.gui.entityTable.rowAtPoint(e.getPoint());
                        if (EntityAdministrator.this.popUpRow >= 0) {
                            EntityRecord er;
                            final JPopupMenu localPopupMenu = new JPopupMenu();
                            localPopupMenu.add(EntityAdministrator.this.showPlaneGUI);
                            localPopupMenu.addSeparator();
                            localPopupMenu.add(EntityAdministrator.this.killPlane);
                            localPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            String name = owner.gui.entityTable.getValueAt(EntityAdministrator.this.popUpRow, 0).toString();
                            EntityAdministrator entityAdministrator = EntityAdministrator.this;
                            synchronized (entityAdministrator) {
                                er = (EntityRecord)EntityAdministrator.this.entitiesByName.get(name);
                            }
                            if (er != null) {
                                final GISServerService.Shell shell = (GISServerService.Shell)owner.getContainer().getServiceManager().getService(owner, "gis/master");
                                Command c = new Command();
                                c.setName("REQUEST_LIST");
                                shell.subscribeTopic("COMMAND_RESPONSE", new GISTopicServerListenerWithoutLogin(){

                                    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                                        if (remoteContainerName == null) {
                                            return;
                                        }
                                        Command c = (Command)content;
                                        if (!"RESPONSE_LIST".equals(c.getName())) {
                                            shell.dispose();
                                            return;
                                        }
                                        boolean someChanges = false;
                                        int insertPoint = 1;
                                        for (AglobeParam item : c.getAglobeParam()) {
                                            if (!"Agent".equals(item.getName())) break;
                                            if (!someChanges) {
                                                localPopupMenu.add((Component)new JPopupMenu.Separator(), insertPoint++);
                                                someChanges = true;
                                            }
                                            JMenuItem jitem = new JMenuItem("Show GUI of " + item.getValue());
                                            jitem.addActionListener(new ActionListener(this, item, shell, er){
                                                final /* synthetic */ 1 this$2;
                                                private final /* synthetic */ AglobeParam val$item;
                                                private final /* synthetic */ GISServerService.Shell val$shell;
                                                private final /* synthetic */ EntityRecord val$er;
                                                {
                                                    this.this$2 = var1_1;
                                                    this.val$item = aglobeParam;
                                                    this.val$shell = shell;
                                                    this.val$er = entityRecord;
                                                }

                                                public void actionPerformed(ActionEvent e) {
                                                    Command c = new Command();
                                                    c.setName("ENTITY_GUI");
                                                    c.getAglobeParam().add(AglobeXMLtools.makeAglobeParam("Agent", this.val$item.getValue()));
                                                    c.getAglobeParam().add(AglobeXMLtools.makeAglobeParam("Visible", "true"));
                                                    this.val$shell.sendTopic(this.val$er.containerName, "COMMAND", c);
                                                }
                                            });
                                            localPopupMenu.add((Component)jitem, insertPoint++);
                                        }
                                        if (someChanges) {
                                            localPopupMenu.setVisible(false);
                                            localPopupMenu.setVisible(true);
                                        }
                                        shell.dispose();
                                    }

                                    public void addEvent(Runnable e) {
                                        owner.addEvent(e);
                                    }
                                });
                                shell.sendTopic(er.containerName, "COMMAND", c);
                            }
                        }
                    }
                }
            });
        }
    }

    private void updateRemainingEntitySlots() {
        if (this.owner.gui != null) {
            this.owner.gui.setFreeEntitySlots(this.owner.configuration.getMaxEntities() - this.entities.size());
        }
    }

    void configurationUpdated() {
        String storeRoot = this.owner.getContainer().getGlobalStore().getStoreRootDir();
        String systemName = this.owner.gisShell.getSystemName();
        this.startingAttributes = "-client -noStoreChange " + this.owner.configuration.getAdditionalContainerStartupAttributes() + " -systemName " + systemName + " -store " + storeRoot + " -serverAddress " + this.owner.getAddress().deriveContainerAddress().toString() + " -name ";
        if (this.entitySlotArray == null) {
            this.entitySlotArray = new EntityRecord[this.owner.configuration.getMaxEntities()];
        } else if (this.entitySlotArray.length != this.owner.configuration.getMaxEntities()) {
            EntityRecord[] newEntitiesSlotArray = new EntityRecord[this.owner.configuration.getMaxEntities()];
            this.nextSlot = 0;
            System.arraycopy(this.entitySlotArray, 0, newEntitiesSlotArray, 0, Math.min(this.entitySlotArray.length, newEntitiesSlotArray.length));
            this.entitySlotArray = newEntitiesSlotArray;
        }
        this.updateRemainingEntitySlots();
    }

    void crateNewEntity(EntityRecord entityRecord, final ContainerStartup containerStartupConfiguration) throws Exception {
        if (this.entities.size() >= this.owner.configuration.getMaxEntities()) {
            throw new Exception("Cannot create new entity. " + this.entities.size() + " already running. Change MaxEntities parameter in the Configuration.");
        }
        if (entityRecord.linkedToContainerName != null && this.entitiesByName.get(entityRecord.linkedToContainerName) == null) {
            throw new Exception("Cannot create new entity. There is no running entity to which this entity is linked: " + entityRecord.linkedToContainerName);
        }
        int slotIndex = this.findNextFreeSlotIndex();
        PlatformRecord platform = containerStartupConfiguration != null ? this.owner.platformAdministrator.getPlatformWithMinimumEntities() : this.owner.platformAdministrator.getAbstractPlatform();
        if (platform == null) {
            throw new Exception("No platform available");
        }
        entityRecord.platform = platform;
        entityRecord.indexToSlotArray = slotIndex;
        this.entities.add(entityRecord);
        this.entitiesByName.put(entityRecord.containerName, entityRecord);
        platform.entities.add(entityRecord);
        this.entitySlotArray[slotIndex] = entityRecord;
        this.tableModel.fireTableDataChanged();
        this.owner.platformAdministrator.updatePlatformTable();
        this.updateRemainingEntitySlots();
        if (containerStartupConfiguration != null) {
            String startingAttr = String.valueOf(this.startingAttributes) + entityRecord.containerName;
            String[] attrs = startingAttr.split(" +");
            List<String> attribute = containerStartupConfiguration.getAttribute();
            attribute.clear();
            int i = 0;
            while (i < attrs.length) {
                attribute.add(attrs[i]);
                ++i;
            }
            containerStartupConfiguration.setLibrarySourceContainer(Address.getLocalContainerAddress(this.owner));
            if (this.waitingForLogin < 1) {
                ++this.waitingForLogin;
                if (platform == this.owner.platformAdministrator.localServerPlatform) {
                    this.owner.addEvent(new Runnable(){

                        public void run() {
                            AgentList al = containerStartupConfiguration.getAgentList();
                            ServiceList sl = containerStartupConfiguration.getServiceList();
                            String[] attribs = containerStartupConfiguration.getAttribute().toArray(new String[containerStartupConfiguration.getAttribute().size()]);
                            try {
                                Platform.startNewContainer(attribs, al, sl, containerStartupConfiguration.getLibrarySourceContainer());
                            }
                            catch (Exception ex) {
                                EntityAdministrator.this.owner.logSevere("Exception during starting new A-globe container: " + ex.toString());
                            }
                        }
                    });
                } else {
                    this.owner.gisShell.sendTopic(platform.name, "COMMAND", containerStartupConfiguration);
                }
            } else {
                this.entitiesForStartup.add(new EntityForStartup(containerStartupConfiguration, platform));
            }
        } else {
            ++this.waitingForLogin;
            this.entityLogin(entityRecord.containerName, Address.getLocalContainerAddress(this.owner.getContainer()));
        }
        if (this.owner.waitForEntityCreation && this.waitingForLogin > 0 && !this.simulationPaused) {
            this.simulationPaused = true;
            this.owner.gisShell.sendTopicToLocal("ENTITY_CREATION_PAUSE_SIMULATION", Boolean.toString(true));
        }
    }

    synchronized void entityGroupCreated() {
        this.notLoggedGroupEntities = new HashSet();
        for (EntityRecord elem : this.entities) {
            if (elem.address != null) continue;
            this.notLoggedGroupEntities.add(elem.containerName);
        }
    }

    private int findNextFreeSlotIndex() {
        while (this.entitySlotArray[this.nextSlot] != null) {
            this.nextSlot = (this.nextSlot + 1) % this.entitySlotArray.length;
        }
        return this.nextSlot;
    }

    void entityLogin(String containerName, Address containerAddress) {
        EntityRecord er = this.entitiesByName.get(containerName);
        if (er != null) {
            er.address = containerAddress;
            this.tableModel.fireTableDataChanged();
            if (this.owner.visioAgentRunning) {
                this.owner.gisShell.sendTopicToLocal("VISIO_LOGIN_REQUEST", er);
            } else {
                short visioID = this.owner.objectIndexAllocator.allocateNextObjectIndex();
                this.entityCreatedNotification(er.containerName, visioID);
            }
        } else {
            this.owner.logSevere("Unexpected entity login: " + containerName);
        }
    }

    void entityLogout(String containerName) {
        EntityRecord er = this.entitiesByName.get(containerName);
        if (er == null) {
            this.owner.logSevere("Unexpected entity logout: " + containerName);
            return;
        }
        er.platform.entities.remove(er);
        this.entities.remove(er);
        this.entitiesByName.remove(er.containerName);
        this.entitySlotArray[er.indexToSlotArray] = null;
        this.owner.gisShell.sendTopicToLocal("ENTITY_LOGOUT", er);
        this.owner.gisShell.sendTopicToLocal("VISIO_LOGOUT", null, er.containerName);
        this.tableModel.fireTableDataChanged();
        this.owner.platformAdministrator.updatePlatformTable();
        this.updateRemainingEntitySlots();
        if (!this.owner.visioAgentRunning) {
            this.owner.objectIndexAllocator.freeVisioID(er.visioID);
        }
        this.owner.testEndOfScenario();
        this.testLastEntity();
    }

    void destroyEntity(String entityName) {
        EntityRecord er = this.entitiesByName.get(entityName);
        if (er == null) {
            this.owner.logSevere("Unexpected entity request for destroy: " + entityName);
            return;
        }
        this.entityLogout(entityName);
        this.owner.shutdownEntityContainer(er);
    }

    boolean hasSomeLoggedEntities() {
        return this.entities.size() > 0;
    }

    Collection<EntityRecord> getLoggedEntities() {
        LinkedList<EntityRecord> ret = new LinkedList<EntityRecord>();
        for (EntityRecord item : this.entities) {
            if (item.address == null) continue;
            ret.add(item);
        }
        return ret;
    }

    EntityRecord getEntityByContainerName(String containerName) {
        EntityRecord er = this.entitiesByName.get(containerName);
        if (er == null || er.address == null) {
            return null;
        }
        return er;
    }

    Collection<EntityRecord> getNotLoggedEntities() {
        LinkedList<EntityRecord> ret = new LinkedList<EntityRecord>();
        for (EntityRecord item : this.entities) {
            if (item.address != null) continue;
            ret.add(item);
        }
        return ret;
    }

    void removeNotLoggedEntities() {
        LinkedList<EntityRecord> tmp = new LinkedList<EntityRecord>(this.entities);
        for (EntityRecord elem : tmp) {
            if (elem.address != null) continue;
            this.entityLogout(elem.containerName);
        }
        this.entitiesForStartup.clear();
        this.waitingForLogin = 0;
        if (this.owner.waitForEntityCreation && this.simulationPaused) {
            this.simulationPaused = false;
            this.owner.gisShell.sendTopicToLocal("ENTITY_CREATION_PAUSE_SIMULATION", Boolean.toString(false));
        }
    }

    int getRunningEntities() {
        return this.entities.size();
    }

    private void testLastEntity() {
        if (this.waitForNoEntity != null && this.entities.size() == 0) {
            Runnable r = this.waitForNoEntity;
            this.waitForNoEntity = null;
            r.run();
        }
    }

    void waitForNoEntity(Runnable r) {
        this.waitForNoEntity = r;
        this.testLastEntity();
    }

    void distributeAllCreateEntities(String receiverId) {
        for (EntityRecord elem : this.entities) {
            if (elem.visioID < 0) continue;
            this.owner.gisShell.sendTopicToLocal("CURRENT_ENTITIES", elem, receiverId);
        }
    }

    void entityCreatedNotification(String entityContainerName, short visioId) {
        EntityRecord er = this.entitiesByName.get(entityContainerName);
        if (er == null) {
            this.owner.logSevere("Nonexistend entity: " + entityContainerName);
            return;
        }
        er.visioID = visioId;
        this.owner.gisShell.sendTopicToLocal("ENTITY_LOGGED", er);
        this.owner.gisShell.sendTopic(er.containerName, "ENTITY_CONNECTION", er.entityDescriptor);
        this.owner.gisShell.sendTopic(er.containerName, "ENTITY_CONNECTION", this.owner.configuration.getWorldDimension());
        --this.waitingForLogin;
        if (this.waitingForLogin < 1 && this.entitiesForStartup.size() > 0) {
            final EntityForStartup ets = this.entitiesForStartup.removeFirst();
            ++this.waitingForLogin;
            if (ets.platform == this.owner.platformAdministrator.localServerPlatform) {
                this.owner.addEvent(new Runnable(){

                    public void run() {
                        AgentList al = ets.containerStartup.getAgentList();
                        ServiceList sl = ets.containerStartup.getServiceList();
                        String[] attribs = ets.containerStartup.getAttribute().toArray(new String[ets.containerStartup.getAttribute().size()]);
                        try {
                            Platform.startNewContainer(attribs, al, sl, ets.containerStartup.getLibrarySourceContainer());
                        }
                        catch (Exception ex) {
                            EntityAdministrator.this.owner.logSevere("Exception during starting new A-globe container: " + ex.toString());
                        }
                    }
                });
            } else {
                this.owner.gisShell.sendTopic(((EntityForStartup)ets).platform.name, "COMMAND", ets.containerStartup);
            }
        }
        if (this.notLoggedGroupEntities != null) {
            this.notLoggedGroupEntities.remove(er.containerName);
            if (this.notLoggedGroupEntities.size() == 0) {
                this.owner.gisShell.broadcastTopic("ENTITY_GROUP_LOGGED", "");
                this.notLoggedGroupEntities = null;
            }
        }
        if (this.owner.waitForEntityCreation && this.waitingForLogin == 0 && this.simulationPaused) {
            this.simulationPaused = false;
            this.owner.gisShell.sendTopicToLocal("ENTITY_CREATION_PAUSE_SIMULATION", Boolean.toString(false));
        }
    }

    private class EntityForStartup {
        private final ContainerStartup containerStartup;
        private final PlatformRecord platform;

        private EntityForStartup(ContainerStartup containerStartup, PlatformRecord platform) {
            this.containerStartup = containerStartup;
            this.platform = platform;
        }
    }

    private class EntityTableModel
    extends AbstractTableModel {
        private static final int COL_NAME = 0;
        private static final int COL_TYPE = 1;
        private static final int COL_PLATFORM = 2;
        private static final int COL_LOGGED = 3;
        private static final int COL_ENTITY_ADDRESS = 4;
        private final String[] COLUMNS = new String[]{"Name", "Type", "Platform", "Logged", "Address"};

        private EntityTableModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            EntityAdministrator entityAdministrator = EntityAdministrator.this;
            synchronized (entityAdministrator) {
                return EntityAdministrator.this.entities.size();
            }
        }

        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int rowIndex, int columnIndex) {
            EntityAdministrator entityAdministrator = EntityAdministrator.this;
            synchronized (entityAdministrator) {
                block12: {
                    block13: {
                        if (rowIndex < EntityAdministrator.this.entities.size()) break block12;
                        if (columnIndex != 3) break block13;
                        return false;
                    }
                    return "";
                }
                switch (columnIndex) {
                    case 0: {
                        return ((EntityRecord)((EntityAdministrator)EntityAdministrator.this).entities.get((int)rowIndex)).containerName;
                    }
                    case 1: {
                        return ((EntityRecord)((EntityAdministrator)EntityAdministrator.this).entities.get((int)rowIndex)).entityDescriptor.typeDescriptor.typeName;
                    }
                    case 2: {
                        return ((EntityRecord)((EntityAdministrator)EntityAdministrator.this).entities.get((int)rowIndex)).platform.name;
                    }
                    case 3: {
                        return ((EntityRecord)((EntityAdministrator)EntityAdministrator.this).entities.get((int)rowIndex)).address != null;
                    }
                    case 4: {
                        EntityRecord pr = (EntityRecord)EntityAdministrator.this.entities.get(rowIndex);
                        return pr.address != null ? pr.address.toString() : "<not logged>";
                    }
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 3: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        public String getColumnName(int columnIndex) {
            return this.COLUMNS[columnIndex];
        }
    }
}

