/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.distance;

import aglobe.platform.thread.AglobeThreadPool;
import aglobex.simulation.distance.DistanceAgent;
import aglobex.simulation.global.EntitiesPositionDistanceInfo;
import aglobex.simulation.global.EntitiesPositionInfo;
import java.util.Arrays;

public class DistanceCounter
implements Runnable {
    private static final int OUT_POOL_SIZE = 5;
    private final DistanceAgent owner;
    private double[][] distanceMatrix;
    private double[][] XYdistanceMatrix;
    public double[] minimalDistances2;
    public double overalMinimalDistance2;
    private int distanceSize;
    private Thread distanceCounterThread;
    private boolean finish = false;
    private boolean suspended = false;
    private EntitiesPositionInfo position;
    private EntitiesPositionDistanceInfo[] outputPool;
    private EntitiesPositionDistanceInfo lastDistanceInfo;
    private int currentOutputFromPool = 0;
    private boolean firstConfiguration = false;

    DistanceCounter(DistanceAgent owner) {
        this.owner = owner;
        this.distanceCounterThread = AglobeThreadPool.getThread(this, "Distance counter");
        this.distanceCounterThread.setPriority(Math.min(4, 1));
        this.distanceCounterThread.start();
    }

    private double[][] getOthersizeMatrix(int newSize, double[][] old) {
        double[][] retVal = new double[newSize][newSize];
        int minLength = Math.min(newSize, old.length);
        int i = 0;
        while (i < minLength) {
            System.arraycopy(old[i], 0, retVal[i], 0, minLength);
            ++i;
        }
        return retVal;
    }

    private double[] getOthersizeVector(int newSize, double[] old) {
        double[] retVal = new double[newSize];
        System.arraycopy(old, 0, retVal, 0, Math.min(old.length, newSize));
        return retVal;
    }

    synchronized void configurationChanged() {
        this.distanceSize = this.owner.configuration.getMaxEntities();
        if (this.distanceMatrix == null) {
            this.distanceMatrix = new double[this.distanceSize][this.distanceSize];
            this.XYdistanceMatrix = new double[this.distanceSize][this.distanceSize];
            this.minimalDistances2 = new double[this.distanceSize];
            this.outputPool = new EntitiesPositionDistanceInfo[5];
            int i = 0;
            while (i < this.outputPool.length) {
                this.outputPool[i] = new EntitiesPositionDistanceInfo();
                this.outputPool[i].distanceMatrix = new double[this.distanceSize][this.distanceSize];
                this.outputPool[i].XYdistanceMatrix = new double[this.distanceSize][this.distanceSize];
                this.outputPool[i].minimalDistances2 = new double[this.distanceSize];
                ++i;
            }
            this.firstConfiguration = true;
        } else if (this.distanceSize != this.distanceMatrix.length) {
            this.distanceMatrix = this.getOthersizeMatrix(this.distanceSize, this.distanceMatrix);
            this.XYdistanceMatrix = this.getOthersizeMatrix(this.distanceSize, this.XYdistanceMatrix);
            this.minimalDistances2 = this.getOthersizeVector(this.distanceSize, this.minimalDistances2);
            int i = 0;
            while (i < this.outputPool.length) {
                this.outputPool[i].distanceMatrix = this.getOthersizeMatrix(this.distanceSize, this.outputPool[i].distanceMatrix);
                this.outputPool[i].XYdistanceMatrix = this.getOthersizeMatrix(this.distanceSize, this.outputPool[i].XYdistanceMatrix);
                this.outputPool[i].minimalDistances2 = this.getOthersizeVector(this.distanceSize, this.outputPool[i].minimalDistances2);
                ++i;
            }
        }
    }

    synchronized void dispose() {
        this.finish = true;
        this.resumeThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseNewPositions(EntitiesPositionInfo position) {
        if (this.suspended) {
            DistanceCounter distanceCounter = this;
            synchronized (distanceCounter) {
                this.position = position;
            }
            this.resumeThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resentLastDistanceInfo() {
        DistanceCounter distanceCounter = this;
        synchronized (distanceCounter) {
            this.owner.gisShell.sendTopicToLocal("POSITION_DISTANCE_UPDATE", this.lastDistanceInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.suspendThread();
        while (!this.finish) {
            DistanceCounter distanceCounter = this;
            synchronized (distanceCounter) {
                if (this.position != null) {
                    if (this.firstConfiguration) {
                        Arrays.fill(this.minimalDistances2, Double.POSITIVE_INFINITY);
                        this.overalMinimalDistance2 = Double.POSITIVE_INFINITY;
                        int i = 1;
                        while (i < this.position.visioId.length) {
                            if (this.position.visioId[i] >= 0) {
                                int j = 0;
                                while (j < i) {
                                    if (this.position.visioId[j] >= 0) {
                                        double val;
                                        this.XYdistanceMatrix[i][j] = val = (this.position.x[i] - this.position.x[j]) * (this.position.x[i] - this.position.x[j]) + (this.position.y[i] - this.position.y[j]) * (this.position.y[i] - this.position.y[j]);
                                        this.XYdistanceMatrix[j][i] = val;
                                        this.distanceMatrix[i][j] = val = this.XYdistanceMatrix[i][j] + (this.position.z[i] - this.position.z[j]) * (this.position.z[i] - this.position.z[j]);
                                        this.distanceMatrix[j][i] = val;
                                        this.overalMinimalDistance2 = Math.min(this.overalMinimalDistance2, val);
                                        this.minimalDistances2[i] = Math.min(this.minimalDistances2[i], val);
                                        this.minimalDistances2[j] = Math.min(this.minimalDistances2[j], val);
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        this.outputPool[this.currentOutputFromPool].positions = this.position;
                        i = 0;
                        while (i < this.distanceSize) {
                            System.arraycopy(this.distanceMatrix[i], 0, this.outputPool[this.currentOutputFromPool].distanceMatrix[i], 0, this.distanceSize);
                            System.arraycopy(this.XYdistanceMatrix[i], 0, this.outputPool[this.currentOutputFromPool].XYdistanceMatrix[i], 0, this.distanceSize);
                            ++i;
                        }
                        System.arraycopy(this.minimalDistances2, 0, this.outputPool[this.currentOutputFromPool].minimalDistances2, 0, this.distanceSize);
                        this.outputPool[this.currentOutputFromPool].overalMinimalDistance2 = this.overalMinimalDistance2;
                        this.owner.gisShell.sendTopicToLocal("POSITION_DISTANCE_UPDATE", this.outputPool[this.currentOutputFromPool]);
                        this.lastDistanceInfo = this.outputPool[this.currentOutputFromPool];
                        this.currentOutputFromPool = (this.currentOutputFromPool + 1) % 5;
                    }
                    this.position = null;
                }
            }
            this.suspendThread();
        }
    }

    private synchronized void suspendThread() {
        this.suspended = true;
        while (this.suspended && !this.finish) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void resumeThread() {
        this.suspended = false;
        this.notify();
    }
}

