/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.distance;

import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobex.simulation.distance.DistanceCounter;
import aglobex.simulation.global.EntitiesPositionInfo;
import aglobex.simulation.ontology.Configuration;

public class DistanceAgent
extends Agent
implements GISTopicServerListener {
    GISServerService.Shell gisShell;
    Configuration configuration;
    private DistanceCounter distanceCounter;

    protected void handleIncomingMessage(Message m) {
        this.logSevere("Unexpected incoming message: " + m);
        m.release();
    }

    public void init(AgentInfo ai, int initState) {
        this.setThreadPersistency(true);
        Thread.currentThread().setPriority(Math.min(6, 10));
        this.gisShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        if (this.gisShell == null) {
            this.logSevere("Can run only on the server container.");
            this.stop();
            return;
        }
        this.distanceCounter = new DistanceCounter(this);
        this.gisShell.subscribeTopic("CONFIGURATION", this);
        this.gisShell.subscribeTopic("POSITION_UPDATE", this);
        this.gisShell.subscribeTopic("POSITION_DISTANCE_UPDATE_REQUEST", this);
        this.gisShell.sendTopicToLocal("CONFIGURATION_REQUEST", null, this.getName());
    }

    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
    }

    public void handleLogoutTopic(String topic, String remoteContainerName) {
    }

    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equals("CONFIGURATION")) {
            if (this.getName().equals(reason)) {
                this.configuration = (Configuration)content;
                this.distanceCounter.configurationChanged();
            }
            return;
        }
        if (topic.equals("POSITION_UPDATE") && remoteContainerName == null) {
            this.distanceCounter.parseNewPositions((EntitiesPositionInfo)content);
            return;
        }
        if (topic.equals("POSITION_DISTANCE_UPDATE_REQUEST")) {
            this.distanceCounter.resentLastDistanceInfo();
            return;
        }
        this.logSevere("Unexpected incoming topic: " + topic);
    }

    protected void finish() {
        if (this.distanceCounter != null) {
            this.distanceCounter.dispose();
        }
    }
}

