/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.configurator;

import aglobe.container.ElementaryEntity;
import aglobe.container.transport.Address;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListenerWithoutLogin;
import aglobex.simulation.entitymanager.GISShellProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguratorTools {
    private static long uniqueRequesterID = 1L;

    private ConfiguratorTools() {
    }

    public static boolean confFilesExists(ElementaryEntity owner, LinkedHashSet<String> testedFiles) {
        Map<String, InputStream> test = ConfiguratorTools.getConfFiles(owner, testedFiles);
        for (InputStream elem : test.values()) {
            if (elem != null) continue;
            return false;
        }
        return true;
    }

    public static boolean confFilesExists(GISShellProvider gisShellProvider, LinkedHashSet<String> testedFiles) {
        Map<String, InputStream> test = ConfiguratorTools.getConfFiles(gisShellProvider, testedFiles);
        for (InputStream elem : test.values()) {
            if (elem != null) continue;
            return false;
        }
        return true;
    }

    public static InputStream getConfFile(ElementaryEntity owner, String filePath) {
        LinkedHashSet<String> param = new LinkedHashSet<String>();
        param.add(filePath);
        return ConfiguratorTools.getConfFiles(owner, param).get(filePath);
    }

    public static InputStream getConfFile(GISShellProvider gisShellProvider, String filePath) {
        LinkedHashSet<String> param = new LinkedHashSet<String>();
        param.add(filePath);
        return ConfiguratorTools.getConfFiles(gisShellProvider, param).get(filePath);
    }

    public static Map<String, InputStream> getConfFiles(ElementaryEntity owner, LinkedHashSet<String> requestedFiles) {
        return ConfiguratorTools.getConfFiles((GISServerService.Shell)owner.getContainer().getServiceManager().getService(owner, "gis/master"), requestedFiles);
    }

    public static Map<String, InputStream> getConfFiles(GISShellProvider gisShellProvider, LinkedHashSet<String> requestedFiles) {
        return ConfiguratorTools.getConfFiles(gisShellProvider.getGISShell(), requestedFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, InputStream> getConfFiles(GISServerService.Shell gisShell, LinkedHashSet<String> requestedFiles) {
        LinkedHashMap<String, InputStream> retVal;
        block10: {
            retVal = new LinkedHashMap<String, InputStream>();
            if (requestedFiles.size() == 0) {
                return retVal;
            }
            final Object sync = new Object();
            final HashSet<String> requested = new HashSet<String>(requestedFiles);
            Iterator iter = requestedFiles.iterator();
            while (iter.hasNext()) {
                final String id = ConfiguratorTools.getUniqueRequesterID();
                final String item = (String)iter.next();
                gisShell.subscribeTopic("CONFIGURATION_FILE", new GISTopicServerListenerWithoutLogin(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                        if (id.equals(reason)) {
                            Object object = sync;
                            synchronized (object) {
                                if (content != null) {
                                    retVal.put(item, new ByteArrayInputStream((byte[])content));
                                }
                                requested.remove(item);
                                if (requested.size() == 0) {
                                    sync.notify();
                                }
                            }
                        }
                    }

                    public void addEvent(Runnable e) {
                        e.run();
                    }
                });
                gisShell.sendTopicToLocal("CONFIGURATION_FILE_REQUEST", item, id);
            }
            Object object = sync;
            synchronized (object) {
                while (true) {
                    while (true) {
                        if (requested.size() == 0) {
                            break block10;
                        }
                        try {
                            sync.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        gisShell.dispose();
        return retVal;
    }

    public static boolean confObjectsExists(ElementaryEntity owner, LinkedHashMap<String, String> testedObjects) {
        Map<String, Object> test = ConfiguratorTools.getConfObjects(owner, testedObjects);
        for (Object elem : test.values()) {
            if (elem != null) continue;
            return false;
        }
        return true;
    }

    public static boolean confObjectsExists(GISShellProvider gisShellProvider, LinkedHashMap<String, String> testedObjects) {
        Map<String, Object> test = ConfiguratorTools.getConfObjects(gisShellProvider, testedObjects);
        for (Object elem : test.values()) {
            if (elem != null) continue;
            return false;
        }
        return true;
    }

    public static Object getConfObject(ElementaryEntity owner, String objectPath, String ontology) {
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put(objectPath, ontology);
        return ConfiguratorTools.getConfObjects(owner, param).get(objectPath);
    }

    public static Object getConfObject(GISShellProvider gisShellProvider, String objectPath, String ontology) {
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put(objectPath, ontology);
        return ConfiguratorTools.getConfObjects(gisShellProvider, param).get(objectPath);
    }

    public static Map<String, Object> getConfObjects(ElementaryEntity owner, LinkedHashMap<String, String> requestedObjects) {
        return ConfiguratorTools.getConfObjects((GISServerService.Shell)owner.getContainer().getServiceManager().getService(owner, "gis/master"), requestedObjects);
    }

    public static Map<String, Object> getConfObjects(GISShellProvider gisShellProvider, LinkedHashMap<String, String> requestedObjects) {
        return ConfiguratorTools.getConfObjects(gisShellProvider.getGISShell(), requestedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> getConfObjects(GISServerService.Shell gisShell, LinkedHashMap<String, String> requestedObjects) {
        LinkedHashMap<String, Object> retVal;
        block10: {
            retVal = new LinkedHashMap<String, Object>();
            if (requestedObjects.size() == 0) {
                return retVal;
            }
            final Object sync = new Object();
            final HashSet requested = new HashSet(requestedObjects.keySet());
            Iterator<Map.Entry<String, String>> iter = requestedObjects.entrySet().iterator();
            while (iter.hasNext()) {
                final String id = ConfiguratorTools.getUniqueRequesterID();
                final Map.Entry<String, String> item = iter.next();
                gisShell.subscribeTopic("CONFIGURATION_OBJECT", new GISTopicServerListenerWithoutLogin(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                        if (id.equals(reason)) {
                            Object object = sync;
                            synchronized (object) {
                                retVal.put((String)item.getKey(), content);
                                requested.remove(item.getKey());
                                if (requested.size() == 0) {
                                    sync.notify();
                                }
                            }
                        }
                    }

                    public void addEvent(Runnable e) {
                        e.run();
                    }
                });
                gisShell.sendTopicToLocal("CONFIGURATION_OBJECT_REQUEST", new String[]{item.getKey(), item.getValue()}, id);
            }
            Object object = sync;
            synchronized (object) {
                while (true) {
                    while (true) {
                        if (requested.size() == 0) {
                            break block10;
                        }
                        try {
                            sync.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        gisShell.dispose();
        return retVal;
    }

    public static String loadLibrary(ElementaryEntity owner, String libraryPath) {
        LinkedHashSet<String> requests = new LinkedHashSet<String>();
        requests.add(libraryPath);
        return ConfiguratorTools.loadLibraries(owner, requests).get(libraryPath);
    }

    public static String loadLibrary(GISShellProvider gisShellProvider, String libraryPath) {
        LinkedHashSet<String> requests = new LinkedHashSet<String>();
        requests.add(libraryPath);
        return ConfiguratorTools.loadLibraries(gisShellProvider, requests).get(libraryPath);
    }

    public static Map<String, String> loadLibraries(ElementaryEntity owner, LinkedHashSet<String> requestedLibraries) {
        return ConfiguratorTools.loadLibraries((GISServerService.Shell)owner.getContainer().getServiceManager().getService(owner, "gis/master"), requestedLibraries);
    }

    public static Map<String, String> loadLibraries(GISShellProvider gisShellProvider, LinkedHashSet<String> requestedLibraries) {
        return ConfiguratorTools.loadLibraries(gisShellProvider.getGISShell(), requestedLibraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadLibraries(GISServerService.Shell gisShell, LinkedHashSet<String> requestedLibraries) {
        final LinkedHashMap<String, String> retVal = new LinkedHashMap<String, String>();
        if (requestedLibraries.size() == 0) {
            return retVal;
        }
        final Object sync = new Object();
        final HashSet<String> requested = new HashSet<String>(requestedLibraries);
        Iterator iter = requestedLibraries.iterator();
        while (iter.hasNext()) {
            final String id = ConfiguratorTools.getUniqueRequesterID();
            final String item = (String)iter.next();
            gisShell.subscribeTopic("LOAD_LIBRARY_RESPONSE", new GISTopicServerListenerWithoutLogin(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                    if (id.equals(reason)) {
                        Object object = sync;
                        synchronized (object) {
                            retVal.put(item, (String)content);
                            requested.remove(item);
                            if (requested.size() == 0) {
                                sync.notify();
                            }
                        }
                    }
                }

                public void addEvent(Runnable e) {
                    e.run();
                }
            });
            gisShell.sendTopicToLocal("LOAD_LIBRARY_REQUEST", item, id);
        }
        Object object = sync;
        synchronized (object) {
            try {
                sync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        gisShell.dispose();
        return retVal;
    }

    private static synchronized String getUniqueRequesterID() {
        return "ConfiguratorTools:" + Long.toString(uniqueRequesterID++);
    }
}

