/*
 * Decompiled with CFR 0.152.
 */
package aglobex.simulation.configurator;

import aglobe.container.agent.Agent;
import aglobe.container.library.LibraryManager;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Command;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobe.service.gis.server.GISTopicServerListenerWithoutLogin;
import aglobe.util.AglobeXMLtools;
import aglobex.simulation.configurator.ConfiguratorAgentGUI;
import aglobex.simulation.ontology.Configuration;
import aglobex.simulation.ontology.EntityType;
import aglobex.simulation.ontology.Param;
import aglobex.simulation.ontology.UserScenario;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBException;

public class ConfiguratorAgent
extends Agent
implements GISTopicServerListener {
    private GISServerService.Shell gisShell;
    private Configuration configuration;
    private LinkedHashSet<String> configurationReceivers = new LinkedHashSet();
    String currentConfigFilename;
    LinkedList<String> configFilenames;
    private HashMap<String, byte[]> confFiles = new HashMap();
    private HashMap<String, Object> confObjects = new HashMap();
    private HashMap<String, String> loadedLibraries = new HashMap();
    private ConfiguratorAgentGUI gui;

    protected void handleIncomingMessage(Message m) {
        this.logSevere("Unexpected incoming message: " + m);
        m.release();
    }

    private boolean reloadConfig() {
        File mainConfig = new File(this.currentConfigFilename);
        try {
            FileInputStream fis = new FileInputStream(mainConfig);
            this.configuration = (Configuration)AglobeXMLtools.unmarshallJAXBObject(Configuration.class, fis);
            fis.close();
        }
        catch (FileNotFoundException ex) {
            this.logSevere("Configuration file not found: " + this.currentConfigFilename);
            return false;
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            this.logSevere("Configuration file '" + this.currentConfigFilename + "' is not compatible with Configuration.xsd !!!");
            return false;
        }
        catch (IOException ex) {
            this.logSevere("Loading configuration file '" + this.currentConfigFilename + "' failed.");
            return false;
        }
        for (EntityType entityType : this.configuration.getEntityType()) {
            if (entityType.getCrashRange() < 0.0) {
                entityType.setCrashRange(Double.NEGATIVE_INFINITY);
            }
            if (!"VOID".equals(entityType.getSimulationClass())) continue;
            entityType.setSimulationClass("aglobex.simulation.entitysimulator.VoidBehaviour");
        }
        for (EntityType entityType : this.configuration.getEntityType()) {
            for (Param item1 : entityType.getParam()) {
                if (item1.getType().equals("Double")) {
                    try {
                        Double.parseDouble(item1.getValue());
                        continue;
                    }
                    catch (NumberFormatException ex1) {
                        this.logSevere("Double param: " + item1.getName() + " for entity: " + entityType.getName() + " contains not double value.");
                        return false;
                    }
                }
                if (item1.getType().equals("Integer")) {
                    try {
                        Integer.parseInt(item1.getValue());
                        continue;
                    }
                    catch (NumberFormatException ex1) {
                        this.logSevere("Integer param: " + item1.getName() + " for entity: " + entityType.getName() + " contains not integer value.");
                        return false;
                    }
                }
                if (item1.getType().equals("Boolean")) {
                    try {
                        Boolean.parseBoolean(item1.getValue());
                        continue;
                    }
                    catch (NumberFormatException ex1) {
                        this.logSevere("Boolean param: " + item1.getName() + " for entity: " + entityType.getName() + " contains not boolean value.");
                        return false;
                    }
                }
                if (!item1.getType().equals("Long")) continue;
                try {
                    Long.parseLong(item1.getValue());
                }
                catch (NumberFormatException ex1) {
                    this.logSevere("Long param: " + item1.getName() + " for entity: " + entityType.getName() + " contains not long value.");
                    return false;
                }
            }
        }
        for (UserScenario userScenario : this.configuration.getSimulationScenario().getUserScenario()) {
            for (Param item1 : userScenario.getParam()) {
                if (item1.getType().equals("Double")) {
                    try {
                        Double.parseDouble(item1.getValue());
                        continue;
                    }
                    catch (NumberFormatException ex1) {
                        this.logSevere("Double param: " + item1.getName() + " for UserScenario: " + userScenario.getName() + " contains not double value.");
                        return false;
                    }
                }
                if (item1.getType().equals("Integer")) {
                    try {
                        Integer.parseInt(item1.getValue());
                        continue;
                    }
                    catch (NumberFormatException ex1) {
                        this.logSevere("Integer param: " + item1.getName() + " for UserScenario: " + userScenario.getName() + " contains not integer value.");
                        return false;
                    }
                }
                if (item1.getType().equals("Boolean")) {
                    try {
                        Boolean.parseBoolean(item1.getValue());
                        continue;
                    }
                    catch (NumberFormatException ex1) {
                        this.logSevere("Boolean param: " + item1.getName() + " for UserScenario: " + userScenario.getName() + " contains not boolean value.");
                        return false;
                    }
                }
                if (!item1.getType().equals("Long")) continue;
                try {
                    Long.parseLong(item1.getValue());
                }
                catch (NumberFormatException ex1) {
                    this.logSevere("Long param: " + item1.getName() + " for UserScenario: " + userScenario.getName() + " contains not long value.");
                    return false;
                }
            }
        }
        return true;
    }

    void reloadAndRedistributeConfig() {
        this.confFiles.clear();
        this.confObjects.clear();
        this.loadedLibraries.clear();
        if (!this.reloadConfig()) {
            return;
        }
        for (String item : this.configurationReceivers) {
            this.gisShell.sendTopicToLocal("CONFIGURATION", this.configuration, item);
        }
    }

    public void init(AgentInfo ai, int initState) {
        this.setThreadPersistency(true);
        Thread.currentThread().setPriority(Math.min(6, 10));
        this.gisShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        if (this.gisShell == null) {
            this.logSevere("Agent can run only on the server container.");
            this.stop();
            return;
        }
        this.configFilenames = this.getContainer().getMultipleProperty("config");
        if (this.configFilenames == null) {
            this.logSevere("Cannot find initialization attribute: config");
            this.shutdownContainer();
            return;
        }
        this.currentConfigFilename = this.configFilenames.getFirst();
        if (!this.reloadConfig()) {
            this.shutdownContainer();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        ConfiguratorAgent.this.gui = new ConfiguratorAgentGUI(ConfiguratorAgent.this);
                    }
                    catch (Exception ex) {
                        ConfiguratorAgent.this.logWarning("Cannot create GUI due to: " + ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.gisShell.subscribeTopic("CONFIGURATION_REQUEST", this);
        this.gisShell.subscribeTopic("CONFIGURATION_FILE_REQUEST", this);
        this.gisShell.subscribeTopic("CONFIGURATION_OBJECT_REQUEST", this);
        this.gisShell.subscribeTopic("LOAD_LIBRARY_REQUEST", this);
        this.gisShell.subscribeTopic("SIMULATION_STARTED", new GISTopicServerListenerWithoutLogin(){

            public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                final boolean started = Boolean.parseBoolean((String)content);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (ConfiguratorAgent.this.gui != null) {
                            ((ConfiguratorAgent)(this).ConfiguratorAgent.this).gui.reloadButton.setEnabled(!started);
                            if (((ConfiguratorAgent)(this).ConfiguratorAgent.this).gui.configurationComboBox != null) {
                                ((ConfiguratorAgent)(this).ConfiguratorAgent.this).gui.configurationComboBox.setEnabled(!started);
                            }
                        }
                    }
                });
            }

            public void addEvent(Runnable e) {
                ConfiguratorAgent.this.addEvent(e);
            }
        });
    }

    private void shutdownContainer() {
        Command command = new Command();
        command.setName("QUIT");
        this.gisShell.sendTopicToLocal("COMMAND", command);
    }

    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
    }

    public void handleLogoutTopic(String topic, String remoteContainerName) {
    }

    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equals("CONFIGURATION_REQUEST") && remoteContainerName == null && reason != null) {
            this.configurationReceivers.add(reason);
            this.gisShell.sendTopicToLocal("CONFIGURATION", this.configuration, reason);
            return;
        }
        if (topic.equals("CONFIGURATION_FILE_REQUEST") && remoteContainerName == null && reason != null) {
            String filePath = (String)content;
            byte[] retVal = this.confFiles.get(filePath);
            if (retVal == null) {
                try {
                    FileInputStream fis = new FileInputStream(filePath);
                    int toRead = fis.available();
                    retVal = new byte[toRead];
                    if (fis.read(retVal) != toRead) {
                        fis.close();
                        throw new Exception("Cannot read all content");
                    }
                    fis.close();
                    this.confFiles.put(filePath, retVal);
                }
                catch (Exception ex) {
                    this.logWarning("Cannot read configuration file : " + filePath + "\ndue to: " + ex.toString());
                }
            }
            this.gisShell.sendTopicToLocal("CONFIGURATION_FILE", retVal, reason);
            return;
        }
        if (topic.equals("CONFIGURATION_OBJECT_REQUEST") && remoteContainerName == null && reason != null) {
            String[] request = (String[])content;
            String objectPath = request[0];
            String ontology = request[1];
            String key = String.valueOf(objectPath) + ontology;
            Object retVal = this.confObjects.get(key);
            if (retVal == null) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(objectPath);
                    ClassLoader cl = this.getClassLoader();
                    Class<?> cc = cl.loadClass(ontology);
                    retVal = AglobeXMLtools.unmarshallJAXBObject(cc, fis);
                    this.confObjects.put(key, retVal);
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                    this.logWarning("Cannot read configuration object : " + objectPath + "\ndue to: " + ex1.toString());
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.gisShell.sendTopicToLocal("CONFIGURATION_OBJECT", retVal, reason);
            return;
        }
        if (topic.equals("LOAD_LIBRARY_REQUEST") && remoteContainerName == null && reason != null) {
            String libraryPath = (String)content;
            String translatedLibraryName = this.loadedLibraries.get(libraryPath);
            if (translatedLibraryName == null) {
                try {
                    File lib = new File(libraryPath);
                    if (!lib.exists()) {
                        throw new Exception("Library file not found: " + libraryPath);
                    }
                    LibraryManager lm = this.getContainer().getLibraryManager();
                    translatedLibraryName = lm.getLibraryName(lib);
                    if (translatedLibraryName == null) {
                        throw new Exception("Problem with name conversion for: " + libraryPath);
                    }
                    if (!lm.exists(translatedLibraryName) && lm.storeLibrary(lib, "Scenario library") == null) {
                        throw new Exception("Cannot load library: " + libraryPath);
                    }
                    this.loadedLibraries.put(libraryPath, translatedLibraryName);
                }
                catch (Exception ex3) {
                    this.logSevere("Problem with library loading due to: " + ex3.toString());
                    translatedLibraryName = null;
                }
            }
            this.gisShell.sendTopicToLocal("LOAD_LIBRARY_RESPONSE", translatedLibraryName, reason);
            return;
        }
        this.logSevere("Unexpected incoming topic: " + topic);
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    protected void finish() {
        if (this.gui != null) {
            this.gui.setVisible(false);
        }
    }

    void closedGUI() {
        if (this.gisShell != null) {
            this.gisShell.sendTopicToLocal("KILL_ALL", "");
        }
    }
}

