/*
 * Decompiled with CFR 0.152.
 */
package aglobex.service.systemloadmeter;

import aglobe.container.ElementaryEntity;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceShell;
import aglobe.ontology.Message;
import aglobe.platform.thread.AglobeThreadPool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;

public class SystemLoadService
extends Service {
    public static final String SERVICENAME = "load/system";
    private long RECHECK_PERIOD = 30000L;
    private long MEASURING_PERIOD = 1000L;
    private int NUM_PROCESSORS = 2;
    public static Object lock = new Object();
    public static SystemLoadService service = null;
    private static Double systemLoad = Double.NaN;

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService() {
        this.logger.fine("Starting System Load Service (name : " + this.name + ").");
        Object object = lock;
        synchronized (object) {
            if (service == null) {
                service = this;
                this.loadParams();
                System.out.println("SystemLoadService - RECHECK_PERIOD: " + this.RECHECK_PERIOD);
                System.out.println("SystemLoadService - MEASURING_PERIOD: " + this.MEASURING_PERIOD);
                System.out.println("SystemLoadService - NUM_PROCESSORS: " + this.NUM_PROCESSORS);
                this.logFine("System Load Service " + this.name + "started.");
                AglobeThreadPool.getThread(new Measuring(), "Measuring thread").start();
            } else {
                this.kill();
                this.logSevere("Cannot start System Load Service " + this.name + ". Service " + service.getName() + " already running.");
            }
        }
    }

    public void stopService() {
    }

    protected void handleIncomingMessage(Message m) {
        m.release();
    }

    public static synchronized Double getSystemLoad() {
        return systemLoad;
    }

    private void loadParams() {
        try {
            this.NUM_PROCESSORS = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        }
        catch (Exception e) {
            System.out.println("Error reading service configuration : " + e);
        }
    }

    class Measuring
    implements Runnable {
        private boolean suspended = false;
        private boolean finish = false;
        private long timestamp;
        private Object synchro = new Object();
        private ArrayList<Thread> dummyThreads = new ArrayList();
        private ArrayList<Dummy> dummies = new ArrayList();
        private ThreadMXBean threadMXBean;

        Measuring() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.threadMXBean = ManagementFactory.getThreadMXBean();
                this.threadMXBean.setThreadCpuTimeEnabled(true);
                this.threadMXBean.setThreadContentionMonitoringEnabled(true);
                int i = 0;
                while (i < SystemLoadService.this.NUM_PROCESSORS) {
                    Dummy dummy = new Dummy();
                    Thread dummyThread = AglobeThreadPool.getThread(dummy, "DummyThread" + i);
                    dummyThread.setPriority(Math.max(4, 1));
                    dummyThread.start();
                    this.dummyThreads.add(dummyThread);
                    this.dummies.add(dummy);
                    ++i;
                }
                while (!this.finish) {
                    this.timestamp = System.currentTimeMillis();
                    System.out.println("Measuring...");
                    if (!this.finish) {
                        try {
                            ArrayList<Long> tics = new ArrayList<Long>();
                            ArrayList<Long> tacs = new ArrayList<Long>();
                            int i22 = 0;
                            while (i22 < SystemLoadService.this.NUM_PROCESSORS) {
                                tics.add(this.threadMXBean.getThreadCpuTime(this.dummyThreads.get(i22).getId()));
                                this.dummies.get(i22).resumeThread();
                                ++i22;
                            }
                            Object i22 = this.synchro;
                            synchronized (i22) {
                                this.synchro.wait(SystemLoadService.this.MEASURING_PERIOD);
                            }
                            int i3 = 0;
                            while (i3 < SystemLoadService.this.NUM_PROCESSORS) {
                                this.dummies.get(i3).suspendThread();
                                tacs.add(this.threadMXBean.getThreadCpuTime(this.dummyThreads.get(i3).getId()));
                                ++i3;
                            }
                            long sum = 0L;
                            int i4 = 0;
                            while (i4 < SystemLoadService.this.NUM_PROCESSORS) {
                                sum += (Long)tacs.get(i4) - (Long)tics.get(i4);
                                ++i4;
                            }
                            systemLoad = 1.0 - Math.min((double)sum * 1.0 / (double)((long)(SystemLoadService.this.NUM_PROCESSORS * 1000000) * SystemLoadService.this.MEASURING_PERIOD), 1.0);
                            System.out.println("CPU (ms): " + Math.min(sum / (long)(SystemLoadService.this.NUM_PROCESSORS * 1000000), SystemLoadService.this.MEASURING_PERIOD) + " / " + SystemLoadService.this.MEASURING_PERIOD);
                            System.out.println("Load (%) : " + systemLoad * 100.0);
                            try {
                                File file = new File("zatazenie.out");
                                FileWriter fw = new FileWriter(file, true);
                                Double systemPullOut = SystemLoadService.getSystemLoad();
                                fw.write(String.valueOf(systemPullOut.toString()) + "\n");
                                fw.close();
                            }
                            catch (IOException iOException) {}
                        }
                        catch (InterruptedException tics) {
                            // empty catch block
                        }
                    }
                    if (this.finish) continue;
                    try {
                        Object tics = this.synchro;
                        synchronized (tics) {
                            long waitMilis = SystemLoadService.this.RECHECK_PERIOD - (System.currentTimeMillis() - this.timestamp);
                            if (waitMilis > 0L) {
                                this.synchro.wait(waitMilis);
                            }
                        }
                    }
                    catch (InterruptedException tics) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public synchronized void resumeThread() {
            this.suspended = false;
            this.notify();
        }

        public synchronized void dispose() {
            this.finish = true;
            this.resumeThread();
        }
    }

    class Dummy
    implements Runnable {
        private boolean suspended = true;
        private boolean finish = false;

        Dummy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.finish) {
                    int i22 = 0;
                    while (i22 < 10000) {
                        ++i22;
                    }
                    Thread.yield();
                    Dummy i22 = this;
                    synchronized (i22) {
                        try {
                            while (this.suspended) {
                                this.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public synchronized void suspendThread() {
            this.suspended = true;
        }

        public synchronized void resumeThread() {
            this.suspended = false;
            this.notify();
        }

        public synchronized void dispose() {
            this.finish = true;
            this.resumeThread();
        }
    }
}

