/*
 * Decompiled with CFR 0.152.
 */
package aglobex.service.agentmonitor;

import aglobex.service.agentmonitor.AgentMonitorListener;
import aglobex.service.agentmonitor.AgentMonitorParameters;
import aglobex.service.agentmonitor.AgentMonitorScanned;
import aglobex.service.agentmonitor.AgentMonitorService;
import aglobex.service.agentmonitor.FormattedValue;
import aglobex.service.agentmonitor.ProgressValue;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AgentsTableModel
extends AbstractTableModel
implements AgentMonitorListener {
    private final String[] columnNames = AgentMonitorParameters.MonitoredValue.getNames(AgentMonitorParameters.AGENT_FULL.getMonitoredValuesUnion());
    private AgentMonitorScanned lastScanned = null;

    public AgentsTableModel(AgentMonitorService.Shell amsShell) {
        amsShell.addAgentMonitorListener(this, AgentMonitorParameters.AGENT_FULL);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        if (this.lastScanned == null) {
            return 0;
        }
        Map<Object, Object[]> objectMap = this.lastScanned.getObjectMap(AgentMonitorParameters.MonitoredObject.AGENT);
        if (objectMap == null) {
            return 0;
        }
        return objectMap.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object[] dataRow;
        if (this.lastScanned == null) {
            return null;
        }
        Object[] data = this.lastScanned.getObjectMap(AgentMonitorParameters.MonitoredObject.AGENT).values().toArray();
        if (row < data.length && col < (dataRow = (Object[])data[row]).length) {
            return this.processValue(dataRow[col], col);
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        Object value = this.getValueAt(0, c);
        if (value == null) {
            return Void.class;
        }
        return value.getClass();
    }

    public Object processValue(Object value, int col) {
        switch (AgentMonitorParameters.MonitoredValue.values()[col]) {
            case CPU_LOAD: {
                return new ProgressValue((Double)value, (int)((Double)value * 100.0));
            }
            case CPU_TIME: {
                return new FormattedValue<Long, String>((Long)value, String.valueOf((Long)value / 86400000L) + "d " + (Long)value / 3600000L + "h" + (Long)value / 60000L + "m" + (Long)value / 1000L + "s");
            }
            case RUNNING_TIME: {
                return new FormattedValue<Long, String>((Long)value, String.valueOf((Long)value / 86400000L) + "d " + (Long)value / 3600000L + "h" + (Long)value / 60000L + "m" + (Long)value / 1000L + "s");
            }
        }
        return value;
    }

    @Override
    public void afterScanned(AgentMonitorScanned scanned) {
        this.lastScanned = scanned;
        this.fireTableDataChanged();
    }
}

