/*
 * Decompiled with CFR 0.152.
 */
package aglobex.service.agentmonitor;

import aglobex.service.agentmonitor.AgentMonitorService;
import aglobex.service.agentmonitor.AgentsTableModel;
import aglobex.service.agentmonitor.FormattedValue;
import aglobex.service.agentmonitor.FromattedValueRenderer;
import aglobex.service.agentmonitor.ProgressValue;
import aglobex.service.agentmonitor.ProgressValueRenderer;
import aglobex.service.agentmonitor.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

class AgentMonitorServiceGUI
extends JFrame {
    private AgentMonitorService owner = null;
    private JPanel jPanel = null;
    private JTabbedPane jTabbedPane = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private AgentsTableModel agentsTableModel = null;
    private TableSorter tableSorter = null;

    public AgentMonitorServiceGUI(AgentMonitorService agentMonitorService) {
        this.owner = agentMonitorService;
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(500, 300));
        this.setContentPane(this.getJPanel());
        this.setTitle("agent/monitor");
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJTabbedPane(), "Center");
        }
        return this.jPanel;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Agents", null, this.getJScrollPane(), null);
        }
        return this.jTabbedPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setModel(this.getTableSorter());
            this.jTable.setDefaultRenderer(ProgressValue.class, new ProgressValueRenderer());
            this.jTable.setDefaultRenderer(FormattedValue.class, new FromattedValueRenderer());
        }
        return this.jTable;
    }

    private AgentsTableModel getAgentsTableModel() {
        if (this.agentsTableModel == null) {
            AgentMonitorService.Shell amsShell = (AgentMonitorService.Shell)this.owner.getServiceShell(this.owner);
            this.agentsTableModel = new AgentsTableModel(amsShell);
        }
        return this.agentsTableModel;
    }

    private TableSorter getTableSorter() {
        if (this.tableSorter == null) {
            this.tableSorter = new TableSorter();
            this.tableSorter.setTableModel(this.getAgentsTableModel());
            this.tableSorter.setTableHeader(this.jTable.getTableHeader());
        }
        return this.tableSorter;
    }
}

