/*
 * Decompiled with CFR 0.152.
 */
package aglobex.service.agentmonitor;

import aglobe.container.AgentContainer;
import aglobe.container.ElementaryEntity;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceShell;
import aglobe.ontology.Message;
import aglobe.platform.thread.AglobeThreadPool;
import aglobex.service.agentmonitor.AgentMonitor;
import aglobex.service.agentmonitor.AgentMonitorListener;
import aglobex.service.agentmonitor.AgentMonitorParameters;
import aglobex.service.agentmonitor.AgentMonitorServiceGUI;

public class AgentMonitorService
extends Service {
    public static final String SERVICENAME = "agent/monitor";
    private AgentMonitorServiceGUI gui;

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return new Shell(shellOwner, this);
    }

    public void startService() {
        this.gui = new AgentMonitorServiceGUI(this);
        this.gui.setTitle(SERVICENAME);
        this.gui.setVisible(true);
    }

    public void stopService() {
    }

    protected void handleIncomingMessage(Message m) {
        m.release();
    }

    private synchronized void addListener(AgentMonitorListener agentMonitorListener, AgentMonitorParameters agentMonitorParameters) {
        AgentMonitor monitor = new AgentMonitor(this, agentMonitorParameters);
        monitor.addListener(agentMonitorListener);
        AglobeThreadPool.getThread(monitor, "Agent monitor thread").start();
    }

    public static class Shell
    extends ServiceShell {
        private static final long serialVersionUID = -8522017733483348718L;
        private AgentMonitorService agentMonitorService;

        private Shell(ElementaryEntity shellOwner, AgentMonitorService agentMonitorService) {
            super(shellOwner);
            this.agentMonitorService = agentMonitorService;
        }

        public boolean isValid() {
            return this.agentMonitorService != null;
        }

        public void setContainer(AgentContainer container) throws Exception {
        }

        public void postInit() {
        }

        public void addAgentMonitorListener(AgentMonitorListener agentMonitorListener, AgentMonitorParameters agentMonitorParameters) {
            this.agentMonitorService.addListener(agentMonitorListener, agentMonitorParameters);
        }
    }
}

