/*
 * Decompiled with CFR 0.152.
 */
package aglobex.service.agentmonitor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentMonitorParameters {
    public static final AgentMonitorParameters AGENT_FULL = new AgentMonitorParameters();
    long scanPeriod;
    Set<Monitored> monitored;

    static {
        Monitored m = new Monitored();
        m.monitoredObjects.add(MonitoredObject.AGENT);
        AgentMonitorParameters.AGENT_FULL.monitored.add(m);
    }

    public AgentMonitorParameters() {
        this.scanPeriod = 1000L;
        this.monitored = new HashSet<Monitored>(2);
    }

    public AgentMonitorParameters(long scanPeriod, Set<Monitored> monitored) {
        this.scanPeriod = scanPeriod;
        this.monitored = monitored;
    }

    public Set<MonitoredValue> getMonitoredValuesUnion() {
        HashSet<MonitoredValue> union = new HashSet<MonitoredValue>();
        for (Monitored value : this.monitored) {
            union.addAll(value.monitoredValues);
        }
        return union;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Monitored {
        Set<MonitoredObject> monitoredObjects;
        Map<MonitoredObject, List<String>> monitoredObjectsNames;
        Set<MonitoredValue> monitoredValues;

        public Monitored() {
            this.monitoredObjects = new HashSet<MonitoredObject>(2);
            this.monitoredObjectsNames = null;
            this.monitoredValues = new HashSet<MonitoredValue>(MonitoredValue.FULL_SET);
        }

        public Monitored(Set<MonitoredObject> monitoredObjects, Map<MonitoredObject, List<String>> monitoredObjectsNames, Set<MonitoredValue> monitoredValues) {
            this.monitoredObjects = monitoredObjects;
            this.monitoredObjectsNames = monitoredObjectsNames;
            this.monitoredValues = monitoredValues;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MonitoredObject {
        PLATFORM,
        CONTAINER,
        AGENT,
        SERVICE,
        THREAD;

        public static final int length;

        static {
            length = MonitoredObject.values().length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MonitoredValue {
        NAME("Name"),
        CONTAINER_NAME("Cont. name"),
        CPU_LOAD("CPU Load"),
        CPU_TIME("CPU Time"),
        THREAD_COUNT("Threads"),
        RUNNING_TIME("Run Time"),
        THREADS_CPU_TIME(null);

        public static final int length;
        private final String name;
        public static final HashSet<MonitoredValue> FULL_SET;

        static {
            length = MonitoredValue.values().length;
            FULL_SET = new HashSet(Arrays.asList(MonitoredValue.values()));
        }

        public static String[] getNames(Set<MonitoredValue> monitoredValues) {
            int countNamed = 0;
            for (MonitoredValue monitoredValue : monitoredValues) {
                if (monitoredValue.name == null) continue;
                ++countNamed;
            }
            String[] names = new String[countNamed];
            TreeSet<MonitoredValue> ss = new TreeSet<MonitoredValue>(monitoredValues);
            int i = 0;
            for (MonitoredValue monitoredValue : ss) {
                if (monitoredValue.name == null) continue;
                names[i] = monitoredValue.name;
                ++i;
            }
            return names;
        }

        private MonitoredValue(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

