/*
 * Decompiled with CFR 0.152.
 */
package aglobex.service.agentmonitor;

import aglobe.container.AgentContainer;
import aglobe.container.agent.AgentManager;
import aglobe.ontology.AgentInfo;
import aglobe.platform.Platform;
import aglobe.platform.thread.AglobeThreadPool;
import aglobex.service.agentmonitor.AgentMonitorListener;
import aglobex.service.agentmonitor.AgentMonitorParameters;
import aglobex.service.agentmonitor.AgentMonitorScanned;
import aglobex.service.agentmonitor.AgentMonitorService;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AgentMonitor
implements Runnable {
    private final ThreadMXBean threadMXBean;
    private final AgentMonitorService agentMonitorService;
    private final Set<AgentMonitorListener> listeners = new HashSet<AgentMonitorListener>();
    private final AgentMonitorParameters agentMonitorParameters;

    public AgentMonitor(AgentMonitorService agentMonitorService, AgentMonitorParameters agentMonitorParameters) {
        this.agentMonitorService = agentMonitorService;
        this.agentMonitorParameters = agentMonitorParameters;
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        if (!this.threadMXBean.isThreadCpuTimeSupported()) {
            this.agentMonitorService.logWarning("ThreadCpuTime is not supported!");
        } else {
            this.threadMXBean.setThreadCpuTimeEnabled(true);
        }
    }

    public void addListener(AgentMonitorListener agentMonitorListener) {
        this.listeners.add(agentMonitorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AgentMonitorScanned lastScanned = new AgentMonitorScanned();
        long lastMillis = 0L;
        long currentMillis = 0L;
        long startMillis = System.currentTimeMillis();
        while (true) {
            AgentMonitorScanned scanned = new AgentMonitorScanned();
            LinkedList<AgentContainer> agentContainers = new LinkedList<AgentContainer>(Platform.getContainers());
            for (AgentContainer agentContainer : agentContainers) {
                AgentManager agentManager = agentContainer.getAgentManager();
                List<AgentInfo> agents = agentManager.getRunningAgents();
                for (AgentInfo agentInfo : agents) {
                    Object[] values = new Object[AgentMonitorParameters.MonitoredValue.length];
                    String agentName = agentInfo.getReadableName();
                    values[AgentMonitorParameters.MonitoredValue.NAME.ordinal()] = agentName;
                    values[AgentMonitorParameters.MonitoredValue.CONTAINER_NAME.ordinal()] = agentContainer.getContainerName();
                    ThreadGroup atg = agentManager.getAgentThreadGroup(agentInfo.getName());
                    Thread[] sts = AglobeThreadPool.enumerateThreads(atg);
                    currentMillis = System.currentTimeMillis();
                    Long threadsCpuTime = this.getThreadsCpuTime(sts);
                    values[AgentMonitorParameters.MonitoredValue.THREADS_CPU_TIME.ordinal()] = threadsCpuTime;
                    double load = 0.0;
                    Object lastThreadsCpuTime = lastScanned.getValue(AgentMonitorParameters.MonitoredObject.AGENT, agentName, AgentMonitorParameters.MonitoredValue.THREADS_CPU_TIME);
                    if (lastThreadsCpuTime != null) {
                        load = (double)((threadsCpuTime - (Long)lastThreadsCpuTime) / (currentMillis - lastMillis + 1L)) / 1000000.0;
                    }
                    values[AgentMonitorParameters.MonitoredValue.THREAD_COUNT.ordinal()] = this.getThreadsCount(sts);
                    values[AgentMonitorParameters.MonitoredValue.CPU_LOAD.ordinal()] = load;
                    long runningTime = 0L;
                    currentMillis = System.currentTimeMillis();
                    Object lastRunningTime = lastScanned.getValue(AgentMonitorParameters.MonitoredObject.AGENT, agentName, AgentMonitorParameters.MonitoredValue.RUNNING_TIME);
                    if (lastRunningTime != null) {
                        runningTime = (Long)lastRunningTime + (currentMillis - lastMillis);
                    }
                    values[AgentMonitorParameters.MonitoredValue.RUNNING_TIME.ordinal()] = runningTime;
                    long cpuTime = 0L;
                    Object lastCpuTime = lastScanned.getValue(AgentMonitorParameters.MonitoredObject.AGENT, agentName, AgentMonitorParameters.MonitoredValue.CPU_TIME);
                    if (lastCpuTime != null) {
                        cpuTime = (Long)lastCpuTime + (threadsCpuTime - (Long)lastThreadsCpuTime) / 1000000L;
                    }
                    values[AgentMonitorParameters.MonitoredValue.CPU_TIME.ordinal()] = cpuTime;
                    Map<Object, Object[]> scannedObjectMap = scanned.getObjectMap(AgentMonitorParameters.MonitoredObject.AGENT);
                    scannedObjectMap.put(agentName, values);
                }
            }
            AgentMonitor agentMonitor = this;
            synchronized (agentMonitor) {
                lastScanned = scanned;
            }
            for (AgentMonitorListener agentMonitorListener : this.listeners) {
                agentMonitorListener.afterScanned(lastScanned);
            }
            AgentMonitor agentMonitor2 = this;
            synchronized (agentMonitor2) {
                try {
                    lastMillis = System.currentTimeMillis();
                    this.wait(1000L - (lastMillis - startMillis));
                    startMillis = System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private long getThreadsCpuTime(Thread[] threads) {
        long sum = 0L;
        int i = 0;
        while (i < threads.length) {
            if (threads[i] == null) break;
            sum += this.threadMXBean.getThreadCpuTime(threads[i].getId());
            ++i;
        }
        return sum;
    }

    private int getThreadsCount(Thread[] threads) {
        int i = 0;
        while (i < threads.length) {
            if (threads[i] == null) break;
            ++i;
        }
        return i;
    }
}

