/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.subscribe;

import aglobe.container.agent.CMAgent;
import aglobe.container.task.Task;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;

public abstract class SubscribeParticipantTask
extends Task {
    protected Message subscribeMessage;
    protected Message cancelMessage;
    protected final CMAgent owner;

    public SubscribeParticipantTask(CMAgent owner, Message subscribeMessage) {
        this(owner, subscribeMessage, true);
    }

    public SubscribeParticipantTask(CMAgent owner, Message subscribeMessage, boolean autostart) {
        super(owner);
        this.subscribeMessage = subscribeMessage;
        this.owner = owner;
        if (!"SUBSCRIBE".equalsIgnoreCase(subscribeMessage.getProtocol()) || !"SUBSCRIBE".equalsIgnoreCase(subscribeMessage.getPerformative())) {
            throw new IllegalArgumentException(String.valueOf(subscribeMessage.getProtocol()) + "." + subscribeMessage.getPerformative() + " is not good subscribe combination...");
        }
        if (autostart) {
            owner.addEvent(new Runnable(){

                public void run() {
                    SubscribeParticipantTask.this.start();
                }
            });
        }
    }

    protected void handleIncomingMessage(Message msg) {
        String performative = msg.getPerformative();
        if ("CANCEL_META_PROTOCOL".equalsIgnoreCase(msg.getProtocol()) && "CANCEL".equalsIgnoreCase(performative)) {
            this.cancelMessage = msg;
            this.subscriptionCancelled();
            return;
        }
        this.notUnderstood(msg);
        msg.release();
    }

    public final void start() {
        this.processSubscribe(this.subscribeMessage);
    }

    public final Message getSubscribeMessage() {
        return this.subscribeMessage;
    }

    protected final void notUnderstood(Message msg) {
        this.sendNotUnderstood(msg, null);
    }

    protected abstract void processSubscribe(Message var1);

    protected final void agree() {
        Message re = this.subscribeMessage.getReply();
        re.setPerformative("AGREE");
        re.setContent(this.subscribeMessage.getContent());
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.handleInvisibleContainer("Cannot send agree message", ex);
        }
        re.release();
    }

    protected final void refuse() {
        Message re = this.subscribeMessage.getReply();
        re.setPerformative("REFUSE");
        re.setContent(this.subscribeMessage.getContent());
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.handleInvisibleContainer("Cannot send refuse message", ex);
        }
        re.release();
    }

    public void informResult(Object result, String reason) {
        Message re = this.subscribeMessage.getReply();
        re.setPerformative("INFORM-RESULT");
        re.setContent(result);
        if (reason != null) {
            re.setReason(reason);
        }
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.handleInvisibleContainer("Cannot send inform result message", ex);
        }
        re.release();
    }

    public void informResult(Object result) {
        this.informResult(result, null);
    }

    protected final void failure(Object result, String reason) {
        Message re = this.subscribeMessage.getReply();
        re.setPerformative("FAILURE");
        re.setContent(result);
        if (reason != null) {
            re.setReason(reason);
        }
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.handleInvisibleContainer("Cannot send failure message", ex);
        }
        re.release();
    }

    protected final void failure(Object result) {
        this.failure(result, null);
    }

    protected void subscriptionCancelled() {
        this.sendCancelationResult(true);
    }

    protected final void sendCancelationResult(boolean done) {
        Message m = this.cancelMessage.getReply();
        if (done) {
            m.setPerformative("INFORM-DONE");
        } else {
            m.setPerformative("FAILURE");
        }
        try {
            this.sendMessageAsReference(m);
        }
        catch (InvisibleContainerException ex) {
            if (done) {
                this.cancelTask();
            }
            this.handleInvisibleContainer("Cannot send cancelation result message", ex);
        }
        m.release();
        if (done) {
            this.cancelTask();
        }
    }

    protected void handleInvisibleContainer(String errorMessage, InvisibleContainerException ex) {
        this.owner.logSevere(String.valueOf(errorMessage) + ": " + ex);
    }

    public void cancelTask() {
        if (this.subscribeMessage != null) {
            this.subscribeMessage.release();
            this.subscribeMessage = null;
        }
        if (this.cancelMessage != null) {
            this.cancelMessage.release();
            this.cancelMessage = null;
        }
        super.cancelTask();
    }
}

