/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.subscribe;

import aglobe.container.agent.CMAgent;
import aglobe.container.task.Task;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;

public abstract class SubscribeInitiatorTask
extends Task {
    protected CMAgent owner;
    private Message subscribeMsg;
    protected Address participant;
    protected Object subscribeContent;
    protected Message lastIncommingMessage;
    private Message agreeMessage;

    public SubscribeInitiatorTask(CMAgent owner, Address participant, Object content) {
        this(owner, participant, content, true);
    }

    public SubscribeInitiatorTask(CMAgent owner, Address participant, Object content, boolean autostart) {
        super(owner);
        this.owner = owner;
        this.participant = participant;
        this.subscribeContent = content;
        this.subscribeMsg = Message.newInstance();
        this.subscribeMsg.setPerformative("SUBSCRIBE");
        this.subscribeMsg.setProtocol("SUBSCRIBE");
        this.subscribeMsg.setContent(content);
        this.subscribeMsg.setSender(owner.getAddress());
        this.subscribeMsg.setReceiver(participant);
        if (autostart) {
            this.start();
        }
    }

    public SubscribeInitiatorTask(CMAgent owner, Address participant, Object content, String reason, boolean autostart) {
        super(owner);
        this.owner = owner;
        this.participant = participant;
        this.subscribeContent = content;
        this.subscribeMsg = Message.newInstance();
        this.subscribeMsg.setPerformative("SUBSCRIBE");
        this.subscribeMsg.setProtocol("SUBSCRIBE");
        this.subscribeMsg.setContent(content);
        this.subscribeMsg.setReason(reason);
        this.subscribeMsg.setSender(owner.getAddress());
        this.subscribeMsg.setReceiver(participant);
        if (autostart) {
            this.start();
        }
    }

    public final void start() {
        try {
            this.sendMessage(this.subscribeMsg);
        }
        catch (InvisibleContainerException ex) {
            this.handleInvisibleContainer("Cannot send subscribe message", ex);
            this.cancelTask();
        }
    }

    public final Message getSubscribeMessage() {
        return this.subscribeMsg;
    }

    protected void handleIncomingMessage(Message msg) {
        if (this.lastIncommingMessage != null && this.lastIncommingMessage != this.agreeMessage) {
            this.lastIncommingMessage.release();
        }
        this.lastIncommingMessage = msg;
        String performative = msg.getPerformative();
        if ("SUBSCRIBE".equalsIgnoreCase(msg.getProtocol())) {
            if ("INFORM-RESULT".equalsIgnoreCase(performative)) {
                this.subscribeInformResult(msg.getContent(), msg.getReason());
                return;
            }
            if ("FAILURE".equalsIgnoreCase(performative)) {
                this.interactionFailure(msg.getContent(), msg.getReason());
                return;
            }
            if ("AGREE".equalsIgnoreCase(performative)) {
                this.agreeMessage = msg;
                this.subscribeAgreed();
                return;
            }
            if ("REFUSE".equalsIgnoreCase(performative)) {
                this.subscribeRefused();
                return;
            }
            if ("NOT-UNDERSTOOD".equalsIgnoreCase(performative)) {
                this.subscribeNotUnderstood();
                return;
            }
        } else if ("CANCEL_META_PROTOCOL".equalsIgnoreCase(msg.getProtocol())) {
            if ("INFORM-DONE".equalsIgnoreCase(performative)) {
                this.cancelationInformDone();
                return;
            }
            if ("FAILURE".equalsIgnoreCase(performative)) {
                this.cancelationFailure("Client refuse it");
                return;
            }
        }
        this.notUnderstood(msg);
    }

    protected final void notUnderstood(Message msg) {
        this.sendNotUnderstood(msg, null);
    }

    protected final void notUnderstood() {
        this.notUnderstood(this.lastIncommingMessage);
    }

    public void cancelSubscribtion() {
        if (this.agreeMessage == null) {
            return;
        }
        Message m = this.agreeMessage.getReply();
        m.setPerformative("CANCEL");
        m.setProtocol("CANCEL_META_PROTOCOL");
        try {
            this.sendMessageAsReference(m);
        }
        catch (InvisibleContainerException ex) {
            this.cancelationFailure("Cannot send cancelation message: " + ex);
        }
        m.release();
    }

    protected void subscribeAgreed() {
    }

    protected void subscribeRefused() {
        this.cancelTask();
    }

    protected void subscribeNotUnderstood() {
    }

    protected void subscribeInformResult(Object object, String reason) {
        this.subscribeInformResult(object);
    }

    protected abstract void subscribeInformResult(Object var1);

    protected void interactionFailure(Object object, String reason) {
        this.interactionFailure(object);
    }

    protected void interactionFailure(Object object) {
    }

    protected void cancelationInformDone() {
        this.cancelTask();
    }

    protected void cancelationFailure(String errorMessage) {
        this.owner.logWarning("Subscription cannot be cancelled due to: " + errorMessage);
        this.cancelTask();
    }

    protected void handleInvisibleContainer(String errorMessage, InvisibleContainerException ex) {
        this.owner.logSevere(String.valueOf(errorMessage) + ": " + ex);
    }

    public void cancelTask() {
        if (this.subscribeMsg != null) {
            this.subscribeMsg.release();
            this.subscribeMsg = null;
        }
        if (this.agreeMessage != null) {
            this.agreeMessage.release();
            this.agreeMessage = null;
        }
        if (this.lastIncommingMessage != null) {
            this.lastIncommingMessage.release();
            this.lastIncommingMessage = null;
        }
        super.cancelTask();
    }
}

