/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.request;

import aglobe.container.task.ConversationUnit;
import aglobe.container.task.Task;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;

public abstract class RequestParticipantTask
extends Task {
    protected Message requestMessage;
    private final ConversationUnit owner;

    public RequestParticipantTask(ConversationUnit owner, Message requestMessage) {
        this(owner, requestMessage, true);
    }

    public RequestParticipantTask(ConversationUnit owner, Message requestMessage, boolean autostart) {
        super(owner);
        this.requestMessage = requestMessage;
        this.owner = owner;
        if (!"REQUEST".equalsIgnoreCase(requestMessage.getProtocol()) || !"REQUEST".equalsIgnoreCase(requestMessage.getPerformative())) {
            throw new IllegalArgumentException(String.valueOf(requestMessage.getProtocol()) + "." + requestMessage.getPerformative() + " is not good subscribe combination...");
        }
        if (autostart) {
            owner.getConversationManager().getElementaryConversationEntity().addEvent(new Runnable(){

                public void run() {
                    RequestParticipantTask.this.start();
                }
            });
        }
    }

    public void start() {
        this.processRequest(this.requestMessage);
    }

    protected void handleIncomingMessage(Message msg) {
        this.notUnderstood(msg);
        msg.release();
    }

    protected void notUnderstood(Message msg) {
        this.sendNotUnderstood(msg, null);
    }

    protected abstract void processRequest(Message var1);

    protected void agree() {
        Message re = this.requestMessage.getReply();
        re.setPerformative("AGREE");
        re.setContent(this.requestMessage.getContent());
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.owner.getConversationManager().getElementaryConversationEntity().logSevere("Cannot send request message: " + ex);
        }
        re.release();
    }

    protected void refuse() {
        Message re = this.requestMessage.getReply();
        re.setPerformative("REFUSE");
        re.setContent(this.requestMessage.getContent());
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.owner.getConversationManager().getElementaryConversationEntity().logSevere("Cannot send refuse message: " + ex);
        }
        re.release();
        this.cancelTask();
    }

    protected void informDone() {
        Message re = this.requestMessage.getReply();
        re.setPerformative("INFORM-DONE");
        re.setContent(this.requestMessage.getContent());
        try {
            this.sendMessage(re);
            this.cancelTask();
        }
        catch (InvisibleContainerException ex) {
            this.owner.getConversationManager().getElementaryConversationEntity().logSevere("Cannot send inform done message: " + ex);
        }
        re.release();
    }

    protected void informResult(Object result) {
        Message re = this.requestMessage.getReply();
        re.setPerformative("INFORM-RESULT");
        re.setContent(result);
        try {
            this.sendMessage(re);
            this.cancelTask();
        }
        catch (InvisibleContainerException ex) {
            this.owner.getConversationManager().getElementaryConversationEntity().logSevere("Cannot send inform result message: " + ex);
        }
        re.release();
    }

    protected void failure(Object result, String reason) {
        Message re = this.requestMessage.getReply();
        re.setPerformative("FAILURE");
        re.setContent(result);
        re.setReason(reason);
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.owner.getConversationManager().getElementaryConversationEntity().logSevere("Cannot send failure message: " + ex);
        }
        re.release();
        this.cancelTask();
    }

    protected void failure(Object result) {
        Message re = this.requestMessage.getReply();
        re.setPerformative("FAILURE");
        re.setContent(result);
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.owner.getConversationManager().getElementaryConversationEntity().logSevere("Cannot send failure message: " + ex);
        }
        re.release();
        this.cancelTask();
    }

    public void cancelTask() {
        if (this.requestMessage != null) {
            this.requestMessage.release();
            this.requestMessage = null;
        }
        super.cancelTask();
    }
}

