/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.request;

import aglobe.container.task.ConversationUnit;
import aglobe.container.task.TimeoutTask;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;

public abstract class RequestInitiatorTask
extends TimeoutTask {
    protected Address participant;
    protected Object content;
    protected ConversationUnit owner;
    private static final int DEFAULT_TIMEOUT = 10000;
    public static final String TIMEOUT_TEXT = "TIMEOUT";

    public RequestInitiatorTask(ConversationUnit owner, Address participant, Object content) {
        this(owner, participant, content, true);
    }

    public RequestInitiatorTask(ConversationUnit owner, Address participant, Object content, boolean start) {
        super(owner, 10000);
        this.participant = participant;
        this.content = content;
        this.owner = owner;
        if (start) {
            this.start();
        }
    }

    public void start() {
        Message requestMsg = Message.newInstance("REQUEST", this.owner.getConversationManager().getElementaryConversationEntity().getAddress(), this.participant);
        requestMsg.setProtocol("REQUEST");
        requestMsg.setContent(this.content);
        try {
            this.sendMessage(requestMsg);
        }
        catch (InvisibleContainerException ex) {
            this.owner.getConversationManager().getElementaryConversationEntity().logSevere("Cannot send request message: " + ex);
            this.cancelTask();
        }
        requestMsg.release();
    }

    protected void handleIncomingMessage(Message msg) {
        String performative = msg.getPerformative();
        if (!"REQUEST".equalsIgnoreCase(msg.getProtocol())) {
            this.notUnderstood(msg);
        } else if ("INFORM-DONE".equalsIgnoreCase(performative)) {
            this.informDone();
        } else if ("INFORM-RESULT".equalsIgnoreCase(performative)) {
            this.informResult(msg.getContent());
        } else if (!"NOT-UNDERSTOOD".equalsIgnoreCase(performative)) {
            if ("FAILURE".equalsIgnoreCase(performative)) {
                String stringContent = msg.getReason() instanceof String ? (String)msg.getContent() : msg.getContent().toString();
                this.failure(msg.getContent(), stringContent);
            } else if ("AGREE".equalsIgnoreCase(performative)) {
                this.requestAgreed();
            } else if ("REFUSE".equalsIgnoreCase(performative)) {
                this.requestRefused();
            } else {
                this.notUnderstood(msg);
            }
        }
        msg.release();
    }

    protected void requestAgreed() {
    }

    protected void requestRefused() {
    }

    protected void timeout() {
        this.failure(null, TIMEOUT_TEXT);
    }

    protected void failure(Object result, String reason) {
    }

    protected abstract void informDone();

    protected abstract void informResult(Object var1);

    protected void notUnderstood(Message msg) {
        this.sendNotUnderstood(msg, null);
    }
}

