/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.request;

import aglobe.container.agent.CMAgent;
import aglobe.container.task.Task;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import java.util.Collection;
import java.util.Iterator;

public abstract class MultiRequestInitiatorTask
extends Task {
    protected Collection participants;
    private Iterator participantsIterator;
    private Object content;
    private Address owner;
    private final CMAgent ownerAgent;

    public MultiRequestInitiatorTask(CMAgent owner, Collection participants, Object content) {
        this(owner, participants, content, true);
    }

    public MultiRequestInitiatorTask(CMAgent owner, Collection participants, Object content, boolean autostart) {
        super(owner);
        this.participants = participants;
        this.content = content;
        this.owner = owner.getAddress();
        this.ownerAgent = owner;
        if (autostart) {
            this.start();
        }
    }

    public void start() {
        this.participantsIterator = this.participants.iterator();
        this.sendNextRequest();
    }

    private void sendNextRequest() {
        if (!this.participantsIterator.hasNext()) {
            this.allRefused();
            return;
        }
        Address participant = (Address)this.participantsIterator.next();
        Message requestMsg = Message.newInstance("REQUEST", this.owner, participant);
        requestMsg.setProtocol("REQUEST");
        requestMsg.setContent(this.content);
        try {
            this.sendMessage(requestMsg);
        }
        catch (InvisibleContainerException ex) {
            this.ownerAgent.logSevere("Cannot send request message: " + ex + "\nparticipant will be removed.");
            this.participantsIterator.remove();
        }
        requestMsg.release();
    }

    protected abstract void allRefused();

    protected void handleIncomingMessage(Message msg) {
        String performative = msg.getPerformative();
        if (!"REQUEST".equalsIgnoreCase(msg.getProtocol())) {
            this.notUnderstood(msg);
        } else if ("INFORM-DONE".equalsIgnoreCase(performative)) {
            this.informDone(msg.getSender());
        } else if ("INFORM-RESULT".equalsIgnoreCase(performative)) {
            this.informResult(msg.getSender(), msg.getContent());
        } else if (!"NOT-UNDERSTOOD".equalsIgnoreCase(performative)) {
            String stringContent;
            String string = stringContent = msg.getContent() instanceof String ? (String)msg.getContent() : msg.getContent().toString();
            if ("FAILURE".equalsIgnoreCase(performative)) {
                this.failure(stringContent);
            } else if ("AGREE".equalsIgnoreCase(performative)) {
                this.requestAgreed(msg.getSender());
            } else if ("REFUSE".equalsIgnoreCase(performative)) {
                this.requestRefused();
            } else {
                this.notUnderstood(msg);
            }
        }
        msg.release();
    }

    protected void requestAgreed(Address participant) {
    }

    protected void requestRefused() {
        this.sendNextRequest();
    }

    protected void failure(String reason) {
    }

    protected abstract void informDone(Address var1);

    protected abstract void informResult(Address var1, Object var2);

    protected void notUnderstood(Message msg) {
        this.sendNotUnderstood(msg, null);
    }
}

